/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import dev.hexnowloading.dungeonnowloading.entity.monster.ScuttleEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.FlameProjectileEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class ScuttleFlameThrowerAttackGoal
extends Goal {
    private static final UUID FULL_KNOCKBACK_RESISTANCE_MODIFIER_UUID = UUID.fromString("2a6f22a4-5468-4eed-b100-fe77cdc8bd98");
    private final AttributeModifier FULL_KNOCKBACK_RESISTANCE = new AttributeModifier(FULL_KNOCKBACK_RESISTANCE_MODIFIER_UUID, "Full knockback resistance", 0.5, AttributeModifier.Operation.ADDITION);
    private final AttributeModifier CLOSED_ARMOR = new AttributeModifier(UUID.randomUUID(), "Closed armor bonus", -1.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private final ScuttleEntity scuttleEntity;
    private int nextScanTick;
    private int attackTicks;

    public ScuttleFlameThrowerAttackGoal(ScuttleEntity scuttleEntity) {
        this.scuttleEntity = scuttleEntity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private int nextStartTick() {
        return ScuttleFlameThrowerAttackGoal.m_186073_((int)10);
    }

    private int nextCooldownStartTick() {
        return ScuttleFlameThrowerAttackGoal.m_186073_((int)(100 + this.scuttleEntity.m_217043_().m_188503_(100)));
    }

    public boolean m_8036_() {
        if (this.nextScanTick > 0) {
            --this.nextScanTick;
            return false;
        }
        double DETECTION_RANGE = 5.0;
        boolean hasTargetInRange = this.scuttleEntity.m_5448_() != null && this.scuttleEntity.m_262793_(this.scuttleEntity.m_5448_()) < DETECTION_RANGE * DETECTION_RANGE;
        this.nextScanTick = this.nextStartTick();
        return this.scuttleEntity.isState(ScuttleEntity.ScuttleState.CLOSED) && hasTargetInRange;
    }

    public boolean m_8045_() {
        return this.scuttleEntity.isAttackingState();
    }

    public void m_8056_() {
        AttributeInstance attributeInstance1;
        this.scuttleEntity.setState(ScuttleEntity.ScuttleState.OPENING);
        this.scuttleEntity.triggerMouthOpenAnimation();
        this.scuttleEntity.playShootingOpenSound();
        AttributeInstance attributeInstance = this.scuttleEntity.m_21051_(Attributes.f_22278_);
        if (attributeInstance != null) {
            attributeInstance.m_22118_(this.FULL_KNOCKBACK_RESISTANCE);
        }
        if ((attributeInstance1 = this.scuttleEntity.m_21051_(Attributes.f_22284_)) != null) {
            attributeInstance1.m_22118_(this.CLOSED_ARMOR);
        }
        this.attackTicks = 10;
    }

    public void m_8037_() {
        if (this.attackTicks % 10 == 0) {
            AABB aabb = new AABB(this.scuttleEntity.m_20183_()).m_82400_((double)1.2f);
            List targets = this.scuttleEntity.m_9236_().m_45976_(Player.class, aabb);
            for (Player player : targets) {
                player.m_20254_(5);
                this.scuttleEntity.m_7327_((Entity)player);
            }
        }
        if (this.attackTicks > 0) {
            --this.attackTicks;
        } else {
            switch (this.scuttleEntity.getState()) {
                case OPENING: {
                    this.scuttleEntity.setState(ScuttleEntity.ScuttleState.OPENED);
                    this.scuttleEntity.triggerIdleOpenedAnimation();
                    this.scuttleEntity.playShootingChargeSound();
                    this.attackTicks = 90;
                    break;
                }
                case OPENED: {
                    this.scuttleEntity.setState(ScuttleEntity.ScuttleState.CLOSING);
                    this.scuttleEntity.triggerMouthCloseAnimation();
                    this.attackTicks = 8;
                    break;
                }
                default: {
                    AttributeInstance attributeInstance1;
                    AttributeInstance attributeInstance = this.scuttleEntity.m_21051_(Attributes.f_22278_);
                    if (attributeInstance != null) {
                        attributeInstance.m_22130_(this.FULL_KNOCKBACK_RESISTANCE);
                    }
                    if ((attributeInstance1 = this.scuttleEntity.m_21051_(Attributes.f_22284_)) != null) {
                        attributeInstance1.m_22130_(this.CLOSED_ARMOR);
                    }
                    this.scuttleEntity.setState(ScuttleEntity.ScuttleState.CLOSED);
                    this.scuttleEntity.triggerIdleClosedAnimation();
                    this.nextScanTick = this.nextCooldownStartTick();
                }
            }
        }
        if (this.scuttleEntity.isState(ScuttleEntity.ScuttleState.CLOSING) && this.attackTicks == 7) {
            this.scuttleEntity.playShootingCloseSound();
        }
        if (this.scuttleEntity.isState(ScuttleEntity.ScuttleState.OPENED)) {
            if (this.attackTicks == 70) {
                this.scuttleEntity.playShootingBurstSound();
            }
            if (this.attackTicks == 40) {
                this.scuttleEntity.playShootingStopSound();
            }
            if (this.attackTicks > 20 && this.attackTicks < 70 && this.attackTicks % 2 == 0) {
                this.scuttleEntity.playShootingFlameSound();
                for (int i = 0; i < 4; ++i) {
                    float PROJECTILE_SPEED = 0.3f;
                    float DISTANCE = 1.0f;
                    float rotationRadian = (float)Math.PI / 180 * this.scuttleEntity.m_146908_() + (float)(90 * i) + (float)((int)(180.0f * ((50.0f - (float)this.attackTicks) / 50.0f)));
                    FlameProjectileEntity flameProjectileEntity = new FlameProjectileEntity((LivingEntity)this.scuttleEntity, this.scuttleEntity.m_9236_());
                    flameProjectileEntity.m_5602_((Entity)this.scuttleEntity);
                    flameProjectileEntity.m_37251_((Entity)this.scuttleEntity, 0.0f, this.scuttleEntity.m_146908_() + (float)(90 * i) + (float)((int)(180.0f * ((50.0f - (float)this.attackTicks) / 50.0f))), 0.0f, PROJECTILE_SPEED, DISTANCE);
                    this.scuttleEntity.m_9236_().m_7967_((Entity)flameProjectileEntity);
                }
            }
        }
    }
}

