/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import dev.hexnowloading.dungeonnowloading.entity.ai.StoppableGoal;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperOurosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperOurosPartEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentCallerEntity;
import dev.hexnowloading.dungeonnowloading.entity.monster.ScuttleEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.SpawnMobUtil;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableAxisParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class FairkeeperOurosDropScuttleGoal
extends StoppableGoal {
    private final FairkeeperOurosEntity ouros;
    private final FairkeeperOurosEntity.FairkeeperOurosState state;
    private final int scuttleCount;
    private int attackTicks;
    private int loopCount;
    private FairkeeperOurosPartEntity currentPart;
    private FairkeeperSerpentCallerEntity caller;
    private int playerCount;
    private final int START_UP_DELAY = 40;
    private final int SUMMON_INTERVAL = 20;
    private final int MAX_SCUTTLE_COUNT = 5;

    public FairkeeperOurosDropScuttleGoal(FairkeeperOurosEntity.FairkeeperOurosState state, FairkeeperOurosEntity ouros, int scuttleCount) {
        this.ouros = ouros;
        this.state = state;
        this.scuttleCount = scuttleCount;
    }

    public boolean m_8036_() {
        return this.ouros.m_5448_() != null && this.ouros.m_5448_().m_6084_() && this.ouros.isState(this.state);
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.attackTicks = FairkeeperOurosDropScuttleGoal.m_186073_((int)40);
        this.currentPart = (FairkeeperOurosPartEntity)this.ouros.getChild();
        this.playerCount = 1;
        this.caller = this.ouros.getCaller();
        if (this.caller != null) {
            this.playerCount = this.caller.getParticipatingPlayerCount();
        }
        this.loopCount = Math.min(this.playerCount + this.scuttleCount - 1, 5);
    }

    public void m_8041_() {
        this.ouros.stopAttacking(20);
    }

    public void m_8037_() {
        if (this.attackTicks > 0) {
            --this.attackTicks;
            return;
        }
        if (this.currentPart == null) {
            this.stopGoal();
            return;
        }
        this.currentPart.dropScuttle();
        --this.loopCount;
        if (this.loopCount <= 0) {
            this.stopGoal();
            return;
        }
        this.attackTicks = 20;
        for (int i = 0; i < 4; ++i) {
            FairkeeperOurosPartEntity fairkeeperOurosPartEntity;
            Entity entity = this.currentPart.getChild();
            if (entity instanceof FairkeeperOurosPartEntity && (fairkeeperOurosPartEntity = (FairkeeperOurosPartEntity)entity).isState(FairkeeperOurosPartEntity.FairkeeperOurosPartState.IDLE)) {
                this.currentPart = fairkeeperOurosPartEntity;
                continue;
            }
            this.stopGoal();
        }
    }

    private void summonScuttle() {
        Level level = this.ouros.m_9236_();
        ScuttleEntity scuttle = (ScuttleEntity)DNLEntityTypes.SCUTTLE.get().m_20615_(level);
        scuttle = (ScuttleEntity)SpawnMobUtil.spawnEntityWithRot((Mob)scuttle, this.currentPart.m_20185_(), this.currentPart.m_20186_() - 0.5, this.currentPart.m_20189_(), this.currentPart.m_146908_(), 0.0f, this.ouros.m_9236_());
        scuttle.m_5618_(this.currentPart.m_146908_());
        scuttle.m_5616_(this.currentPart.m_146908_());
        scuttle.f_21355_ = new ResourceLocation("dungeonnowloading", "empty");
        scuttle.m_217045_();
        level.m_7967_((Entity)scuttle);
        this.caller.addMinion(scuttle.m_20148_());
        level.m_6263_(null, this.currentPart.m_20185_(), this.currentPart.m_20186_() - 0.5, this.currentPart.m_20189_(), SoundEvents.f_12558_, SoundSource.BLOCKS, 1.0f, this.ouros.m_9236_().f_46441_.m_188501_() * 0.2f + 0.8f);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(this.currentPart.m_20185_(), this.currentPart.m_20186_(), this.currentPart.m_20189_());
        while (mutableBlockPos.m_123342_() > level.m_141937_() && !level.m_8055_((BlockPos)mutableBlockPos).m_280555_()) {
            mutableBlockPos.m_122173_(Direction.DOWN);
        }
        BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos);
        if (blockState.m_280555_()) {
            ((ServerLevel)level).m_8767_((ParticleOptions)new ScalableAxisParticleType.ScalableAxisParticleData(DNLParticleTypes.REDSTONE_HAZARD_INDICATOR_PARTICLE.get(), 0, 90.0f, 1.25f), (double)((float)mutableBlockPos.m_123341_() + 0.5f), (double)((float)mutableBlockPos.m_123342_() + 1.05f), (double)((float)mutableBlockPos.m_123343_() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

