/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import com.google.common.collect.ImmutableList;
import dev.hexnowloading.dungeonnowloading.entity.ai.StoppableGoal;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosPartEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentCallerEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.BorusArrowEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;

public class FairkeeperBorosShootArrowGoal
extends StoppableGoal {
    private final FairkeeperBorosEntity boros;
    private FairkeeperBorosEntity.FairkeeperBorosState state;
    ShootingPattern pattern;
    private FairkeeperBorosPartEntity currentPart;
    private int arenaSize;
    private BlockPos arenaCenter;
    private int targetIndex = 0;
    private final double speed;
    private List<FairkeeperBorosPartEntity> partList = new ArrayList<FairkeeperBorosPartEntity>();
    private int stoppingTick;
    private int playSoundForPart;
    private boolean forceStop;
    private static final float FULL_ARENA_SIZE = 49.0f;
    private static final int STOP_DURATION = 32;
    private static final int SHOOT_ARROW_TICK = 15;
    private static final int BEAM_TICK = 30;
    private static List<Integer> ODD_PARTS = List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(7), Integer.valueOf(9), Integer.valueOf(11));
    private static List<Integer> EVEN_PARTS = List.of(Integer.valueOf(0), Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(8), Integer.valueOf(10), Integer.valueOf(12));
    private static List<Integer> ALL_PARTS = List.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
    public static ShootingPattern PATTERN_LINE = new ShootingPattern(true, 0.79591835f, (ImmutableList<Triple<ShootingType, List<Integer>, Vec3>>)ImmutableList.of((Object)Triple.of((Object)((Object)ShootingType.NONE), List.of(), (Object)new Vec3(0.0, 0.0, 1.0)), (Object)Triple.of((Object)((Object)ShootingType.BOTH), ODD_PARTS, (Object)new Vec3(0.0, 0.0, -1.0)), (Object)Triple.of((Object)((Object)ShootingType.BOTH), EVEN_PARTS, (Object)new Vec3(0.0, 0.0, -1.0)), (Object)Triple.of((Object)((Object)ShootingType.BOTH), ODD_PARTS, (Object)new Vec3(0.0, 0.0, -1.0))));
    public static ShootingPattern PATTERN_LINE_FAST = new ShootingPattern(true, 0.79591835f, (ImmutableList<Triple<ShootingType, List<Integer>, Vec3>>)ImmutableList.of((Object)Triple.of((Object)((Object)ShootingType.NONE), List.of(), (Object)new Vec3(0.0, 0.0, 1.0)), (Object)Triple.of((Object)((Object)ShootingType.TRIPLE_BOTH), ODD_PARTS, (Object)new Vec3(0.0, 0.0, -1.0)), (Object)Triple.of((Object)((Object)ShootingType.TRIPLE_BOTH), EVEN_PARTS, (Object)new Vec3(0.0, 0.0, -1.0)), (Object)Triple.of((Object)((Object)ShootingType.TRIPLE_BOTH), ODD_PARTS, (Object)new Vec3(0.0, 0.0, -1.0))));
    public static ShootingPattern PATTERN_SLITHER = new ShootingPattern(true, 0.79591835f, (ImmutableList<Triple<ShootingType, List<Integer>, Vec3>>)ImmutableList.of((Object)Triple.of((Object)((Object)ShootingType.NONE), List.of(), (Object)new Vec3(1.0, 0.0, 1.0)), (Object)Triple.of((Object)((Object)ShootingType.RIGHT), ALL_PARTS, (Object)new Vec3(-1.0, 0.0, 1.0))));

    public FairkeeperBorosShootArrowGoal(FairkeeperBorosEntity.FairkeeperBorosState state, FairkeeperBorosEntity boros, double speed, ShootingPattern pattern) {
        this.boros = boros;
        this.state = state;
        this.pattern = pattern;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.boros.m_5448_() != null && this.boros.m_5448_().m_6084_() && this.boros.isState(this.state);
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        FairkeeperSerpentCallerEntity caller = this.boros.getCaller();
        if (caller != null) {
            this.arenaSize = caller.getArenaSize();
            BlockPos callerPos = caller.m_20183_();
            this.arenaCenter = new BlockPos(callerPos.m_123341_(), (int)this.boros.m_20186_(), callerPos.m_123343_());
        }
        this.currentPart = (FairkeeperBorosPartEntity)this.boros.getChild();
        if (this.currentPart == null) {
            this.stopGoal();
            return;
        }
        this.partList.add(this.currentPart);
        for (int i = 0; i < 12; ++i) {
            this.currentPart = (FairkeeperBorosPartEntity)this.currentPart.getChild();
            if (this.currentPart == null) {
                this.stopGoal();
                return;
            }
            this.partList.add(this.currentPart);
        }
        this.targetIndex = 0;
        this.stoppingTick = 0;
        if (this.pattern.shiftStartingPoint) {
            this.rotatePatternToClosest();
        }
    }

    public void m_8041_() {
        this.boros.stopAttacking(20);
    }

    public void m_8037_() {
        if (this.stoppingTick > 0) {
            --this.stoppingTick;
            if (this.stoppingTick == FairkeeperBorosShootArrowGoal.m_186073_((int)30)) {
                this.playSoundForPart = 0;
                ((List)((Triple)this.pattern.positionList().get(this.targetIndex)).getMiddle()).stream().forEach(partIndex -> {
                    ShootingType shootingType = (ShootingType)((Object)((Object)((Triple)this.pattern.positionList().get(this.targetIndex)).getLeft()));
                    FairkeeperBorosPartEntity part = this.partList.get((int)partIndex);
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.LEFT) {
                        this.spawnRedstoneTrail(part, 90.0f, 0.0, 0.0);
                    }
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.RIGHT) {
                        this.spawnRedstoneTrail(part, -90.0f, 0.0, 0.0);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_LEFT) {
                        this.spawnRedstoneTrail(part, 90.0f, -1.5, 0.0);
                        this.spawnRedstoneTrail(part, 90.0f, 0.0, 0.0);
                        this.spawnRedstoneTrail(part, 90.0f, 1.5, 0.0);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_RIGHT) {
                        this.spawnRedstoneTrail(part, -90.0f, -1.5, 0.0);
                        this.spawnRedstoneTrail(part, -90.0f, 0.0, 0.0);
                        this.spawnRedstoneTrail(part, -90.0f, 1.5, 0.0);
                    }
                    if (this.playSoundForPart % 3 == 0) {
                        this.boros.playBeamSound(part.m_20185_(), part.m_20186_(), part.m_20189_(), 3.0f);
                    }
                    ++this.playSoundForPart;
                });
            }
            if (this.stoppingTick == FairkeeperBorosShootArrowGoal.m_186073_((int)15)) {
                this.playSoundForPart = 0;
                ((List)((Triple)this.pattern.positionList().get(this.targetIndex)).getMiddle()).stream().forEach(partIndex -> {
                    ShootingType shootingType = (ShootingType)((Object)((Object)((Triple)this.pattern.positionList().get(this.targetIndex)).getLeft()));
                    FairkeeperBorosPartEntity part = this.partList.get((int)partIndex);
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.LEFT) {
                        this.shootArrow(part, 90.0f, 0.0, 0.0);
                    }
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.RIGHT) {
                        this.shootArrow(part, -90.0f, 0.0, 0.0);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_LEFT) {
                        this.shootArrow(part, 90.0f, -1.5, 0.0);
                        this.shootArrow(part, 90.0f, 0.0, 0.0);
                        this.shootArrow(part, 90.0f, 1.5, 0.0);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_RIGHT) {
                        this.shootArrow(part, -90.0f, -1.5, 0.0);
                        this.shootArrow(part, -90.0f, 0.0, 0.0);
                        this.shootArrow(part, -90.0f, 1.5, 0.0);
                    }
                    if (this.playSoundForPart % 3 == 0) {
                        this.boros.playArrowSound(part.m_20185_(), part.m_20186_(), part.m_20189_(), 3.0f);
                    }
                    ++this.playSoundForPart;
                });
            }
            if (this.stoppingTick <= 0) {
                ++this.targetIndex;
                if (this.targetIndex >= this.pattern.positionList().size()) {
                    this.stopGoal();
                    return;
                }
                double difference = ((Vec3)((Triple)this.pattern.positionList().get(this.targetIndex)).getRight()).m_82556_() - ((Vec3)((Triple)this.pattern.positionList.get(this.targetIndex - 1)).getRight()).m_82556_();
                if (difference * difference < 1.0E-7) {
                    this.stoppingTick = FairkeeperBorosShootArrowGoal.m_186073_((int)32);
                    return;
                }
            } else {
                return;
            }
        }
        float ratio = this.pattern.ratio();
        Vec3 relativeTarget = (Vec3)((Triple)this.pattern.positionList().get(this.targetIndex)).getRight();
        double targetX = (double)((float)this.arenaCenter.m_123341_() + 0.5f) + relativeTarget.f_82479_ * (double)this.arenaSize * (double)ratio;
        double targetZ = (double)((float)this.arenaCenter.m_123343_() + 0.5f) + relativeTarget.f_82481_ * (double)this.arenaSize * (double)ratio;
        BlockPos targetBlockPos = BlockPos.m_274561_((double)targetX, (double)this.boros.m_20186_(), (double)targetZ);
        double distanceSq = this.boros.m_20182_().m_82531_((double)targetBlockPos.m_123341_(), (double)targetBlockPos.m_123342_(), (double)targetBlockPos.m_123343_());
        if (distanceSq < 1.5) {
            if (((List)((Triple)this.pattern.positionList.get(this.targetIndex)).getMiddle()).isEmpty()) {
                ++this.targetIndex;
            } else {
                this.stoppingTick = FairkeeperBorosShootArrowGoal.m_186073_((int)32);
                return;
            }
        }
        this.boros.m_21566_().m_6849_((double)targetBlockPos.m_123341_(), (double)targetBlockPos.m_123342_(), (double)targetBlockPos.m_123343_(), this.speed);
    }

    private void shootArrow(FairkeeperBorosPartEntity partEntity, float angleOffset, double rxOffset, double rzOffset) {
        double viewDistance = 2.0;
        float borosFacingYaw = partEntity.m_146908_();
        double finalAngle = Math.toRadians(borosFacingYaw - angleOffset);
        double cosFinal = Math.cos(finalAngle);
        double sinFinal = Math.sin(finalAngle);
        Vec3 shootDirection = new Vec3(-sinFinal, 0.0, cosFinal).m_82541_();
        double rotatedRxOffset = rxOffset * cosFinal - rzOffset * sinFinal;
        double rotatedRzOffset = rxOffset * sinFinal + rzOffset * cosFinal;
        Vec3 startPos = new Vec3(partEntity.m_20185_() + rotatedRxOffset, partEntity.m_20186_() + partEntity.m_20191_().m_82376_() * (double)0.3f, partEntity.m_20189_() + rotatedRzOffset);
        Vec3 arrowPos = startPos.m_82549_(shootDirection.m_82490_(viewDistance));
        BorusArrowEntity arrow = new BorusArrowEntity((LivingEntity)this.boros, this.boros.m_9236_());
        arrow.m_146884_(arrowPos);
        arrow.m_37251_((Entity)partEntity, partEntity.m_146909_(), borosFacingYaw - angleOffset, 0.0f, 2.0f, 1.0f);
        this.boros.m_9236_().m_7967_((Entity)arrow);
    }

    private void spawnRedstoneTrail(FairkeeperBorosPartEntity partEntity, float angleOffset, double rxOffset, double rzOffset) {
        double viewDistance = 2.0;
        float borosFacingYaw = partEntity.m_146908_();
        double finalAngle = Math.toRadians(borosFacingYaw - angleOffset);
        double cosFinal = Math.cos(finalAngle);
        double sinFinal = Math.sin(finalAngle);
        Vec3 beamDirection = new Vec3(-sinFinal, 0.0, cosFinal).m_82541_();
        double rotatedRxOffset = rxOffset * cosFinal - rzOffset * sinFinal;
        double rotatedRzOffset = rxOffset * sinFinal + rzOffset * cosFinal;
        Vec3 startPos = new Vec3(partEntity.m_20185_() + rotatedRxOffset, partEntity.m_20186_() + partEntity.m_20191_().m_82376_() * (double)0.3f, partEntity.m_20189_() + rotatedRzOffset).m_82549_(beamDirection.m_82490_(viewDistance));
        for (int i = 0; i <= 30; ++i) {
            Vec3 particlePos = startPos.m_82549_(beamDirection.m_82490_((double)i));
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.ARROW_HAZARD_INDICATOR.get(), 0.5f);
            ((ServerLevel)partEntity.m_9236_()).m_8767_((ParticleOptions)particleData, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void rotatePatternToClosest() {
        ImmutableList<Triple<ShootingType, List<Integer>, Vec3>> originalList = this.pattern.positionList();
        Vec3 firstVector = (Vec3)((Triple)originalList.get(0)).getRight();
        double minDistance = Double.MAX_VALUE;
        int bestRotation = 0;
        Vec3 borosPos = this.boros.m_20182_();
        for (int angle : List.of(Integer.valueOf(0), Integer.valueOf(90), Integer.valueOf(180), Integer.valueOf(270))) {
            Vec3 rotatedVector = this.rotateVector(firstVector, angle);
            Vec3 absolutePos = new Vec3((double)this.arenaCenter.m_123341_() + rotatedVector.f_82479_ * (double)this.arenaSize * (double)this.pattern.ratio(), this.boros.m_20186_(), (double)this.arenaCenter.m_123343_() + rotatedVector.f_82481_ * (double)this.arenaSize * (double)this.pattern.ratio());
            double distance = borosPos.m_82557_(absolutePos);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            bestRotation = angle;
        }
        ArrayList<Triple> rotatedList = new ArrayList<Triple>();
        for (Triple entry : originalList) {
            Vec3 rotatedVec = this.rotateVector((Vec3)entry.getRight(), bestRotation);
            rotatedList.add(Triple.of((Object)((Object)((ShootingType)((Object)entry.getLeft()))), (Object)((List)entry.getMiddle()), (Object)rotatedVec));
        }
        this.pattern = new ShootingPattern(this.pattern.shiftStartingPoint(), this.pattern.ratio(), (ImmutableList<Triple<ShootingType, List<Integer>, Vec3>>)ImmutableList.copyOf(rotatedList));
    }

    private Vec3 rotateVector(Vec3 vector, int degrees) {
        double radians = Math.toRadians(degrees);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double newX = vector.f_82479_ * cos - vector.f_82481_ * sin;
        double newZ = vector.f_82479_ * sin + vector.f_82481_ * cos;
        return new Vec3(newX, vector.f_82480_, newZ);
    }

    private record ShootingPattern(boolean shiftStartingPoint, float ratio, ImmutableList<Triple<ShootingType, List<Integer>, Vec3>> positionList) {
    }

    private static enum ShootingType {
        NONE,
        LEFT,
        RIGHT,
        BOTH,
        TRIPLE_LEFT,
        TRIPLE_RIGHT,
        TRIPLE_BOTH;

    }
}

