/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentCallerEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class FairkeeperBorosAwakenGoal
extends Goal {
    private final FairkeeperBorosEntity fairkeeper;
    private Vec3 initialTarget;
    private Vec3 finalTarget;
    private boolean movingHorizontally;
    private static final double THRESHOLD = 2.0;

    public FairkeeperBorosAwakenGoal(FairkeeperBorosEntity fairkeeper) {
        this.fairkeeper = fairkeeper;
        this.movingHorizontally = false;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        return this.fairkeeper.isState(FairkeeperBorosEntity.FairkeeperBorosState.AWAKENING) && this.fairkeeper.getCaller() != null;
    }

    public void m_8056_() {
        FairkeeperSerpentCallerEntity caller = this.fairkeeper.getCaller();
        int verticalOffset = caller.getVerticalOffset();
        int horizontalOffset = caller.getHorizontalOffset();
        BlockPos callerPos = caller.m_20183_();
        Direction direction = caller.m_6350_();
        this.initialTarget = new BlockPos((Vec3i)callerPos.m_5484_(direction.m_122428_(), horizontalOffset).m_6625_(verticalOffset)).m_252807_().m_82520_(0.0, -0.5, 0.0);
        this.finalTarget = new BlockPos((Vec3i)callerPos.m_5484_(direction.m_122427_(), horizontalOffset).m_6625_(verticalOffset)).m_252807_().m_82520_(0.0, -0.5, 0.0);
        this.fairkeeper.setAwakenEndPos(this.initialTarget);
        this.fairkeeper.playMouthOpen();
        this.fairkeeper.f_19794_ = true;
    }

    public void m_8037_() {
        if (!this.movingHorizontally) {
            double deltaY = this.fairkeeper.m_20186_() - this.initialTarget.f_82480_;
            if (deltaY * deltaY < 25.0) {
                if (this.fairkeeper.f_19794_) {
                    this.fairkeeper.f_19794_ = false;
                }
                this.fairkeeper.m_246865_(this.fairkeeper.m_20154_().m_82490_((double)0.05f));
            }
            if (this.fairkeeper.m_20096_()) {
                this.movingHorizontally = true;
                this.fairkeeper.setCanDestroyBlocks(true);
            }
        } else {
            this.fairkeeper.m_21566_().m_6849_(this.finalTarget.f_82479_, this.finalTarget.f_82480_, this.finalTarget.f_82481_, (double)1.1f);
            this.lookTowardTarget();
            double deltaX = this.fairkeeper.m_20185_() - this.finalTarget.f_82479_;
            double deltaZ = this.fairkeeper.m_20189_() - this.finalTarget.f_82481_;
            if (deltaX * deltaX + deltaZ * deltaZ < 4.0) {
                this.fairkeeper.playMouthClose();
                this.fairkeeper.stopAttacking(20);
            }
        }
    }

    private void lookTowardTarget() {
        double directionX = this.finalTarget.f_82479_ - this.fairkeeper.m_20185_();
        double directionZ = this.finalTarget.f_82481_ - this.fairkeeper.m_20189_();
        double yaw = Math.toDegrees(Math.atan2(directionZ, directionX)) - 90.0;
        this.fairkeeper.m_146922_((float)yaw);
        this.fairkeeper.f_20883_ = (float)yaw;
    }

    public boolean m_183429_() {
        return true;
    }
}

