/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import com.google.common.collect.ImmutableList;
import dev.hexnowloading.dungeonnowloading.entity.boss.ChaosSpawnerEntity;
import dev.hexnowloading.dungeonnowloading.util.WeightedRandomBag;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class ChaosSpawnerSummonMobGoal
extends Goal {
    private final ChaosSpawnerEntity chaosSpawnerEntity;
    private int summonCount;
    private int maxSummonLimit;
    private static final ImmutableList<BlockPos> MOB_SUMMON_POS = ImmutableList.of((Object)new BlockPos(5, 1, 0), (Object)new BlockPos(-5, 1, 0), (Object)new BlockPos(0, 1, 5), (Object)new BlockPos(0, 1, -5), (Object)new BlockPos(5, 1, 2), (Object)new BlockPos(-5, 1, 2), (Object)new BlockPos(2, 1, 5), (Object)new BlockPos(2, 1, -5), (Object)new BlockPos(5, 1, -2), (Object)new BlockPos(-5, 1, -2), (Object)new BlockPos(-2, 1, 5), (Object)new BlockPos(-2, 1, -5), (Object[])new BlockPos[0]);

    public ChaosSpawnerSummonMobGoal(ChaosSpawnerEntity chaosSpawnerEntity) {
        this.chaosSpawnerEntity = chaosSpawnerEntity;
    }

    public boolean m_8036_() {
        if (this.chaosSpawnerEntity.isAttacking(ChaosSpawnerEntity.State.SUMMON_MOB) && this.chaosSpawnerEntity.m_5448_() != null) {
            if (this.withinSummonLimit()) {
                return true;
            }
            this.chaosSpawnerEntity.stopAttacking(0);
            return false;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.chaosSpawnerEntity.isAttacking(ChaosSpawnerEntity.State.SUMMON_MOB) && this.chaosSpawnerEntity.m_5448_() != null;
    }

    public void m_8056_() {
        super.m_8056_();
        this.chaosSpawnerEntity.triggerSummonAnimation();
        this.chaosSpawnerEntity.setAttackTick(100);
    }

    public void m_8037_() {
        if (this.chaosSpawnerEntity.getAttackTick() == 100) {
            this.chaosSpawnerEntity.m_5496_(this.chaosSpawnerEntity.getScreechSound(), 2.0f, 1.0f);
            this.summonCount = Math.max(0, this.maxSummonLimit);
            double d = this.chaosSpawnerEntity.m_20185_();
            double e = this.chaosSpawnerEntity.m_20186_();
            double f = this.chaosSpawnerEntity.m_20189_();
            ((ServerLevel)this.chaosSpawnerEntity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, d, e, f, 20, 3.0, 3.0, 3.0, 0.0);
            for (int i = 0; i < this.summonCount; ++i) {
                WeightedRandomBag<String> mobWeightBag = new WeightedRandomBag<String>();
                if (this.chaosSpawnerEntity.getPhase() == 1) {
                    mobWeightBag.addEntry("Zombie", 3.0);
                    mobWeightBag.addEntry("Skeleton", 2.0);
                    mobWeightBag.addEntry("Spider", 2.0);
                } else if (this.chaosSpawnerEntity.getPhase() == 2) {
                    mobWeightBag.addEntry("Zombie", 9.0);
                    mobWeightBag.addEntry("Skeleton", 6.0);
                    mobWeightBag.addEntry("Spider", 6.0);
                    mobWeightBag.addEntry("Diamond Zombie", 2.0);
                    mobWeightBag.addEntry("Diamond Skeleton", 2.0);
                    mobWeightBag.addEntry("Invisible Spider", 2.0);
                    mobWeightBag.addEntry("Spider Jokey", 1.0);
                    mobWeightBag.addEntry("Baby Zombie", 1.0);
                }
                this.summonMob((String)mobWeightBag.getRandom(), this.chaosSpawnerEntity.m_20183_().m_121955_((Vec3i)MOB_SUMMON_POS.get(Math.min(i, MOB_SUMMON_POS.size() - 1))));
            }
        }
        if (this.chaosSpawnerEntity.getAttackTick() == 0) {
            this.chaosSpawnerEntity.stopAttacking(60);
        }
    }

    private boolean withinSummonLimit() {
        List mobList = this.chaosSpawnerEntity.m_9236_().m_45976_(Monster.class, this.chaosSpawnerEntity.m_20191_().m_82400_(this.chaosSpawnerEntity.getFollowDistance() / 2.0));
        this.maxSummonLimit = Math.min(2 + this.chaosSpawnerEntity.getParticipatingPlayerCount() * 2, 12);
        return mobList.size() < this.maxSummonLimit;
    }

    private void summonMob(String summoningMob, BlockPos summonPos) {
        Level level = this.chaosSpawnerEntity.m_9236_();
        double d = summonPos.m_123341_();
        double e = (double)summonPos.m_123342_() + 1.0;
        double f = summonPos.m_123343_();
        ((ServerLevel)this.chaosSpawnerEntity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, d, e, f, 10, 0.5, 0.5, 0.5, 0.0);
        switch (summoningMob) {
            case "Zombie": {
                Zombie zombie = (Zombie)EntityType.f_20501_.m_20615_(level);
                if (zombie == null) break;
                zombie.m_20035_(summonPos, 0.0f, 0.0f);
                zombie.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(summonPos), MobSpawnType.MOB_SUMMONED, null, null);
                this.noDropChance((Monster)zombie);
                level.m_7967_((Entity)zombie);
                break;
            }
            case "Skeleton": {
                Skeleton skeleton = (Skeleton)EntityType.f_20524_.m_20615_(level);
                if (skeleton == null) break;
                skeleton.m_20035_(summonPos, 0.0f, 0.0f);
                skeleton.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(summonPos), MobSpawnType.MOB_SUMMONED, null, null);
                this.noDropChance((Monster)skeleton);
                level.m_7967_((Entity)skeleton);
                break;
            }
            case "Spider": {
                Spider spider = (Spider)EntityType.f_20479_.m_20615_(level);
                if (spider == null) break;
                spider.m_20035_(summonPos, 0.0f, 0.0f);
                spider.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(summonPos), MobSpawnType.MOB_SUMMONED, null, null);
                level.m_7967_((Entity)spider);
                break;
            }
            case "Diamond Zombie": {
                Zombie zombie = (Zombie)EntityType.f_20501_.m_20615_(level);
                if (zombie == null) break;
                zombie.m_20035_(summonPos, 0.0f, 0.0f);
                zombie.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(summonPos), MobSpawnType.MOB_SUMMONED, null, null);
                zombie.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42472_));
                zombie.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42388_));
                zombie.m_6844_(EquipmentSlot.MAINHAND).m_41663_(Enchantments.f_44977_, 2);
                this.noDropChance((Monster)zombie);
                level.m_7967_((Entity)zombie);
                break;
            }
            case "Diamond Skeleton": {
                Skeleton skeleton = (Skeleton)EntityType.f_20524_.m_20615_(level);
                if (skeleton == null) break;
                skeleton.m_20035_(summonPos, 0.0f, 0.0f);
                skeleton.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(summonPos), MobSpawnType.MOB_SUMMONED, null, null);
                skeleton.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42472_));
                skeleton.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                skeleton.m_6844_(EquipmentSlot.MAINHAND).m_41663_(Enchantments.f_44988_, 2);
                this.noDropChance((Monster)skeleton);
                level.m_7967_((Entity)skeleton);
                break;
            }
            case "Invisible Spider": {
                Spider spider = (Spider)EntityType.f_20479_.m_20615_(level);
                if (spider == null) break;
                spider.m_20035_(summonPos, 0.0f, 0.0f);
                spider.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(summonPos), MobSpawnType.MOB_SUMMONED, null, null);
                spider.m_7292_(new MobEffectInstance(MobEffects.f_19609_, -1));
                level.m_7967_((Entity)spider);
                break;
            }
            case "Spider Jokey": {
                Spider spider = (Spider)EntityType.f_20479_.m_20615_(level);
                if (spider == null) break;
                spider.m_20035_(summonPos, 0.0f, 0.0f);
                spider.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(summonPos), MobSpawnType.MOB_SUMMONED, null, null);
                Skeleton skeleton = (Skeleton)EntityType.f_20524_.m_20615_(level);
                if (skeleton == null) break;
                skeleton.m_20035_(summonPos, 0.0f, 0.0f);
                skeleton.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(summonPos), MobSpawnType.MOB_SUMMONED, null, null);
                skeleton.m_20329_((Entity)spider);
                this.noDropChance((Monster)skeleton);
                level.m_7967_((Entity)spider);
                level.m_7967_((Entity)skeleton);
                break;
            }
            case "Baby Zombie": {
                Zombie zombie = (Zombie)EntityType.f_20501_.m_20615_(level);
                if (zombie == null) break;
                zombie.m_20035_(summonPos, 0.0f, 0.0f);
                zombie.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(summonPos), MobSpawnType.MOB_SUMMONED, null, null);
                zombie.m_6863_(true);
                zombie.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42472_));
                zombie.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42473_));
                zombie.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42474_));
                zombie.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42475_));
                zombie.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42391_));
                zombie.m_6844_(EquipmentSlot.MAINHAND).m_41663_(Enchantments.f_44977_, 4);
                this.noDropChance((Monster)zombie);
                level.m_7967_((Entity)zombie);
            }
        }
    }

    private void noDropChance(Monster monster) {
        monster.m_21409_(EquipmentSlot.HEAD, 0.0f);
        monster.m_21409_(EquipmentSlot.CHEST, 0.0f);
        monster.m_21409_(EquipmentSlot.LEGS, 0.0f);
        monster.m_21409_(EquipmentSlot.FEET, 0.0f);
        monster.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        monster.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
    }
}

