/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import dev.hexnowloading.dungeonnowloading.entity.boss.ChaosSpawnerEntity;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class ChaosSpawnerPushGoal
extends Goal {
    private final ChaosSpawnerEntity chaosSpawnerEntity;

    public ChaosSpawnerPushGoal(ChaosSpawnerEntity chaosSpawnerEntity) {
        this.chaosSpawnerEntity = chaosSpawnerEntity;
    }

    public boolean m_8036_() {
        return this.chaosSpawnerEntity.isAttacking(ChaosSpawnerEntity.State.PUSH) && this.chaosSpawnerEntity.m_5448_() != null;
    }

    public void m_8056_() {
        super.m_8056_();
        this.chaosSpawnerEntity.triggerSmashAttackAnimation();
        this.chaosSpawnerEntity.setAttackTick(100);
    }

    public void m_8037_() {
        if (this.chaosSpawnerEntity.getAttackTick() == 66) {
            this.chaosSpawnerEntity.m_5496_(SoundEvents.f_11913_, 3.0f, 1.0f);
            ((ServerLevel)this.chaosSpawnerEntity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.chaosSpawnerEntity.m_20185_(), this.chaosSpawnerEntity.m_20186_(), this.chaosSpawnerEntity.m_20189_(), 50, 3.0, 0.0, 3.0, 0.0);
            AABB aabb = new AABB(this.chaosSpawnerEntity.m_20183_()).m_82400_(8.0);
            List targets = this.chaosSpawnerEntity.m_9236_().m_45976_(LivingEntity.class, aabb);
            for (LivingEntity mob : targets) {
                if (mob == this.chaosSpawnerEntity) continue;
                if (mob instanceof Player) {
                    Player player = (Player)mob;
                    this.pushNearbyPlayers(player);
                    continue;
                }
                this.pushNearbyMobs(mob);
            }
        }
        if (this.chaosSpawnerEntity.getAttackTick() == 0) {
            this.chaosSpawnerEntity.stopAttacking(60);
        }
    }

    private void pushNearbyMobs(LivingEntity mob) {
        double knockbackStrength = 12.0;
        int damageAmount = (int)(this.chaosSpawnerEntity.getAttackDamage() * (double)0.9f);
        double x = mob.m_20185_() - this.chaosSpawnerEntity.m_20185_();
        double z = mob.m_20189_() - this.chaosSpawnerEntity.m_20189_();
        double a = Math.max(x * x + z * z, 0.001);
        mob.m_5997_(x / a * knockbackStrength, 0.2, z / a * knockbackStrength);
        mob.m_6469_(this.chaosSpawnerEntity.m_269291_().m_269364_((LivingEntity)this.chaosSpawnerEntity), (float)damageAmount);
    }

    private void pushNearbyPlayers(Player player) {
        int damageAmount;
        double knockbackStrength = 12.0;
        if (player.m_21254_()) {
            player.m_36384_(true);
            damageAmount = (int)(this.chaosSpawnerEntity.getAttackDamage() * (double)0.45f);
        } else {
            damageAmount = (int)(this.chaosSpawnerEntity.getAttackDamage() * (double)0.9f);
        }
        double x = player.m_20185_() - this.chaosSpawnerEntity.m_20185_();
        double z = player.m_20189_() - this.chaosSpawnerEntity.m_20189_();
        double a = Math.max(x * x + z * z, 0.001);
        player.m_5997_(x / a * knockbackStrength, 0.2, z / a * knockbackStrength);
        player.m_6469_(this.chaosSpawnerEntity.m_269291_().m_269333_((LivingEntity)this.chaosSpawnerEntity), (float)damageAmount);
    }
}

