/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.components;

import dev.hexnowloading.dungeonnowloading.components.VertexNodeConnectionContext;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexArrowProjectileEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.potion.VertexTransmissionEffect;
import dev.hexnowloading.dungeonnowloading.registry.DNLMobEffects;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.util.DNLMath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VertexNode {
    private List<VertexNodeConnectionContext> connectedNodes = new ArrayList<VertexNodeConnectionContext>();
    private Entity entityRef;
    private boolean attemptedConnection = false;
    private static final double BEAM_PARTICLE_SPACING = 0.1;
    private static final double BEAM_INITIAL_PARTICLE_SPACING = 0.8;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MIN = 0.2f;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MAX = 0.4f;
    private static final float BEAM_PARTICLE_SCALE = 0.05f;
    private static final double BEAM_PLAYER_EYE_LEVEL_OFFSET = -0.5;
    private static final float MAX_RANDOM_PARTICLE_SCALE_MULTIPLIER = 3.0f;
    private static final int MAX_CONNECTION_COUNT = 2;
    private static final double MAX_CONNECTION_RADIUS = 10.0;
    private static final double BEAM_HITBOX_RADIUS = 0.5;
    private static final int ENTITY_EFFECT_DURATION_TICKS = 60;

    public VertexNode(Entity entityRef) {
        this.entityRef = entityRef;
    }

    public int getConnectionCount() {
        return this.connectedNodes.size();
    }

    public boolean attemptedConnection() {
        return this.attemptedConnection;
    }

    public boolean connectionLimitReached() {
        return this.getConnectionCount() >= 2;
    }

    public void disconnect_all() {
        for (VertexNodeConnectionContext connectedNodeCtx : this.connectedNodes) {
            connectedNodeCtx.getVertexNode().disconnectNode(this);
        }
        this.connectedNodes.clear();
        this.attemptedConnection = false;
    }

    public void disconnectNode(VertexNode node) {
        this.connectedNodes.removeIf(nodeConnectionCtx -> nodeConnectionCtx.getVertexNode() == node);
    }

    public void connectNode(VertexNode node, boolean isBeamParent) {
        this.connectedNodes.add(new VertexNodeConnectionContext(node, isBeamParent));
        this.entityRef.m_9236_().m_6263_(null, this.entityRef.m_20185_(), this.entityRef.m_20186_(), this.entityRef.m_20189_(), DNLSounds.VERTEX_NODE_CONNECT.get(), SoundSource.NEUTRAL, 0.5f, 1.2f / (DNLMath.randomRange(0.0f, 1.0f) * 0.2f + 0.9f));
    }

    public void connectToNearbyNodes(Entity sourceEntity) {
        this.connectToNearbyNodes(sourceEntity, false);
    }

    public void connectToNearbyNodes(Entity sourceEntity, boolean isReconnectionCase) {
        List<VertexNode> nearbyNodes = this.getNearbyNodes(sourceEntity);
        for (VertexNode node : nearbyNodes) {
            this.connectNode(node, true);
            node.connectNode(this, false);
            if (isReconnectionCase) continue;
            this.spawnInitialParticleBeamVFX(sourceEntity.m_9236_(), this.getEyeLevelPositionAdjusted(sourceEntity), this.getEyeLevelPositionAdjusted(node.entityRef));
        }
        this.attemptedConnection = true;
    }

    public void tick(Entity entity) {
        boolean isClientSide = entity.m_9236_().f_46443_;
        for (VertexNodeConnectionContext connectedNodeContext : new ArrayList<VertexNodeConnectionContext>(this.connectedNodes)) {
            LivingEntity livingEntity2;
            VertexNode connectedNode = connectedNodeContext.getVertexNode();
            boolean isBeamParent = connectedNodeContext.isBeamParent();
            if (isBeamParent) {
                this.spawnParticleBeamVFX(entity.m_9236_(), this.getEyeLevelPositionAdjusted(entity), this.getEyeLevelPositionAdjusted(connectedNode.entityRef));
            }
            if (!isClientSide && isBeamParent && entity.f_19797_ % 2 == 0) {
                List<LivingEntity> entitiesTouchingBeam = this.getLivingEntitiesTouchingBeam(entity.m_9236_(), entity.m_20182_(), connectedNode.entityRef.m_20182_(), 0.5);
                entitiesTouchingBeam.remove(this.entityRef);
                entitiesTouchingBeam.remove(connectedNode.entityRef);
                entitiesTouchingBeam.removeIf(livingEntity -> livingEntity instanceof FairkeeperSerpentEntity);
                for (LivingEntity livingEntity3 : entitiesTouchingBeam) {
                    VertexNode entityInBeamVertexNode;
                    VertexTransmissionEffect vtx;
                    MobEffect mobEffect;
                    MobEffectInstance inst;
                    int slownessDurationTicks = 60;
                    int slownessAmplifier = this.getConnectionCount();
                    int vertexTransDurationTicks = 60;
                    int vertexTransAmplifier = 0;
                    livingEntity3.m_7292_(new MobEffectInstance(MobEffects.f_19597_, slownessDurationTicks, slownessAmplifier));
                    boolean entityHasEffect = livingEntity3.m_21023_(DNLMobEffects.VERTEX_TRANSMISSION.get());
                    if (!entityHasEffect) {
                        livingEntity3.m_7292_(new MobEffectInstance(DNLMobEffects.VERTEX_TRANSMISSION.get(), vertexTransDurationTicks, vertexTransAmplifier));
                    } else if (entity.f_19797_ % 10 == 0) {
                        livingEntity3.m_7292_(new MobEffectInstance(DNLMobEffects.VERTEX_TRANSMISSION.get(), vertexTransDurationTicks, vertexTransAmplifier));
                        inst = livingEntity3.m_21124_(DNLMobEffects.VERTEX_TRANSMISSION.get());
                        if (inst != null && (mobEffect = inst.m_19544_()) instanceof VertexTransmissionEffect) {
                            vtx = (VertexTransmissionEffect)mobEffect;
                            vtx.markAsReconnectionCase(livingEntity3.m_20148_());
                        }
                    }
                    if ((inst = livingEntity3.m_21124_(DNLMobEffects.VERTEX_TRANSMISSION.get())) == null || !((mobEffect = inst.m_19544_()) instanceof VertexTransmissionEffect) || (entityInBeamVertexNode = (vtx = (VertexTransmissionEffect)mobEffect).getVertexNode(livingEntity3.m_20148_())) == null || entityInBeamVertexNode.getConnectionCount() != 0) continue;
                    vtx.setNoConnectionBeamDamageCase(livingEntity3.m_20148_(), true);
                }
            }
            boolean nodeShouldDisconnect = connectedNode.entityRef.m_213877_() || !connectedNode.entityRef.m_6084_() || connectedNode.entityRef.m_20280_(this.entityRef) > 100.0;
            Entity entity2 = connectedNode.entityRef;
            if (entity2 instanceof LivingEntity && (livingEntity2 = (LivingEntity)entity2).m_21224_()) {
                nodeShouldDisconnect = true;
            }
            if (isClientSide || !nodeShouldDisconnect) continue;
            connectedNode.disconnect_all();
        }
    }

    private Vec3 getEyeLevelPositionAdjusted(Entity entity) {
        Vec3 finalPos = entity.m_146892_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            finalPos = new Vec3(finalPos.f_82479_, finalPos.f_82480_ + -0.5, finalPos.f_82481_);
        }
        return finalPos;
    }

    private List<VertexNode> getNearbyNodes(Entity sourceEntity) {
        double radius_squared = 100.0;
        return sourceEntity.m_9236_().m_45976_(Entity.class, sourceEntity.m_20191_().m_82400_(10.0)).stream().filter(potentialNodeEntity -> potentialNodeEntity != sourceEntity).filter(potentialNodeEntity -> {
            LivingEntity livingEntity;
            VertexArrowProjectileEntity arrowEntity;
            return potentialNodeEntity instanceof VertexArrowProjectileEntity && (arrowEntity = (VertexArrowProjectileEntity)((Object)potentialNodeEntity)).isFullyPowered() || potentialNodeEntity instanceof LivingEntity && (livingEntity = (LivingEntity)potentialNodeEntity).m_21023_(DNLMobEffects.VERTEX_TRANSMISSION.get());
        }).filter(nodeEntity -> nodeEntity.m_20280_(sourceEntity) <= radius_squared).sorted(Comparator.comparingDouble(nodeEntity -> nodeEntity.m_20280_(sourceEntity))).map(nodeEntity -> {
            if (nodeEntity instanceof VertexArrowProjectileEntity) {
                VertexArrowProjectileEntity arrowEntity = (VertexArrowProjectileEntity)((Object)nodeEntity);
                return arrowEntity.getVertexNode();
            }
            LivingEntity livingEntity = (LivingEntity)nodeEntity;
            return this.getComponentFromEffect(livingEntity);
        }).filter(Objects::nonNull).filter(node -> node.getConnectionCount() < 2).limit(2L).collect(Collectors.toList());
    }

    private VertexNode getComponentFromEffect(LivingEntity entity) {
        MobEffectInstance effectInstance;
        MobEffect mobEffect;
        if (entity.m_21023_(DNLMobEffects.VERTEX_TRANSMISSION.get()) && (mobEffect = (effectInstance = entity.m_21124_(DNLMobEffects.VERTEX_TRANSMISSION.get())).m_19544_()) instanceof VertexTransmissionEffect) {
            VertexTransmissionEffect customEffect = (VertexTransmissionEffect)mobEffect;
            return customEffect.getVertexNode(entity.m_20148_());
        }
        return null;
    }

    private void spawnParticleBeamVFX(Level level, Vec3 startPos, Vec3 endPos) {
        Vec3 line = endPos.m_82546_(startPos);
        double distance = line.m_82553_();
        int numberOfParticles = (int)Math.ceil(distance / 0.1);
        for (int i = 0; i <= numberOfParticles; ++i) {
            int randomNumber = ThreadLocalRandom.current().nextInt(3);
            if (randomNumber != 0) continue;
            double t = (double)i / (double)numberOfParticles;
            Vec3 particlePos = startPos.m_82549_(line.m_82490_(t));
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel _level = (ServerLevel)level;
            float scaleMultiplier = (float)Math.random() * 3.0f;
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.VERTEX_SPARK_PARTICLE.get(), 0.05f * scaleMultiplier);
            _level.m_8767_((ParticleOptions)particleData, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void spawnInitialParticleBeamVFX(Level level, Vec3 startPos, Vec3 endPos) {
        Vec3 line = endPos.m_82546_(startPos);
        double distance = line.m_82553_();
        int numberOfParticles = (int)Math.ceil(distance / 0.8);
        for (int i = 0; i <= numberOfParticles; ++i) {
            double t = (double)i / (double)numberOfParticles;
            Vec3 particlePos = startPos.m_82549_(line.m_82490_(t));
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel _level = (ServerLevel)level;
            float particleScale = 0.2f + (float)Math.random() * 0.2f;
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
            _level.m_8767_((ParticleOptions)particleData, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private List<LivingEntity> getLivingEntitiesTouchingBeam(Level level, Vec3 beamStart, Vec3 beamEnd, double radius) {
        ArrayList<LivingEntity> entitiesInCapsule = new ArrayList<LivingEntity>();
        List allEntities = level.m_45976_(LivingEntity.class, new AABB(Math.min(beamStart.f_82479_, beamEnd.f_82479_) - radius, Math.min(beamStart.f_82480_, beamEnd.f_82480_) - radius, Math.min(beamStart.f_82481_, beamEnd.f_82481_) - radius, Math.max(beamStart.f_82479_, beamEnd.f_82479_) + radius, Math.max(beamStart.f_82480_, beamEnd.f_82480_) + radius, Math.max(beamStart.f_82481_, beamEnd.f_82481_) + radius));
        for (LivingEntity entity : allEntities) {
            if (!this.isBoundingBoxIntersectingWithCapsule(entity.m_20191_(), beamStart, beamEnd, radius)) continue;
            entitiesInCapsule.add(entity);
        }
        return entitiesInCapsule;
    }

    private boolean isBoundingBoxIntersectingWithCapsule(AABB boundingBox, Vec3 beamStart, Vec3 beamEnd, double radius) {
        Vec3 closestPointOnBeam = this.getClosestPointOnBeam(boundingBox, beamStart, beamEnd);
        return closestPointOnBeam.m_82557_(boundingBox.m_82399_()) <= radius * radius || boundingBox.m_82390_(closestPointOnBeam);
    }

    private Vec3 getClosestPointOnBeam(AABB boundingBox, Vec3 start, Vec3 end) {
        Vec3 beamDirection = end.m_82546_(start).m_82541_();
        Vec3 boxCenter = boundingBox.m_82399_();
        double t = beamDirection.m_82526_(boxCenter.m_82546_(start));
        t = Math.max(0.0, Math.min(t, start.m_82554_(end)));
        return start.m_82549_(beamDirection.m_82490_(t));
    }
}

