/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.entity;

import com.mojang.authlib.GameProfile;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlockEntityTypes;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PlayerStatueBlockEntity
extends BlockEntity {
    public static final int LINES = 4;
    public static final int MAX_TEXT_LINE_WIDTH = 90;
    public static final int TEXT_LINE_HEIGHT = 10;
    @Nullable
    private GameProfile owner;
    private int poseVariant = 0;
    private final Component[] text = new Component[]{Component.m_237119_(), Component.m_237119_(), Component.m_237119_(), Component.m_237119_()};
    private DyeColor textColor = DyeColor.BLACK;
    private boolean glowingText = false;
    @Nullable
    private UUID allowedEditor;
    private boolean waxed = false;
    private ItemStack offering = ItemStack.f_41583_;
    private NotchTier notchTier = NotchTier.NONE;

    public PlayerStatueBlockEntity(BlockPos pos, BlockState state) {
        super(DNLBlockEntityTypes.PLAYER_STATUE.get(), pos, state);
    }

    public boolean hasOffering() {
        return !this.offering.m_41619_();
    }

    public ItemStack getOfferingCopy() {
        return this.offering.m_41777_();
    }

    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable GameProfile gp) {
        this.owner = gp;
        this.m_6596_();
        this.sync();
    }

    public int getPoseVariant() {
        return this.poseVariant;
    }

    public void setPoseVariant(int v) {
        this.poseVariant = v;
        this.m_6596_();
        this.sync();
    }

    public Component getLine(int i) {
        return this.text[i];
    }

    public Component[] getLines() {
        return this.text;
    }

    public DyeColor getTextColor() {
        return this.textColor;
    }

    public boolean isGlowingText() {
        return this.glowingText;
    }

    public int getMaxTextLineWidth() {
        return 90;
    }

    public int getTextLineHeight() {
        return 10;
    }

    public void setLine(int i, Component c) {
        this.text[i] = (Component)Objects.requireNonNullElse(c, Component.m_237119_());
        this.m_6596_();
        this.sync();
    }

    public void setAllText(List<Component> lines, DyeColor color, boolean glow) {
        for (int i = 0; i < 4; ++i) {
            MutableComponent c = i < lines.size() && lines.get(i) != null ? lines.get(i) : Component.m_237119_();
            this.text[i] = c;
        }
        this.textColor = color != null ? color : DyeColor.BLACK;
        this.glowingText = glow;
        this.m_6596_();
        this.sync();
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    public boolean setWaxed(boolean wax) {
        if (this.waxed != wax) {
            this.waxed = wax;
            this.m_6596_();
            this.sync();
            return true;
        }
        return false;
    }

    public void setAllowedEditor(@Nullable UUID id) {
        this.allowedEditor = id;
        this.m_6596_();
    }

    @Nullable
    public UUID getAllowedEditor() {
        return this.allowedEditor;
    }

    public boolean playerIsTooFarAwayToEdit(UUID playerId) {
        if (this.f_58857_ == null) {
            return true;
        }
        Player p = this.f_58857_.m_46003_(playerId);
        return p == null || p.m_20275_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()) > 64.0;
    }

    public static void serverTick(Level lvl, BlockPos pos, BlockState state, PlayerStatueBlockEntity be) {
        if (!(lvl instanceof ServerLevel)) {
            return;
        }
        UUID lock = be.allowedEditor;
        if (lock != null && be.playerIsTooFarAwayToEdit(lock)) {
            be.setAllowedEditor(null);
        }
    }

    public void applyTextUpdateFromClient(ServerPlayer sender, List<Component> newLines, DyeColor color, boolean glow) {
        if (!(this.f_58857_ instanceof ServerLevel)) {
            return;
        }
        if (this.isWaxed()) {
            sender.m_5661_((Component)Component.m_237113_((String)"Statue is waxed"), false);
            return;
        }
        if (!sender.m_20148_().equals(this.allowedEditor)) {
            sender.m_5661_((Component)Component.m_237113_((String)"No edit lock / wrong editor"), false);
            return;
        }
        if (this.playerIsTooFarAwayToEdit(sender.m_20148_())) {
            sender.m_5661_((Component)Component.m_237113_((String)"Too far to edit"), false);
            return;
        }
        this.setAllText(newLines, color, glow);
        this.setAllowedEditor(null);
        this.m_6596_();
        this.sync();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.owner != null) {
            CompoundTag o = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)o, (GameProfile)this.owner);
            tag.m_128365_("Owner", (Tag)o);
        }
        tag.m_128405_("PoseVariant", this.poseVariant);
        for (int i = 0; i < 4; ++i) {
            tag.m_128359_("Text" + (i + 1), Component.Serializer.m_130703_((Component)this.text[i]));
        }
        tag.m_128359_("TextColor", this.textColor.m_41065_());
        tag.m_128379_("TextGlowing", this.glowingText);
        if (this.allowedEditor != null) {
            tag.m_128362_("AllowedEditor", this.allowedEditor);
        }
        tag.m_128379_("Waxed", this.waxed);
        tag.m_128359_("NotchTier", this.notchTier.name());
    }

    public void m_142466_(CompoundTag tag) {
        ItemStack legacy;
        NotchTier legacyTier;
        super.m_142466_(tag);
        this.owner = tag.m_128425_("Owner", 10) ? NbtUtils.m_129228_((CompoundTag)tag.m_128469_("Owner")) : null;
        this.poseVariant = tag.m_128451_("PoseVariant");
        for (int i = 0; i < 4; ++i) {
            String key = "Text" + (i + 1);
            this.text[i] = tag.m_128425_(key, 8) ? Component.Serializer.m_130701_((String)tag.m_128461_(key)) : Component.m_237119_();
        }
        if (tag.m_128425_("TextColor", 8)) {
            try {
                this.textColor = DyeColor.m_41057_((String)tag.m_128461_("TextColor"), (DyeColor)DyeColor.BLACK);
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        this.glowingText = tag.m_128471_("TextGlowing");
        this.allowedEditor = tag.m_128425_("AllowedEditor", 11) || tag.m_128425_("AllowedEditor", 12) ? tag.m_128342_("AllowedEditor") : null;
        this.waxed = tag.m_128471_("Waxed");
        this.notchTier = NotchTier.fromString(tag.m_128461_("NotchTier"));
        if (this.notchTier == NotchTier.NONE && tag.m_128425_("Offering", 10) && (legacyTier = PlayerStatueBlockEntity.tierFromItem(legacy = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Offering")))) != NotchTier.NONE) {
            this.notchTier = legacyTier;
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void sync() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public static NotchTier tierFromItem(ItemStack s) {
        if (s.m_150930_(Items.f_151052_)) {
            return NotchTier.COPPER;
        }
        if (s.m_150930_(Items.f_42416_)) {
            return NotchTier.IRON;
        }
        if (s.m_150930_(Items.f_42417_)) {
            return NotchTier.GOLD;
        }
        if (s.m_150930_(Items.f_42415_)) {
            return NotchTier.DIAMOND;
        }
        return NotchTier.NONE;
    }

    public static ItemStack defaultItemForTier(NotchTier t) {
        return switch (t) {
            case NotchTier.COPPER -> new ItemStack((ItemLike)Items.f_151052_);
            case NotchTier.IRON -> new ItemStack((ItemLike)Items.f_42416_);
            case NotchTier.GOLD -> new ItemStack((ItemLike)Items.f_42417_);
            case NotchTier.DIAMOND -> new ItemStack((ItemLike)Items.f_42415_);
            default -> ItemStack.f_41583_;
        };
    }

    @Nullable
    public String ensureServerSideOwnerName() {
        Optional opt;
        if (this.owner == null) {
            return null;
        }
        if (this.owner.getName() != null && !this.owner.getName().isEmpty()) {
            return this.owner.getName();
        }
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel sl = (ServerLevel)level;
        UUID id = this.owner.getId();
        if (id == null) {
            return null;
        }
        GameProfileCache cache = sl.m_7654_().m_129927_();
        if (cache != null && (opt = cache.m_11002_(id)).isPresent()) {
            this.owner = (GameProfile)opt.get();
            this.m_6596_();
            return this.owner.getName();
        }
        return null;
    }

    public static String shortUuid(@Nullable UUID id) {
        return id == null ? "Someone" : id.toString().substring(0, 8);
    }

    public boolean isOccupied() {
        return this.notchTier != NotchTier.NONE;
    }

    public boolean placeMaterial(ItemStack oneItem) {
        NotchTier t = PlayerStatueBlockEntity.tierFromItem(oneItem);
        if (t == NotchTier.NONE) {
            return false;
        }
        this.setNotchTier(t);
        return true;
    }

    public ItemStack takeMaterial() {
        if (!this.isOccupied()) {
            return ItemStack.f_41583_;
        }
        ItemStack out = PlayerStatueBlockEntity.defaultItemForTier(this.notchTier);
        this.setNotchTier(NotchTier.NONE);
        return out;
    }

    public NotchTier getNotchTier() {
        return this.notchTier;
    }

    public void setNotchTier(NotchTier tier) {
        if (tier == null) {
            tier = NotchTier.NONE;
        }
        if (tier != this.notchTier) {
            this.notchTier = tier;
            this.m_6596_();
            this.sync();
        }
    }

    public static enum NotchTier {
        NONE,
        COPPER,
        IRON,
        GOLD,
        DIAMOND;


        public static NotchTier fromString(String s) {
            if (s == null) {
                return NONE;
            }
            try {
                return NotchTier.valueOf(s.toUpperCase());
            }
            catch (Exception e) {
                return NONE;
            }
        }
    }
}

