/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import dev.hexnowloading.dungeonnowloading.block.entity.VertexPillarBlockEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlockEntityTypes;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VertexPillarBlock
extends BaseEntityBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final int RANGE = 19;

    public VertexPillarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockBlockStateBuilder) {
        blockBlockStateBuilder.m_61104_(new Property[]{WATERLOGGED});
        blockBlockStateBuilder.m_61104_(new Property[]{HALF});
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Level level = blockPlaceContext.m_43725_();
        return blockPos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockPos.m_7494_()).m_60629_(blockPlaceContext) ? (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_()).m_76152_() == Fluids.f_76193_)) : null;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockPos blockPos1 = blockPos.m_7495_();
        return this.mayPlaceOn(levelReader.m_8055_(blockPos1), (BlockGetter)levelReader, blockPos1);
    }

    private boolean mayPlaceOn(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return !blockState.m_60812_(blockGetter, blockPos).m_83263_(Direction.UP).m_83281_() || blockState.m_60783_(blockGetter, blockPos, Direction.UP);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState oldBlockState, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos oldBlockPos) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)blockState.m_61143_(HALF);
        BlockState topBlockState = levelAccessor.m_8055_(blockPos.m_7494_());
        if (!blockState.m_60710_((LevelReader)levelAccessor, blockPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (doubleBlockHalf == DoubleBlockHalf.LOWER && !topBlockState.m_61138_(HALF)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (doubleBlockHalf == DoubleBlockHalf.LOWER && topBlockState.m_61138_(HALF) && topBlockState.m_61143_(HALF) != DoubleBlockHalf.UPPER) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, oldBlockState, levelAccessor, blockPos, oldBlockPos);
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockPos upperBlockPos = blockPos.m_7494_();
        level.m_7731_(upperBlockPos, (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        if (!level.f_46443_) {
            VertexPillarBlock.linkOnPlaced(level, blockPos);
        }
    }

    public static void linkOnPlaced(Level level, BlockPos blockPos) {
        VertexPillarBlockEntity thisBE = (VertexPillarBlockEntity)level.m_7702_(blockPos);
        if (thisBE == null) {
            return;
        }
        float inflate = 0.1f;
        double maxRangeX = (float)blockPos.m_123341_() + inflate + 19.0f;
        double minRangeX = (float)blockPos.m_123341_() - inflate - 19.0f;
        double maxRangeY = (float)blockPos.m_123342_() + inflate + 19.0f;
        double minRangeY = (float)blockPos.m_123342_() - inflate - 19.0f;
        double maxRangeZ = (float)blockPos.m_123343_() + inflate + 19.0f;
        double minRangeZ = (float)blockPos.m_123343_() - inflate - 19.0f;
        HashMap blockEntityMap = new HashMap();
        int chunkMaxX = SectionPos.m_235865_((double)maxRangeX);
        int chunkMinX = SectionPos.m_235865_((double)minRangeX);
        int chunkMaxZ = SectionPos.m_235865_((double)maxRangeZ);
        int chunkMinZ = SectionPos.m_235865_((double)minRangeZ);
        int x = 0;
        while (chunkMinX + x <= chunkMaxX) {
            int z = 0;
            while (chunkMinZ + z <= chunkMaxZ) {
                blockEntityMap.putAll(level.m_6325_(chunkMinX + x, chunkMinZ + z).m_62954_());
                ++z;
            }
            ++x;
        }
        double range = 361.0;
        Map<BlockPos, BlockEntity> filteredMap = blockEntityMap.entrySet().stream().filter(e -> {
            VertexPillarBlockEntity blockEntity;
            Object patt7548$temp = e.getValue();
            return patt7548$temp instanceof VertexPillarBlockEntity && (blockEntity = (VertexPillarBlockEntity)((Object)((Object)patt7548$temp))).m_58900_().m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER;
        }).filter(e -> {
            float z;
            float y;
            float x = ((BlockPos)e.getKey()).m_123341_() - blockPos.m_123341_();
            return (double)(x * x + (y = (float)(((BlockPos)e.getKey()).m_123342_() - blockPos.m_123342_())) * y + (z = (float)(((BlockPos)e.getKey()).m_123343_() - blockPos.m_123343_())) * z) < range;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!filteredMap.isEmpty()) {
            List<BlockPos> blockPosList = filteredMap.keySet().stream().filter(e -> !e.equals((Object)blockPos)).sorted(Comparator.comparingDouble(e -> e.m_123331_((Vec3i)blockPos))).toList();
            for (BlockPos pos : blockPosList) {
                BlockEntity linkingBE = level.m_7702_(pos);
                if (!(linkingBE instanceof VertexPillarBlockEntity)) continue;
                VertexPillarBlockEntity shieldingStonePillar = (VertexPillarBlockEntity)linkingBE;
                thisBE.addLink(pos);
                shieldingStonePillar.addLink(blockPos);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new VertexPillarBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return VertexPillarBlock.m_152132_(blockEntityType, DNLBlockEntityTypes.VERTEX_PILLAR.get(), VertexPillarBlockEntity::tick);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }
}

