/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import dev.hexnowloading.dungeonnowloading.entity.monster.ScuttleEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;

public class OverchargedRedstoneBlock
extends Block {
    public OverchargedRedstoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        for (Direction dir : Direction.values()) {
            BlockPos adjacentPos = pos.m_121945_(dir);
            BlockState adjacentState = world.m_8055_(adjacentPos);
            if (!adjacentState.m_60713_(Blocks.f_50088_) && !adjacentState.m_60803_() && !adjacentState.m_204336_(DNLTags.OVERCHARGED_REDSTONE_BLOCK_NEIGHBOUR_EXPLOSIVE) && !adjacentState.m_60713_(Blocks.f_50077_)) continue;
            return 0;
        }
        return 15;
    }

    public boolean m_7899_(BlockState $$0) {
        return true;
    }

    public void m_141947_(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        if (entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity)) && !(entity instanceof ScuttleEntity)) {
            entity.m_6469_(level.m_269111_().m_269047_(), 6.0f);
            if (!entity.m_5825_()) {
                entity.m_20254_(5);
            }
        }
        super.m_141947_(level, blockPos, blockState, entity);
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState1, boolean b) {
        if (blockState.m_60713_(blockState1.m_60734_()) || level.f_46443_) {
            return;
        }
        this.explodePoweredRedstone(level, blockPos);
        this.explodeDirectlyConnectedRepeatersAndComparatorsInAllDirections(level, blockPos);
        super.m_6807_(blockState, level, blockPos, blockState1, b);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (world.f_46443_) {
            return;
        }
        this.explodePoweredRedstone(world, pos);
        this.explodeDirectlyConnectedRepeatersAndComparatorsInAllDirections(world, pos);
    }

    private void explodePoweredRedstone(Level world, BlockPos pos) {
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        toCheck.add(pos);
        int chainLength = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos adjacentPos = pos.m_121945_(direction);
            BlockState adjacentState = world.m_8055_(adjacentPos);
            if (!adjacentState.m_60713_(Blocks.f_50146_) && !adjacentState.m_60713_(Blocks.f_50328_)) continue;
            this.explodeComponents(world, adjacentPos, 0.5f, DNLSounds.OVERCHARGED_REDSTONE_BLOCK_COMPONENT_DETONATION.get(), 1.0f);
        }
        while (!toCheck.isEmpty() && chainLength < 16) {
            int levelSize = toCheck.size();
            for (int i = 0; i < levelSize; ++i) {
                BlockPos currentPos = (BlockPos)toCheck.poll();
                if (checked.contains(currentPos)) continue;
                checked.add(currentPos);
                BlockState currentState = world.m_8055_(currentPos);
                if (currentState.m_60734_() == Blocks.f_50016_) continue;
                if (currentState.m_60734_() == Blocks.f_50088_) {
                    boolean north = ((RedstoneSide)currentState.m_61143_((Property)BlockStateProperties.f_61383_)).m_61761_();
                    boolean south = ((RedstoneSide)currentState.m_61143_((Property)BlockStateProperties.f_61384_)).m_61761_();
                    boolean east = ((RedstoneSide)currentState.m_61143_((Property)BlockStateProperties.f_61382_)).m_61761_();
                    boolean west = ((RedstoneSide)currentState.m_61143_((Property)BlockStateProperties.f_61385_)).m_61761_();
                    if (north) {
                        if (currentState.m_61143_((Property)BlockStateProperties.f_61383_) == RedstoneSide.UP) {
                            if (!checked.contains(currentPos.m_121945_(Direction.NORTH).m_121945_(Direction.UP))) {
                                toCheck.add(currentPos.m_121945_(Direction.NORTH).m_121945_(Direction.UP));
                            }
                        } else if (world.m_8055_(currentPos.m_121945_(Direction.NORTH)).m_60713_(Blocks.f_50088_)) {
                            if (!checked.contains(currentPos.m_121945_(Direction.NORTH))) {
                                toCheck.add(currentPos.m_121945_(Direction.NORTH));
                            }
                        } else if (world.m_8055_(currentPos.m_121945_(Direction.NORTH).m_121945_(Direction.DOWN)).m_60713_(Blocks.f_50088_) && world.m_8055_(currentPos.m_121945_(Direction.NORTH).m_121945_(Direction.DOWN)).m_61143_((Property)BlockStateProperties.f_61384_) == RedstoneSide.UP && !checked.contains(currentPos.m_121945_(Direction.NORTH).m_121945_(Direction.DOWN))) {
                            toCheck.add(currentPos.m_121945_(Direction.NORTH).m_121945_(Direction.DOWN));
                        }
                    }
                    if (south) {
                        if (currentState.m_61143_((Property)BlockStateProperties.f_61384_) == RedstoneSide.UP) {
                            if (!checked.contains(currentPos.m_121945_(Direction.SOUTH).m_121945_(Direction.UP))) {
                                toCheck.add(currentPos.m_121945_(Direction.SOUTH).m_121945_(Direction.UP));
                            }
                        } else if (world.m_8055_(currentPos.m_121945_(Direction.SOUTH)).m_60713_(Blocks.f_50088_)) {
                            if (!checked.contains(currentPos.m_121945_(Direction.SOUTH))) {
                                toCheck.add(currentPos.m_121945_(Direction.SOUTH));
                            }
                        } else if (world.m_8055_(currentPos.m_121945_(Direction.SOUTH).m_121945_(Direction.DOWN)).m_60713_(Blocks.f_50088_) && world.m_8055_(currentPos.m_121945_(Direction.SOUTH).m_121945_(Direction.DOWN)).m_61143_((Property)BlockStateProperties.f_61383_) == RedstoneSide.UP && !checked.contains(currentPos.m_121945_(Direction.SOUTH).m_121945_(Direction.DOWN))) {
                            toCheck.add(currentPos.m_121945_(Direction.SOUTH).m_121945_(Direction.DOWN));
                        }
                    }
                    if (east) {
                        if (currentState.m_61143_((Property)BlockStateProperties.f_61382_) == RedstoneSide.UP) {
                            if (!checked.contains(currentPos.m_121945_(Direction.EAST).m_121945_(Direction.UP))) {
                                toCheck.add(currentPos.m_121945_(Direction.EAST).m_121945_(Direction.UP));
                            }
                        } else if (world.m_8055_(currentPos.m_121945_(Direction.EAST)).m_60713_(Blocks.f_50088_)) {
                            if (!checked.contains(currentPos.m_121945_(Direction.EAST))) {
                                toCheck.add(currentPos.m_121945_(Direction.EAST));
                            }
                        } else if (world.m_8055_(currentPos.m_121945_(Direction.EAST).m_121945_(Direction.DOWN)).m_60713_(Blocks.f_50088_) && world.m_8055_(currentPos.m_121945_(Direction.EAST).m_121945_(Direction.DOWN)).m_61143_((Property)BlockStateProperties.f_61385_) == RedstoneSide.UP && !checked.contains(currentPos.m_121945_(Direction.EAST).m_121945_(Direction.DOWN))) {
                            toCheck.add(currentPos.m_121945_(Direction.EAST).m_121945_(Direction.DOWN));
                        }
                    }
                    if (west) {
                        if (currentState.m_61143_((Property)BlockStateProperties.f_61385_) == RedstoneSide.UP) {
                            if (!checked.contains(currentPos.m_121945_(Direction.WEST).m_121945_(Direction.UP))) {
                                toCheck.add(currentPos.m_121945_(Direction.WEST).m_121945_(Direction.UP));
                            }
                        } else if (world.m_8055_(currentPos.m_121945_(Direction.WEST)).m_60713_(Blocks.f_50088_)) {
                            if (!checked.contains(currentPos.m_121945_(Direction.WEST))) {
                                toCheck.add(currentPos.m_121945_(Direction.WEST));
                            }
                        } else if (world.m_8055_(currentPos.m_121945_(Direction.WEST).m_121945_(Direction.DOWN)).m_60713_(Blocks.f_50088_) && world.m_8055_(currentPos.m_121945_(Direction.WEST).m_121945_(Direction.DOWN)).m_61143_((Property)BlockStateProperties.f_61382_) == RedstoneSide.UP && !checked.contains(currentPos.m_121945_(Direction.WEST).m_121945_(Direction.DOWN))) {
                            toCheck.add(currentPos.m_121945_(Direction.WEST).m_121945_(Direction.DOWN));
                        }
                    }
                    world.m_5594_(null, currentPos, DNLSounds.OVERCHARGED_REDSTONE_BLOCK_DUST_COMBUSTION.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    world.m_7731_(currentPos, Blocks.f_50083_.m_49966_(), 3);
                    if (world instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)world;
                        serverLevel.m_8767_((ParticleOptions)DustParticleOptions.f_123656_, (double)((float)currentPos.m_123341_() + 0.5f), (double)((float)currentPos.m_123342_() + 0.5f), (double)((float)currentPos.m_123343_() + 0.5f), 5, 0.5, 0.5, 0.5, 0.0);
                    }
                    if (north) {
                        this.explodeComponentOnOneDirection(world, currentPos, Direction.NORTH);
                    }
                    if (east) {
                        this.explodeComponentOnOneDirection(world, currentPos, Direction.EAST);
                    }
                    if (south) {
                        this.explodeComponentOnOneDirection(world, currentPos, Direction.SOUTH);
                    }
                    if (!west) continue;
                    this.explodeComponentOnOneDirection(world, currentPos, Direction.WEST);
                    continue;
                }
                if (currentState.m_60734_() != DNLBlocks.OVERCHARGED_REDSTONE_BLOCK.get()) continue;
                for (Direction direction : Direction.values()) {
                    BlockPos adjacentPos = currentPos.m_121945_(direction);
                    BlockState adjacentState = world.m_8055_(adjacentPos);
                    if (!checked.contains(adjacentPos) && adjacentState.m_60734_() == Blocks.f_50088_) {
                        toCheck.add(adjacentPos);
                    }
                    if (adjacentState.m_60713_(Blocks.f_50146_) || adjacentState.m_60713_(Blocks.f_50328_)) {
                        this.explodeRepeaterAndComparator(world, adjacentPos, adjacentState, direction);
                        continue;
                    }
                    if (adjacentState.m_60713_(Blocks.f_50285_) || adjacentState.m_60713_(Blocks.f_50030_)) {
                        this.explodeComponents(world, adjacentPos, 0.5f, DNLSounds.OVERCHARGED_REDSTONE_BLOCK_COMPONENT_DETONATION.get(), 1.0f);
                        continue;
                    }
                    if (adjacentState.m_60713_(Blocks.f_50061_) || adjacentState.m_60713_(Blocks.f_50286_) || adjacentState.m_60713_(Blocks.f_50039_) || adjacentState.m_60713_(Blocks.f_50032_)) {
                        this.explodeComponents(world, adjacentPos, 1.0f, DNLSounds.OVERCHARGED_REDSTONE_BLOCK_COMPONENT_DETONATION.get(), 1.0f);
                        continue;
                    }
                    if (adjacentState.m_60713_(Blocks.f_50065_) || adjacentState.m_60713_(Blocks.f_50261_) || adjacentState.m_60713_(Blocks.f_50455_) || adjacentState.m_60713_(DNLBlocks.SIGNAL_GATE.get())) {
                        this.explodeComponents(world, adjacentPos, 1.5f, DNLSounds.OVERCHARGED_REDSTONE_BLOCK_COMPONENT_DETONATION.get(), 1.0f);
                        continue;
                    }
                    if (!adjacentState.m_60713_(Blocks.f_50077_)) continue;
                    this.explodeComponents(world, adjacentPos, 6.0f, DNLSounds.OVERCHARGED_REDSTONE_BLOCK_TNT_EXPLOSION.get(), 3.0f);
                }
            }
            ++chainLength;
        }
    }

    private void explodeComponentOnOneDirection(Level level, BlockPos blockPos, Direction direction) {
        BlockPos adjacentPos = blockPos.m_121945_(direction);
        BlockState adjacentState = level.m_8055_(adjacentPos);
        if (adjacentState.m_60713_(Blocks.f_50146_) || adjacentState.m_60713_(Blocks.f_50328_)) {
            this.explodeRepeaterAndComparator(level, adjacentPos, adjacentState, direction);
        } else if (adjacentState.m_60713_(Blocks.f_50285_) || adjacentState.m_60713_(Blocks.f_50030_)) {
            this.explodeComponents(level, adjacentPos, 0.5f, DNLSounds.OVERCHARGED_REDSTONE_BLOCK_COMPONENT_DETONATION.get(), 1.0f);
        } else if (adjacentState.m_60713_(Blocks.f_50061_) || adjacentState.m_60713_(Blocks.f_50286_) || adjacentState.m_60713_(Blocks.f_50039_) || adjacentState.m_60713_(Blocks.f_50032_)) {
            this.explodeComponents(level, adjacentPos, 1.0f, DNLSounds.OVERCHARGED_REDSTONE_BLOCK_COMPONENT_DETONATION.get(), 1.0f);
        } else if (adjacentState.m_60713_(Blocks.f_50065_) || adjacentState.m_60713_(Blocks.f_50261_) || adjacentState.m_60713_(Blocks.f_50455_) || adjacentState.m_60713_(DNLBlocks.SIGNAL_GATE.get())) {
            this.explodeComponents(level, adjacentPos, 1.5f, DNLSounds.OVERCHARGED_REDSTONE_BLOCK_COMPONENT_DETONATION.get(), 1.0f);
        } else if (adjacentState.m_60713_(Blocks.f_50077_)) {
            this.explodeComponents(level, adjacentPos, 6.0f, DNLSounds.OVERCHARGED_REDSTONE_BLOCK_TNT_EXPLOSION.get(), 1.0f);
        }
    }

    private void explodeDirectlyConnectedRepeatersAndComparatorsInAllDirections(Level world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = pos.m_121945_(direction);
            BlockState adjacentState = world.m_8055_(adjacentPos);
            if (adjacentState.m_60713_(Blocks.f_50146_) || adjacentState.m_60713_(Blocks.f_50328_)) {
                this.explodeRepeaterAndComparator(world, adjacentPos, adjacentState, direction);
                continue;
            }
            if (adjacentState.m_60713_(Blocks.f_50285_) || adjacentState.m_60713_(Blocks.f_50030_)) {
                this.explodeComponents(world, adjacentPos, 0.5f, DNLSounds.OVERCHARGED_REDSTONE_BLOCK_COMPONENT_DETONATION.get(), 1.0f);
                continue;
            }
            if (adjacentState.m_60713_(Blocks.f_50061_) || adjacentState.m_60713_(Blocks.f_50286_) || adjacentState.m_60713_(Blocks.f_50039_) || adjacentState.m_60713_(Blocks.f_50032_)) {
                this.explodeComponents(world, adjacentPos, 1.0f, DNLSounds.OVERCHARGED_REDSTONE_BLOCK_COMPONENT_DETONATION.get(), 1.0f);
                continue;
            }
            if (adjacentState.m_60713_(Blocks.f_50065_) || adjacentState.m_60713_(Blocks.f_50261_) || adjacentState.m_60713_(Blocks.f_50455_) || adjacentState.m_60713_(DNLBlocks.SIGNAL_GATE.get())) {
                this.explodeComponents(world, adjacentPos, 1.5f, DNLSounds.OVERCHARGED_REDSTONE_BLOCK_COMPONENT_DETONATION.get(), 1.0f);
                continue;
            }
            if (!adjacentState.m_60713_(Blocks.f_50077_)) continue;
            this.explodeComponents(world, adjacentPos, 6.0f, DNLSounds.OVERCHARGED_REDSTONE_BLOCK_TNT_EXPLOSION.get(), 1.0f);
        }
    }

    private void explodeRepeaterAndComparator(Level world, BlockPos adjacentPos, BlockState adjacentState, Direction direction) {
        Direction repeaterDirection = (Direction)adjacentState.m_61143_((Property)BlockStateProperties.f_61374_);
        if (repeaterDirection == direction.m_122424_()) {
            this.explodeComponents(world, adjacentPos, 0.5f, DNLSounds.OVERCHARGED_REDSTONE_BLOCK_COMPONENT_DETONATION.get(), 1.0f);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), 1.0f);
                serverLevel.m_8767_((ParticleOptions)particleData, (double)adjacentPos.m_123341_() + 0.5, (double)adjacentPos.m_123342_() + 0.5, (double)adjacentPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void explodeComponents(Level level, BlockPos blockPos, float strength, SoundEvent soundEvent, float particleScale) {
        level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
        level.m_255391_(null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, strength, true, Level.ExplosionInteraction.BLOCK);
        level.m_5594_(null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
            serverLevel.m_8767_((ParticleOptions)particleData, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        double z;
        double y;
        double x;
        BlockPos adjacentPos;
        if (randomSource.m_188501_() > 0.9f) {
            for (Direction direction : Direction.values()) {
                adjacentPos = blockPos.m_121945_(direction);
                if (!level.m_8055_(adjacentPos).m_60795_()) continue;
                x = (double)blockPos.m_123341_() + 0.5 + 0.5 * (double)direction.m_122429_() + ((double)randomSource.m_188501_() - 0.5) * 0.6;
                y = (double)blockPos.m_123342_() + 0.5 + 0.5 * (double)direction.m_122430_() + ((double)randomSource.m_188501_() - 0.5) * 0.6;
                z = (double)blockPos.m_123343_() + 0.5 + 0.5 * (double)direction.m_122431_() + ((double)randomSource.m_188501_() - 0.5) * 0.6;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
        if (randomSource.m_188501_() > 0.7f) {
            for (Direction direction : Direction.values()) {
                adjacentPos = blockPos.m_121945_(direction);
                if (!level.m_8055_(adjacentPos).m_60795_()) continue;
                x = (double)blockPos.m_123341_() + 0.5 + 0.5 * (double)direction.m_122429_() + ((double)randomSource.m_188501_() - 0.5) * 0.6;
                y = (double)blockPos.m_123342_() + 0.5 + 0.5 * (double)direction.m_122430_() + ((double)randomSource.m_188501_() - 0.5) * 0.6;
                z = (double)blockPos.m_123343_() + 0.5 + 0.5 * (double)direction.m_122431_() + ((double)randomSource.m_188501_() - 0.5) * 0.6;
                level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }
}

