/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import dev.hexnowloading.dungeonnowloading.block.MendingAuraBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MendingAuraChestBlock
extends MendingAuraBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<ChestType> CHEST_TYPE = BlockStateProperties.f_61392_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public MendingAuraChestBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(CHEST_TYPE, (Comparable)ChestType.SINGLE));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> b) {
        super.m_7926_(b);
        b.m_61104_(new Property[]{FACING, CHEST_TYPE});
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState s, BlockGetter g, BlockPos p, CollisionContext c) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState s, BlockGetter g, BlockPos p, CollisionContext c) {
        return SHAPE;
    }

    @Override
    public boolean m_6104_(BlockState self, BlockState neighbor, Direction dir) {
        Direction connectDir;
        if (neighbor.m_60713_((Block)this) && self.m_61143_(CHEST_TYPE) != ChestType.SINGLE && neighbor.m_61143_(CHEST_TYPE) != ChestType.SINGLE && self.m_61143_((Property)FACING) == neighbor.m_61143_((Property)FACING) && dir == (connectDir = this.connectionDirection(self))) {
            return true;
        }
        return super.m_6104_(self, neighbor, dir);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState base = super.m_5573_(ctx);
        if (base == null) {
            base = this.m_49966_();
        }
        BlockState state = (BlockState)((BlockState)base.m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CHEST_TYPE, (Comparable)ChestType.SINGLE);
        if (!ctx.m_7078_()) {
            state = this.tryConnectOnPlacement((LevelAccessor)ctx.m_43725_(), ctx.m_8083_(), state);
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState nbr, LevelAccessor level, BlockPos pos, BlockPos nbrPos) {
        BlockState s = super.m_7417_(state, dir, nbr, level, pos, nbrPos);
        return this.recomputeConnection(level, pos, s);
    }

    public BlockState m_6843_(BlockState s, Rotation r) {
        return (BlockState)s.m_61124_((Property)FACING, (Comparable)r.m_55954_((Direction)s.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState s, Mirror m) {
        Direction facing = (Direction)s.m_61143_((Property)FACING);
        ChestType type = (ChestType)s.m_61143_(CHEST_TYPE);
        BlockState out = s.m_60717_(m.m_54846_(facing));
        if (type != ChestType.SINGLE && (m == Mirror.LEFT_RIGHT || m == Mirror.FRONT_BACK)) {
            out = (BlockState)out.m_61124_(CHEST_TYPE, (Comparable)(type == ChestType.LEFT ? ChestType.RIGHT : ChestType.LEFT));
        }
        return out;
    }

    private BlockState tryConnectOnPlacement(LevelAccessor level, BlockPos pos, BlockState self) {
        Direction facing = (Direction)self.m_61143_((Property)FACING);
        BlockPos leftPos = pos.m_121945_(facing.m_122428_());
        BlockPos rightPos = pos.m_121945_(facing.m_122427_());
        BlockState left = level.m_8055_(leftPos);
        BlockState right = level.m_8055_(rightPos);
        if (this.canConnect(self, left)) {
            return (BlockState)self.m_61124_(CHEST_TYPE, (Comparable)ChestType.RIGHT);
        }
        if (this.canConnect(self, right)) {
            return (BlockState)self.m_61124_(CHEST_TYPE, (Comparable)ChestType.LEFT);
        }
        return self;
    }

    private BlockState recomputeConnection(LevelAccessor level, BlockPos pos, BlockState self) {
        Direction facing = (Direction)self.m_61143_((Property)FACING);
        BlockState left = level.m_8055_(pos.m_121945_(facing.m_122428_()));
        BlockState right = level.m_8055_(pos.m_121945_(facing.m_122427_()));
        boolean leftOk = this.canConnect(self, left) && left.m_61143_((Property)FACING) == facing && left.m_61143_(CHEST_TYPE) == ChestType.SINGLE;
        boolean rightOk = this.canConnect(self, right) && right.m_61143_((Property)FACING) == facing && right.m_61143_(CHEST_TYPE) == ChestType.SINGLE;
        ChestType newType = ChestType.SINGLE;
        if (leftOk ^ rightOk) {
            newType = leftOk ? ChestType.RIGHT : ChestType.LEFT;
        }
        return (BlockState)self.m_61124_(CHEST_TYPE, (Comparable)newType);
    }

    private boolean canConnect(BlockState self, BlockState other) {
        return other.m_60713_((Block)this);
    }

    private Direction connectionDirection(BlockState s) {
        Direction facing = (Direction)s.m_61143_((Property)FACING);
        return s.m_61143_(CHEST_TYPE) == ChestType.LEFT ? facing.m_122427_() : facing.m_122428_();
    }
}

