/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.client.item;

import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.tweaks.module.CompassesWorkEverywhereModule;
import org.violetmoon.zeta.util.ItemNBTHelper;

@OnlyIn(value=Dist.CLIENT)
public class CompassAnglePropertyFunction
implements ItemPropertyFunction {
    private final Angle normalAngle = new Angle();
    private final Angle unknownAngle = new Angle();

    @OnlyIn(value=Dist.CLIENT)
    public float m_141951_(@NotNull ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int id) {
        double angle;
        BlockPos lodestonePos;
        Level level;
        LivingEntity entity;
        if (entityIn == null && !stack.m_41794_()) {
            return 0.0f;
        }
        if (!(!CompassesWorkEverywhereModule.enableCompassNerf || stack.m_41782_() && ItemNBTHelper.getBoolean((ItemStack)stack, (String)"quark:compass_calculated", (boolean)false))) {
            return 0.0f;
        }
        boolean carried = entityIn != null;
        Object object = entity = carried ? entityIn : stack.m_41795_();
        if (entity == null) {
            return 0.0f;
        }
        if (worldIn == null && entity != null && (level = entity.m_9236_()) instanceof ClientLevel) {
            ClientLevel level2;
            worldIn = level2 = (ClientLevel)level;
        }
        boolean calculate = false;
        BlockPos target = new BlockPos(0, 0, 0);
        ResourceLocation dimension = worldIn.m_46472_().m_135782_();
        boolean isLodestone = CompassItem.m_40736_((ItemStack)stack);
        BlockPos blockPos = lodestonePos = isLodestone ? this.getLodestonePosition((Level)worldIn, stack.m_41784_()) : null;
        if (lodestonePos != null) {
            calculate = true;
            target = lodestonePos;
        } else if (!isLodestone) {
            if (dimension.equals((Object)LevelStem.f_63973_.m_135782_()) && CompassesWorkEverywhereModule.enableEnd) {
                calculate = true;
            } else if (dimension.equals((Object)LevelStem.f_63972_.m_135782_()) && CompassesWorkEverywhereModule.isCompassCalculated(stack) && CompassesWorkEverywhereModule.enableNether) {
                boolean set = ItemNBTHelper.getBoolean((ItemStack)stack, (String)"quark:compass_position_set", (boolean)false);
                if (set) {
                    int x = ItemNBTHelper.getInt((ItemStack)stack, (String)"quark:nether_x", (int)0);
                    int z = ItemNBTHelper.getInt((ItemStack)stack, (String)"quark:nether_z", (int)0);
                    calculate = true;
                    target = new BlockPos(x, 0, z);
                }
            } else if (worldIn.m_6042_().f_63858_()) {
                calculate = true;
                target = this.getWorldSpawn(worldIn);
            }
        }
        long gameTime = worldIn.m_46467_();
        if (calculate && target != null) {
            double d1 = carried ? (double)entity.m_146908_() : this.getFrameRotation((ItemFrame)entity);
            d1 = Mth.m_14109_((double)(d1 / 360.0), (double)1.0);
            double d2 = this.getAngleToPosition((Entity)entity, target) / (Math.PI * 2);
            if (carried) {
                if (this.normalAngle.needsUpdate(gameTime)) {
                    this.normalAngle.wobble(gameTime, 0.5 - (d1 - 0.25));
                }
                angle = d2 + this.normalAngle.rotation;
            } else {
                angle = 0.5 - (d1 - 0.25 - d2);
            }
        } else {
            if (this.unknownAngle.needsUpdate(gameTime)) {
                this.unknownAngle.wobble(gameTime, Math.random());
            }
            angle = this.unknownAngle.rotation + (double)this.shift(id);
        }
        return Mth.m_14091_((float)((float)angle), (float)1.0f);
    }

    private double getFrameRotation(ItemFrame frame) {
        return Mth.m_14177_((float)(180.0f + frame.m_6350_().m_122435_()));
    }

    private double getAngleToPosition(Entity entity, BlockPos blockpos) {
        Vec3 pos = entity.m_20182_();
        return Math.atan2((double)blockpos.m_123343_() - pos.f_82481_, (double)blockpos.m_123341_() - pos.f_82479_);
    }

    private float shift(int id) {
        return (float)(id * 1327217883) / 2.1474836E9f;
    }

    @Nullable
    private BlockPos getLodestonePosition(Level world, CompoundTag tag) {
        Optional optional;
        boolean flag = tag.m_128441_("LodestonePos");
        boolean flag1 = tag.m_128441_("LodestoneDimension");
        if (flag && flag1 && (optional = CompassItem.m_40727_((CompoundTag)tag)).isPresent() && world.m_46472_().equals(optional.get())) {
            return NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LodestonePos"));
        }
        return null;
    }

    @Nullable
    private BlockPos getWorldSpawn(ClientLevel world) {
        return world.m_6042_().f_63858_() ? world.m_220360_() : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Angle {
        private double rotation;
        private double rota;
        private long lastUpdateTick;

        private Angle() {
        }

        private boolean needsUpdate(long tick) {
            return this.lastUpdateTick != tick;
        }

        private void wobble(long gameTime, double angle) {
            this.lastUpdateTick = gameTime;
            double d0 = angle - this.rotation;
            d0 = Mth.m_14109_((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.rota += d0 * 0.1;
            this.rota *= 0.8;
            this.rotation = Mth.m_14109_((double)(this.rotation + this.rota), (double)1.0);
        }
    }
}

