/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.item;

import galena.nirvana.index.NirvanaEffects;
import galena.nirvana.index.NirvanaSounds;
import galena.nirvana.platform.Services;
import galena.nirvana.world.effects.IStackingEffect;
import galena.nirvana.world.item.SmokingDispenserBehaviour;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class SmokingItem
extends Item {
    public SmokingItem(Item.Properties properties) {
        super(properties);
    }

    protected void registerDispenserBehaviour() {
        SmokingDispenserBehaviour dispenserBehaviour = (source, pos, look, stack) -> {
            this.applyEffects(stack, (Level)source.m_7727_(), Vec3.m_82512_((Vec3i)source.m_7961_()), null);
            Vec3 mouth = pos.m_82549_(look.m_82490_(0.5));
            source.m_7727_().m_8767_((ParticleOptions)ParticleTypes.f_123777_, mouth.m_7096_(), mouth.m_7098_(), mouth.m_7094_(), 5, 0.0, 0.2 + source.m_7727_().m_213780_().m_188500_() * 0.1, 0.0, 0.02);
        };
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)dispenserBehaviour);
    }

    abstract Stream<MobEffectInstance> getEffects(ItemStack var1, @Nullable Level var2, @Nullable LivingEntity var3);

    abstract double getRadius(ItemStack var1, @Nullable Level var2, @Nullable LivingEntity var3);

    private void addParticles(ServerLevel level, LivingEntity entity) {
        Vec3 rot = entity.m_20154_().m_82490_(0.6);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123777_, entity.m_20185_() + rot.f_82479_, entity.m_20188_() + rot.f_82480_, entity.m_20189_() + rot.f_82481_, 5, 0.0, 0.2 + entity.m_217043_().m_188500_() * 0.1, 0.0, 0.02);
    }

    private static boolean isStackingEffect(MobEffect effect) {
        Holder holder = BuiltInRegistries.f_256974_.m_263177_((Object)effect);
        return holder.m_203656_(NirvanaEffects.STACKING_EFFECTS);
    }

    public static void applyEffect(MobEffectInstance instance, ItemStack source, LivingEntity target, @Nullable LivingEntity cause) {
        MobEffectInstance existing = target.m_21124_(instance.m_19544_());
        if (existing != null && SmokingItem.isStackingEffect(instance.m_19544_())) {
            IStackingEffect stacking;
            MobEffect mobEffect = instance.m_19544_();
            if (mobEffect instanceof IStackingEffect && !(stacking = (IStackingEffect)mobEffect).shouldIncrease(source, target, target.m_9236_())) {
                return;
            }
            MobEffectInstance increased = new MobEffectInstance(instance.m_19544_(), instance.m_19557_(), existing.m_19564_() + 1, instance.m_19571_(), instance.m_19572_(), instance.m_19575_(), null, instance.m_216895_());
            target.m_7292_(increased);
            MobEffect mobEffect2 = instance.m_19544_();
            if (mobEffect2 instanceof IStackingEffect) {
                IStackingEffect stacking2 = (IStackingEffect)mobEffect2;
                stacking2.onIncreasedTo(increased, source, target, target.m_9236_());
            }
        } else if (instance.m_19544_().m_8093_()) {
            instance.m_19544_().m_19461_((Entity)cause, (Entity)cause, target, instance.m_19564_(), 1.0);
        } else {
            target.m_7292_(instance);
        }
    }

    private void applyEffects(ItemStack source, Level level, Vec3 pos, @Nullable LivingEntity user) {
        double range = this.getRadius(source, level, user) * 2.0;
        List targets = level.m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)pos, (double)range, (double)range, (double)range));
        targets.forEach(target -> this.getEffects(source, level, user).forEach(effect -> SmokingItem.applyEffect(effect, source, target, user)));
    }

    @Nullable
    protected SoundEvent getUseSound() {
        return (SoundEvent)NirvanaSounds.SMOKING.get();
    }

    public static ItemStack takeHit(Player player, ItemStack stack) {
        player.m_36335_().m_41524_(stack.m_41720_(), 20);
        return SmokingItem.takeHit(player.m_9236_(), player.m_20182_(), SoundSource.PLAYERS, player.m_150110_().f_35937_, stack);
    }

    static ItemStack takeHit(Level level, Vec3 pos, SoundSource soundSource, boolean simulate, ItemStack stack) {
        SoundEvent sound;
        Item item = stack.m_41720_();
        if (item instanceof SmokingItem) {
            SmokingItem item2 = (SmokingItem)item;
            v0 = item2.getUseSound();
        } else {
            v0 = sound = (SoundEvent)NirvanaSounds.SMOKING.get();
        }
        if (sound != null) {
            level.m_6263_(null, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), sound, soundSource, 1.0f, 1.0f);
        }
        if (simulate) {
            return stack;
        }
        Item remainder = stack.m_41720_().m_41469_();
        if (stack.m_41763_()) {
            stack.m_41721_(stack.m_41773_() + 1);
            if (stack.m_41773_() == stack.m_41776_()) {
                stack.m_41774_(1);
            }
        } else {
            stack.m_41774_(1);
        }
        if (stack.m_41619_() && remainder != null) {
            return remainder.m_7968_();
        }
        return stack;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        ServerPlayer player;
        entity.m_146850_(GameEvent.f_223704_);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.applyEffects(stack, level, entity.m_20182_(), entity);
            this.addParticles(serverLevel, entity);
        }
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            CriteriaTriggers.f_10592_.m_23682_(player, stack);
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return SmokingItem.takeHit((Player)player, stack);
        }
        return stack;
    }

    public static InteractionResultHolder<ItemStack> startUsing(Level level, Player player, InteractionHand hand) {
        if (!SmokingItem.canUse((LivingEntity)player)) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public static boolean canUse(LivingEntity entity) {
        return Services.CONFIG.common().allowFakePlayerSmoking() || !Services.PLATFORM.isFakePlayer(entity);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return SmokingItem.startUsing(level, player, hand);
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPYGLASS;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }
}

