/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.effects;

import galena.nirvana.index.NirvanaEffects;
import galena.nirvana.index.NirvanaEntities;
import galena.nirvana.index.NirvanaTags;
import galena.nirvana.platform.Services;
import galena.nirvana.world.effects.IStackingEffect;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PeaceEffect
extends MobEffect
implements IStackingEffect {
    private static final int REEFER_MIN_RANGE = 8;
    private static final int REEFER_MAX_RANGE = 20;
    private static final int REEFER_CONVERSION_RANGE = 20;
    private static final int REEFER_CONVERSION_RANGE_SQR = 400;

    public PeaceEffect() {
        super(MobEffectCategory.BENEFICIAL, 11190091);
    }

    private static boolean fulfills(int hitsTaken, int hitsRequired) {
        return hitsRequired >= 0 && hitsTaken >= hitsRequired;
    }

    public static boolean shouldRenderShader(@Nullable Player player) {
        if (!Services.CONFIG.client().renderPeaceShader()) {
            return false;
        }
        return Optional.ofNullable(player).map(it -> it.m_21124_((MobEffect)NirvanaEffects.PEACE.get())).filter(it -> PeaceEffect.fulfills(it.m_19564_(), Services.CONFIG.common().nauseaAfterHits())).isPresent();
    }

    @Override
    public boolean shouldIncrease(ItemStack source, LivingEntity target, Level level) {
        return source.m_204117_(NirvanaTags.NAUSEATING);
    }

    @Override
    public void onIncreasedTo(MobEffectInstance instance, ItemStack source, LivingEntity target, Level level) {
        int hitsTaken = instance.m_19564_() + 1;
        if (PeaceEffect.fulfills(hitsTaken, Services.CONFIG.common().reeferAfterHits())) {
            PeaceEffect.spawnReefers(target, level);
            PeaceEffect.transformCreepers(target.m_20182_(), level);
        }
        if (PeaceEffect.fulfills(hitsTaken, Services.CONFIG.common().hungerAfterHits())) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 400, 2));
        }
    }

    private static void transformCreepers(Vec3 around, Level level) {
        AABB box = new AABB(BlockPos.m_274446_((Position)around)).m_82400_(21.0);
        List targets = level.m_6443_(Creeper.class, box, it -> it.m_6095_().m_204039_(NirvanaTags.CREEPER_LIKE) && it.m_20238_(around) <= 400.0);
        targets.forEach(it -> {
            Mob replacement = (Mob)NirvanaEntities.REEFER.create(level);
            if (replacement == null) {
                return;
            }
            replacement.m_146884_(it.m_20182_());
            replacement.m_146922_(it.m_146908_());
            replacement.m_146926_(it.m_146909_());
            it.m_142687_(Entity.RemovalReason.DISCARDED);
            if (it.m_213877_()) {
                level.m_7967_((Entity)replacement);
            }
        });
    }

    private static void spawnReefers(LivingEntity target, Level level) {
        double chance = Services.CONFIG.common().reeferChance();
        if (chance <= 0.0) {
            return;
        }
        int rolls = level.m_46791_().m_19028_();
        for (int i = 0; i < rolls; ++i) {
            Mob reefer;
            if (!((double)target.m_217043_().m_188501_() < chance) || (reefer = (Mob)NirvanaEntities.REEFER.create(level)) == null) continue;
            int rangeAround = 6;
            int centerRange = 8 + rangeAround;
            Vec3 vec = new Vec3(target.m_217043_().m_188500_() * 2.0 - 1.0, target.m_217043_().m_188500_() * 2.0 - 1.0, target.m_217043_().m_188500_() * 2.0 - 1.0).m_82541_().m_82490_((double)centerRange);
            Vec3 reference = target.m_20182_().m_82549_(vec);
            level.m_285750_((Entity)reefer, new AABB(reference, reference).m_82400_((double)rangeAround)).map(it -> Vec3.m_82514_((Vec3i)it, (double)1.0)).ifPresent(pos -> {
                reefer.m_146884_(pos);
                level.m_7967_((Entity)reefer);
            });
        }
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributes, int i) {
        super.m_6385_(entity, attributes, i);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_6710_(null);
        }
    }
}

