/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.gui.ClientGUI;
import io.github.mortuusars.exposure.item.IFilmItem;
import io.github.mortuusars.exposure.menu.ItemRenameMenu;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilmRollItem
extends Item
implements IFilmItem {
    private final FilmType filmType;
    private final int barColor;

    public FilmRollItem(FilmType filmType, int barColor, Item.Properties properties) {
        super(properties);
        this.filmType = filmType;
        this.barColor = barColor;
    }

    @Override
    public FilmType getType() {
        return this.filmType;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return this.getExposedFramesCount(stack) > 0;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return Math.min(1 + 12 * this.getExposedFramesCount(stack) / this.getMaxFrameCount(stack), 13);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return this.barColor;
    }

    public void addFrame(ItemStack filmStack, CompoundTag frame) {
        ListTag listTag;
        CompoundTag tag = filmStack.m_41784_();
        if (!tag.m_128425_("Frames", 9)) {
            tag.m_128365_("Frames", (Tag)new ListTag());
        }
        if ((listTag = tag.m_128437_("Frames", 10)).size() >= this.getMaxFrameCount(filmStack)) {
            throw new IllegalStateException("Cannot add more frames than film could fit. Size: " + listTag.size());
        }
        listTag.add((Object)frame);
        tag.m_128365_("Frames", (Tag)listTag);
    }

    public boolean canAddFrame(ItemStack filmStack) {
        if (!filmStack.m_41782_() || !filmStack.m_41784_().m_128425_("Frames", 9)) {
            return true;
        }
        return filmStack.m_41784_().m_128437_("Frames", 10).size() < this.getMaxFrameCount(filmStack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        int developingStep;
        int frameSize;
        int exposedFrames = this.getExposedFramesCount(stack);
        if (exposedFrames > 0) {
            int totalFrames = this.getMaxFrameCount(stack);
            tooltipComponents.add((Component)Component.m_237110_((String)"item.exposure.film_roll.tooltip.frame_count", (Object[])new Object[]{exposedFrames, totalFrames}).m_130940_(ChatFormatting.GRAY));
        }
        if ((frameSize = this.getFrameSize(stack)) != this.getDefaultFrameSize()) {
            tooltipComponents.add((Component)Component.m_237110_((String)"item.exposure.film_roll.tooltip.frame_size", (Object[])new Object[]{Component.m_237113_((String)String.format("%.1f", Float.valueOf((float)frameSize / 10.0f)))}).m_130940_(ChatFormatting.GRAY));
        }
        if (((Boolean)Config.Common.FILM_ROLL_RENAMING.get()).booleanValue()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"item.exposure.film_roll.tooltip.renaming"));
        }
        int n = developingStep = stack.m_41783_() != null ? stack.m_41783_().m_128451_("CurrentDevelopingStep") : 0;
        if (((Boolean)Config.Common.CREATE_SPOUT_DEVELOPING_ENABLED.get()).booleanValue() && developingStep > 0) {
            int i;
            List totalSteps = (List)Config.Common.spoutDevelopingSequence(this.getType()).get();
            MutableComponent stepsComponent = Component.m_237113_((String)"");
            for (i = 0; i < developingStep; ++i) {
                stepsComponent.m_7220_((Component)Component.m_237113_((String)"I").m_130940_(ChatFormatting.GOLD));
            }
            for (i = developingStep; i < totalSteps.size(); ++i) {
                stepsComponent.m_7220_((Component)Component.m_237113_((String)"I").m_130940_(ChatFormatting.DARK_GRAY));
            }
            tooltipComponents.add((Component)Component.m_237110_((String)"item.exposure.film_roll.tooltip.developing_step", (Object[])new Object[]{stepsComponent}).m_130940_(ChatFormatting.GOLD));
        }
        if (exposedFrames > 0 && !PlatformHelper.isModLoaded("jei") && ((Boolean)Config.Client.RECIPE_TOOLTIPS_WITHOUT_JEI.get()).booleanValue()) {
            ClientGUI.addFilmRollDevelopingTooltip(stack, level, tooltipComponents, isAdvanced);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (!((Boolean)Config.Common.FILM_ROLL_RENAMING.get()).booleanValue() || !(player instanceof ServerPlayer)) {
            return super.m_7203_(level, player, usedHand);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        final int slot = this.getMatchingSlotInInventory(player.m_150109_(), player.m_21120_(usedHand));
        MenuProvider menuProvider = new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return Component.m_237115_((String)"gui.exposure.item_rename.title");
            }

            @NotNull
            public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
                return new ItemRenameMenu(containerId, playerInventory, slot);
            }
        };
        PlatformHelper.openMenu(serverPlayer, menuProvider, buffer -> buffer.writeInt(slot));
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(usedHand));
    }

    protected int getMatchingSlotInInventory(Inventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (!inventory.m_8020_(i).equals(stack)) continue;
            return i;
        }
        return -1;
    }
}

