/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.forge.integration.create;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.item.FilmRollItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class CreateFilmDeveloping {
    public static final String CURRENT_STEP_TAG = "CurrentDevelopingStep";
    private static final Map<FilmType, List<FluidStack>> cache = new HashMap<FilmType, List<FluidStack>>();

    public static SequencedAssemblyRecipe createSequencedDevelopingRecipe(FilmType filmType) {
        List<FluidStack> fillingSteps = CreateFilmDeveloping.getFillingSteps(filmType);
        SequencedAssemblyRecipeBuilder recipeBuilder = new SequencedAssemblyRecipeBuilder(Exposure.resource("sequenced_" + filmType.m_7912_() + "_film_developing")).require((ItemLike)filmType.createItemStack().m_41720_()).transitionTo((ItemLike)filmType.createItemStack().m_41720_()).loops(1).addOutput((ItemLike)filmType.createDevelopedItemStack().m_41720_(), 1.0f);
        for (FluidStack fluidStack : fillingSteps) {
            recipeBuilder.addStep(FillingRecipe::new, f -> f.require(FluidIngredient.fromFluidStack((FluidStack)fluidStack)));
        }
        return recipeBuilder.build();
    }

    public static List<FluidStack> getFillingSteps(FilmType filmType) {
        if (cache.containsKey((Object)filmType)) {
            return cache.get((Object)filmType);
        }
        List steps = (List)Config.Common.spoutDevelopingSequence(filmType).get();
        List<FluidStack> fluidStacks = CreateFilmDeveloping.loadStacks(steps);
        if (!fluidStacks.isEmpty()) {
            cache.put(filmType, fluidStacks);
            return fluidStacks;
        }
        Exposure.LOGGER.warn("Create Film Developing should have at least one step. Defaults will be loaded.");
        List defaultSteps = (List)Config.Common.spoutDevelopingSequence(filmType).getDefault();
        List<FluidStack> defaultFluidStacks = CreateFilmDeveloping.loadStacks(defaultSteps);
        if (defaultFluidStacks.isEmpty()) {
            throw new IllegalStateException("Failed to load default fluid stacks. Something isn't right.");
        }
        cache.put(filmType, defaultFluidStacks);
        return defaultFluidStacks;
    }

    @Nullable
    public static FluidStack getNextRequiredFluid(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof FilmRollItem)) {
            throw new IllegalArgumentException("Filling to develop film can only be used on FilmRollItem. Got: " + String.valueOf(stack));
        }
        FilmRollItem filmRollItem = (FilmRollItem)item;
        List<FluidStack> fillingSteps = CreateFilmDeveloping.getFillingSteps(filmRollItem.getType());
        CompoundTag tag = stack.m_41783_();
        if (tag == null || tag.m_128456_()) {
            return fillingSteps.get(0);
        }
        int nextStep = tag.m_128451_(CURRENT_STEP_TAG) + 1;
        if (nextStep > fillingSteps.size()) {
            return null;
        }
        return fillingSteps.get(Math.max(1, nextStep) - 1);
    }

    public static ItemStack fillFilmStack(ItemStack stack, int requiredAmount, FluidStack availableFluid) {
        ItemStack result;
        Item item = stack.m_41720_();
        if (!(item instanceof FilmRollItem)) {
            throw new IllegalArgumentException("Filling to develop film can only be used on FilmRollItem. Got: " + String.valueOf(stack));
        }
        FilmRollItem filmRollItem = (FilmRollItem)item;
        @Nullable FluidStack requiredFluid = CreateFilmDeveloping.getNextRequiredFluid(stack);
        if (requiredFluid == null) {
            throw new IllegalStateException("Cannot fill if fluid is not required anymore. This should have been handled in previous step.");
        }
        FilmType filmType = filmRollItem.getType();
        List<FluidStack> fillingSteps = CreateFilmDeveloping.getFillingSteps(filmType);
        int nextStep = CreateFilmDeveloping.getNextStep(stack);
        if (requiredAmount == 0 || nextStep == fillingSteps.size()) {
            result = filmType.createDevelopedItemStack();
            if (stack.m_41783_() != null) {
                result.m_41751_(stack.m_41784_().m_6426_());
            }
            result.m_41784_().m_128473_(CURRENT_STEP_TAG);
        } else {
            result = filmType.createItemStack();
            if (stack.m_41783_() != null) {
                result.m_41751_(stack.m_41784_().m_6426_());
            }
            result.m_41784_().m_128405_(CURRENT_STEP_TAG, nextStep);
        }
        availableFluid.shrink(requiredAmount);
        stack.m_41774_(1);
        return result;
    }

    public static int getNextStep(ItemStack stack) {
        return stack.m_41783_() != null ? stack.m_41783_().m_128451_(CURRENT_STEP_TAG) + 1 : 1;
    }

    public static void clearCachedData() {
        cache.clear();
    }

    private static List<FluidStack> loadStacks(List<? extends String> strings) {
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
        for (String string : strings) {
            @Nullable FluidStack fluidStack = CreateFilmDeveloping.getFluidStack(string);
            if (fluidStack == null) continue;
            stacks.add(fluidStack);
        }
        return stacks;
    }

    @Nullable
    private static FluidStack getFluidStack(String serializedString) {
        try {
            CompoundTag tag = TagParser.m_129359_((String)serializedString);
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)tag);
            if (!fluidStack.isEmpty()) {
                return fluidStack;
            }
            Exposure.LOGGER.warn("FluidStack [" + serializedString + "] was loaded empty.");
        }
        catch (CommandSyntaxException e) {
            Exposure.LOGGER.error("[" + serializedString + "] failed to load: " + String.valueOf((Object)e));
        }
        return null;
    }
}

