/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.viewfinder;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.camera.CameraClient;
import io.github.mortuusars.exposure.camera.infrastructure.FocalRange;
import io.github.mortuusars.exposure.camera.infrastructure.ZoomDirection;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderOverlay;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderShader;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.Fov;
import java.util.Objects;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class Viewfinder {
    public static final float ZOOM_STEP = 8.0f;
    public static final float ZOOM_PRECISE_MODIFIER = 0.25f;
    private static boolean isOpen;
    private static FocalRange focalRange;
    private static double targetFov;
    private static double currentFov;
    private static boolean shouldRestoreFov;

    public static boolean isOpen() {
        return isOpen;
    }

    public static boolean isLookingThrough() {
        return Viewfinder.isOpen() && (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON || Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_FRONT);
    }

    public static void open() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Preconditions.checkState((player != null ? 1 : 0) != 0, (Object)"Player should not be null");
        Preconditions.checkState((boolean)player.m_9236_().m_5776_(), (Object)"This should be called only client-side.");
        if (Viewfinder.isOpen()) {
            return;
        }
        Camera<?> camera = Camera.getCamera((Player)player).orElseThrow();
        CameraItem cameraItem = (CameraItem)((Object)camera.get().getItem());
        ItemStack cameraStack = camera.get().getStack();
        focalRange = cameraItem.getFocalRange(cameraStack);
        targetFov = Fov.focalLengthToFov(Mth.m_14036_((float)cameraItem.getFocalLength(cameraStack), (float)focalRange.min(), (float)focalRange.max()));
        isOpen = true;
        ViewfinderShader.setPrevious(ViewfinderShader.getCurrent().orElse(null));
        ViewfinderShader.update();
        ViewfinderOverlay.setup();
    }

    public static void update() {
        @Nullable LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Viewfinder.updateSelfieMode();
        ViewfinderShader.update();
    }

    public static void updateSelfieMode() {
        boolean inSelfieMode = Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_FRONT;
        CameraClient.setSelfieMode(inSelfieMode);
    }

    public static void close() {
        if (!Viewfinder.isOpen()) {
            return;
        }
        isOpen = false;
        targetFov = ((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue();
        ViewfinderShader.removeShader();
        ViewfinderShader.restorePrevious();
    }

    public static FocalRange getFocalRange() {
        return focalRange;
    }

    public static double getCurrentFov() {
        return currentFov;
    }

    public static float getSelfieCameraDistance() {
        return 1.75f;
    }

    public static void zoom(ZoomDirection direction, boolean precise) {
        double fov;
        double prevFov;
        double step = 8.0 * (1.0 - Mth.m_14008_((double)(((double)focalRange.min() - currentFov) / (double)focalRange.min()), (double)0.3f, (double)1.0));
        double inertia = Math.abs(targetFov - currentFov) * (double)0.8f;
        double change = step + inertia;
        if (precise) {
            change *= 0.25;
        }
        if (Math.abs((prevFov = targetFov) - (fov = Mth.m_14008_((double)(targetFov + (direction == ZoomDirection.IN ? -change : change)), (double)Fov.focalLengthToFov(focalRange.max()), (double)Fov.focalLengthToFov(focalRange.min())))) > (double)0.01f) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_216990_(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get());
        }
        targetFov = fov;
        CameraClient.setZoom(Fov.fovToFocalLength(fov));
    }

    public static double modifyMouseSensitivity(double sensitivity) {
        if (!Viewfinder.isLookingThrough()) {
            return sensitivity;
        }
        double modifier = Mth.m_14008_((double)(1.0 - (Double)Config.Client.VIEWFINDER_ZOOM_SENSITIVITY_MODIFIER.get() * (((double)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue() - currentFov) / 5.0)), (double)0.01, (double)2.0);
        return sensitivity * modifier;
    }

    public static boolean handleMouseScroll(ZoomDirection direction) {
        if (Viewfinder.isLookingThrough()) {
            Viewfinder.zoom(direction, false);
            return true;
        }
        return false;
    }

    public static double modifyFov(double fov) {
        if (Viewfinder.isLookingThrough()) {
            currentFov = Mth.m_14139_((double)Math.min(0.8f * Minecraft.m_91087_().m_91297_(), 0.8f), (double)currentFov, (double)targetFov);
            shouldRestoreFov = true;
            return currentFov;
        }
        if (shouldRestoreFov && Math.abs(currentFov - fov) > 1.0E-5) {
            currentFov = Mth.m_14139_((double)Math.min(0.95f * Minecraft.m_91087_().m_91297_(), 0.95f), (double)currentFov, (double)fov);
            return currentFov;
        }
        currentFov = fov;
        shouldRestoreFov = false;
        return fov;
    }

    static {
        focalRange = new FocalRange(18, 55);
        currentFov = targetFov = 90.0;
    }
}

