/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.camera.viewfinder.Viewfinder;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class Camera<T extends CameraItem> {
    private static final SortedMap<ResourceLocation, Function<Player, @Nullable Camera<?>>> CAMERA_GETTERS = new TreeMap();

    public static void registerCameraGetter(ResourceLocation id, Function<Player, @Nullable Camera<?>> cameraGetter) {
        Preconditions.checkState((!CAMERA_GETTERS.containsKey(id) ? 1 : 0) != 0, (String)"Camera getter with ID '{}' is already registered.", (Object)id);
        CAMERA_GETTERS.put(id, cameraGetter);
    }

    public static <T extends CameraItem> Optional<Camera<T>> getCamera(Player player, Class<T> clazz) {
        for (Function<Player, Camera<?>> getter : CAMERA_GETTERS.values()) {
            @Nullable Camera<?> camera = getter.apply(player);
            if (camera == null || !((Object)((Object)((CameraItem)((Object)camera.get().getItem())))).getClass().equals(clazz)) continue;
            Camera<?> cameraOfType = camera;
            return Optional.of(cameraOfType);
        }
        return Optional.empty();
    }

    public static Optional<Camera<?>> getCamera(Player player) {
        for (Function<Player, Camera<?>> getter : CAMERA_GETTERS.values()) {
            @Nullable Camera<?> camera = getter.apply(player);
            if (camera == null) continue;
            return Optional.of(camera);
        }
        return Optional.empty();
    }

    public abstract void activate(Player var1);

    public abstract void deactivate(Player var1);

    public abstract ItemAndStack<T> get();

    public void clientTick() {
    }

    public Camera<T> apply(BiConsumer<T, ItemStack> function) {
        this.get().apply(function);
        return this;
    }

    public static void onLocalPlayerTick(Player player) {
        Preconditions.checkState((boolean)player.m_7578_(), (String)"{} is not a LocalPlayer.", (Object)player);
        boolean viewfinderOpen = Viewfinder.isOpen();
        Camera.getCamera(player).ifPresentOrElse(camera -> {
            if (!viewfinderOpen) {
                Viewfinder.open();
            } else {
                Viewfinder.update();
            }
            camera.clientTick();
        }, Viewfinder::close);
    }
}

