/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.common.entities;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.api.variant.SpawnContext;
import com.blackgear.vanillabackport.common.api.variant.VariantHolder;
import com.blackgear.vanillabackport.common.api.variant.VariantUtils;
import com.blackgear.vanillabackport.common.api.wolf.BackportedWolvesConversion;
import com.blackgear.vanillabackport.common.api.wolf.WolfSoundVariant;
import com.blackgear.vanillabackport.common.api.wolf.WolfSoundVariantHolder;
import com.blackgear.vanillabackport.common.api.wolf.WolfSoundVariants;
import com.blackgear.vanillabackport.common.level.entities.wolf.ModCrackiness;
import com.blackgear.vanillabackport.common.level.entities.wolf.WolfSoundVariantsModule;
import com.blackgear.vanillabackport.common.level.entities.wolf.WolfVariant;
import com.blackgear.vanillabackport.common.level.entities.wolf.WolfVariants;
import com.blackgear.vanillabackport.common.level.items.WolfArmorItem;
import com.blackgear.vanillabackport.common.registries.ModItems;
import com.blackgear.vanillabackport.core.mixin.common.entities.TamableAnimalMixin;
import com.blackgear.vanillabackport.core.registries.ModBuiltinRegistries;
import com.blackgear.vanillabackport.core.util.ColorUtils;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Wolf.class})
public abstract class WolfMixin
extends TamableAnimalMixin
implements NeutralMob,
WolfSoundVariantHolder,
VariantHolder<WolfVariant> {
    @Unique
    private static final EntityDataAccessor<String> DATA_SOUND_VARIANT_ID = SynchedEntityData.m_135353_(Wolf.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    @Unique
    private static final EntityDataAccessor<String> DATA_VARIANT_ID = SynchedEntityData.m_135353_(Wolf.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    @Shadow
    public abstract DyeColor m_30428_();

    protected WolfMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/animal/Wolf;"}, at={@At(value="RETURN")})
    private void vb$getBreedOffspring(ServerLevel level, AgeableMob otherParent, CallbackInfoReturnable<Wolf> cir) {
        Wolf child = (Wolf)cir.getReturnValue();
        if (child != null && otherParent instanceof Wolf) {
            Wolf mate = (Wolf)otherParent;
            if (this.m_21824_()) {
                DyeColor fatherColor = this.m_30428_();
                DyeColor motherColor = mate.m_30428_();
                child.m_30397_(ColorUtils.getMixedColor(level, fatherColor, motherColor));
            }
            WolfSoundVariantHolder.of(child).vb$setSoundVariant((WolfSoundVariant)ModBuiltinRegistries.WOLF_SOUND_VARIANTS.getRandomElement(this.m_217043_()));
            VariantHolder.vb$trySetOffspringVariant((LivingEntity)child, this, (LivingEntity)mate);
        }
    }

    @Override
    public WolfVariant vb$getVariant() {
        return VariantUtils.getVariant(ModBuiltinRegistries.WOLF_VARIANTS, (String)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    @Override
    public void vb$setVariant(WolfVariant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)VariantUtils.getID(ModBuiltinRegistries.WOLF_VARIANTS, variant));
    }

    @Override
    public WolfSoundVariant vb$getSoundVariant() {
        return VariantUtils.getVariant(ModBuiltinRegistries.WOLF_SOUND_VARIANTS, (String)this.f_19804_.m_135370_(DATA_SOUND_VARIANT_ID));
    }

    @Override
    public void vb$setSoundVariant(WolfSoundVariant variant) {
        this.f_19804_.m_135381_(DATA_SOUND_VARIANT_ID, (Object)VariantUtils.getID(ModBuiltinRegistries.WOLF_SOUND_VARIANTS, variant));
    }

    @Override
    protected void vb$defineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_SOUND_VARIANT_ID, (Object)VariantUtils.getDefaultID(ModBuiltinRegistries.WOLF_SOUND_VARIANTS, WolfSoundVariants.CLASSIC));
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)VariantUtils.getDefaultID(ModBuiltinRegistries.WOLF_VARIANTS, WolfVariants.PALE));
    }

    @Override
    protected void vb$addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        VariantUtils.addVariantSaveData(this, tag, ModBuiltinRegistries.WOLF_VARIANTS);
        tag.m_128359_("sound_variant", ModBuiltinRegistries.WOLF_SOUND_VARIANTS.getKey((Object)this.vb$getSoundVariant()).toString());
    }

    @Override
    protected void vb$readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        BackportedWolvesConversion.migrateWolfVariant(this, tag, ModBuiltinRegistries.WOLF_VARIANTS);
        VariantUtils.readVariantSaveData(this, tag, ModBuiltinRegistries.WOLF_VARIANTS);
        WolfSoundVariant soundVariant = (WolfSoundVariant)ModBuiltinRegistries.WOLF_SOUND_VARIANTS.get(ResourceLocation.m_135820_((String)tag.m_128461_("sound_variant")));
        if (soundVariant != null) {
            this.vb$setSoundVariant(soundVariant);
        }
    }

    @Override
    protected void vb$finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnData, CompoundTag dataTag, CallbackInfoReturnable<SpawnGroupData> cir) {
        this.vb$setSoundVariant((WolfSoundVariant)ModBuiltinRegistries.WOLF_SOUND_VARIANTS.getRandomElement(level.m_213780_()));
        VariantUtils.selectWolfVariantToSpawn(SpawnContext.create(level, this.m_20183_()), ModBuiltinRegistries.WOLF_VARIANTS, WolfVariants.PALE).ifPresent(this::vb$setVariant);
    }

    @Inject(method={"getAmbientSound"}, at={@At(value="HEAD")}, cancellable=true)
    public void vb$getAmbientSound(CallbackInfoReturnable<SoundEvent> cir) {
        SoundEvent result = WolfSoundVariantsModule.getAmbientSound((Wolf)this);
        if (result != null) {
            cir.setReturnValue((Object)result);
        }
    }

    @Inject(method={"getHurtSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$getHurtSound(DamageSource source, CallbackInfoReturnable<SoundEvent> cir) {
        SoundEvent result;
        if (this.canArmorAbsorb(source)) {
            cir.setReturnValue((Object)ModSoundEvents.WOLF_ARMOR_DAMAGE.get());
        }
        if ((result = WolfSoundVariantsModule.getHurtSound((Wolf)this)) != null) {
            cir.setReturnValue((Object)result);
        }
    }

    @Inject(method={"getDeathSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$getDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        SoundEvent result = WolfSoundVariantsModule.getDeathSound((Wolf)this);
        if (result != null) {
            cir.setReturnValue((Object)result);
        }
    }

    protected void m_6475_(DamageSource damageSource, float damageAmount) {
        if (!this.canArmorAbsorb(damageSource)) {
            super.m_6475_(damageSource, damageAmount);
        } else {
            ItemStack stack = this.m_6844_(EquipmentSlot.CHEST);
            int i = stack.m_41773_();
            int j = stack.m_41776_();
            stack.m_41622_(Mth.m_14167_((float)damageAmount), (LivingEntity)this, wolf -> wolf.m_21166_(EquipmentSlot.CHEST));
            if (ModCrackiness.WOLF_ARMOR.byDamage(i, j) != ModCrackiness.WOLF_ARMOR.byDamage(this.m_6844_(EquipmentSlot.CHEST))) {
                this.m_216990_(ModSoundEvents.WOLF_ARMOR_CRACK.get());
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel level2 = (ServerLevel)level;
                    level2.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, ModItems.ARMADILLO_SCUTE.get().m_7968_()), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 20, 0.2, 0.1, 0.2, 0.1);
                }
            }
        }
    }

    @Unique
    private boolean canArmorAbsorb(DamageSource source) {
        return this.hasArmor() && !source.m_269533_(DamageTypeTags.f_268490_);
    }

    protected void m_6472_(DamageSource damageSource, float damageAmount) {
        if (damageAmount > 0.0f) {
            int i = (int)Math.max(1.0f, damageAmount / 4.0f);
            ItemStack stack = this.m_6844_(EquipmentSlot.CHEST);
            if (stack.m_41720_() instanceof WolfArmorItem) {
                stack.m_41622_(i, (LivingEntity)this, wolf -> wolf.m_21166_(EquipmentSlot.CHEST));
            }
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.m_9236_().f_46443_ && this.m_21824_()) {
            ItemStack armor;
            if (stack.m_150930_(ModItems.WOLF_ARMOR.get()) && this.m_21830_((LivingEntity)player) && this.m_6844_(EquipmentSlot.CHEST).m_41619_() && !this.m_6162_()) {
                this.m_8061_(EquipmentSlot.CHEST, stack.m_255036_(1));
                this.m_216990_(ModSoundEvents.ARMOR_EQUIP_WOLF.get());
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            } else if (stack.m_150930_(Items.f_42574_) && this.m_21830_((LivingEntity)player) && this.hasArmor() && (!EnchantmentHelper.m_44920_((ItemStack)this.m_6844_(EquipmentSlot.CHEST)) || player.m_7500_())) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                this.m_216990_(ModSoundEvents.ARMOR_UNEQUIP_WOLF.get());
                ItemStack armor2 = this.m_6844_(EquipmentSlot.CHEST);
                this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
                this.m_19983_(armor2);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            } else if (stack.m_150930_(ModItems.ARMADILLO_SCUTE.get()) && this.m_21825_() && this.hasArmor() && this.m_21830_((LivingEntity)player) && (armor = this.m_6844_(EquipmentSlot.CHEST)).m_41768_()) {
                int repair = Mth.m_14167_((float)((float)armor.m_41776_() * 0.125f));
                int current = armor.m_41773_();
                int newDamage = Math.max(0, current - repair);
                if (newDamage < current) {
                    armor.m_41721_(newDamage);
                    this.m_216990_(ModSoundEvents.WOLF_ARMOR_REPAIR.get());
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    cir.setReturnValue((Object)InteractionResult.SUCCESS);
                }
            }
        }
    }

    @Unique
    private boolean hasArmor() {
        return this.m_6844_(EquipmentSlot.CHEST).m_150930_(ModItems.WOLF_ARMOR.get());
    }
}

