/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.common.blocks.entities;

import com.blackgear.vanillabackport.common.api.block.RandomizableContainer;
import com.blackgear.vanillabackport.common.api.block.entity.DecoratedPot;
import com.blackgear.vanillabackport.common.level.blockentities.decoratedpot.WobbleStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DecoratedPotBlockEntity.class})
public abstract class DecoratedPotBlockEntityMixin
extends BlockEntity
implements RandomizableContainer,
DecoratedPot {
    @Unique
    private static final String TAG_ITEM = "item";
    @Unique
    private static final int EVENT_POT_WOBBLES = 1;
    @Unique
    public long vb$wobbleStartedAtTick;
    @Unique
    @Nullable
    public WobbleStyle vb$lastWobbleStyle;
    @Unique
    private ItemStack vb$item = ItemStack.f_41583_;
    @Unique
    @Nullable
    protected ResourceLocation vb$lootTable;
    @Unique
    protected long vb$lootTableSeed;

    public DecoratedPotBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void vb$load(CompoundTag tag, CallbackInfo ci) {
        this.vb$item = !this.tryLoadLootTable(tag) && this.f_58857_ != null ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_ITEM)) : ItemStack.f_41583_;
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    public void vb$saveAdditional(CompoundTag tag, CallbackInfo ci) {
        if (!this.trySaveLootTable(tag) && !this.vb$item.m_41619_()) {
            CompoundTag itemTag = new CompoundTag();
            this.vb$item.m_41739_(itemTag);
            tag.m_128365_(TAG_ITEM, (Tag)itemTag);
        }
    }

    public boolean m_7531_(int id, int type) {
        if (this.f_58857_ != null && id == 1 && type >= 0 && type < WobbleStyle.values().length) {
            this.vb$wobbleStartedAtTick = this.f_58857_.m_46467_();
            this.vb$lastWobbleStyle = WobbleStyle.values()[type];
            return true;
        }
        return super.m_7531_(id, type);
    }

    @Override
    public WobbleStyle getLastWobbleStyle() {
        return this.vb$lastWobbleStyle;
    }

    @Override
    public long getWobbleStartedAtTick() {
        return this.vb$wobbleStartedAtTick;
    }

    @Override
    public void wobble(WobbleStyle style) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 1, style.ordinal());
        }
    }

    @Override
    @Nullable
    public ResourceLocation getLootTable() {
        return this.vb$lootTable;
    }

    @Override
    public long getLootTableSeed() {
        return this.vb$lootTableSeed;
    }

    @Override
    public void setLootTableSeed(long seed) {
        this.vb$lootTableSeed = seed;
    }

    @Override
    public void setLootTable(@Nullable ResourceLocation lootTable) {
        this.vb$lootTable = lootTable;
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return slot == 0 ? this.m_272036_() : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_272036_() {
        this.unpackLootTable(null);
        return this.vb$item;
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        return slot != 0 ? ItemStack.f_41583_ : this.splitFirstItem(amount);
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        if (slot == 0) {
            this.m_272287_(stack);
        }
    }

    public void m_272287_(@NotNull ItemStack stack) {
        this.unpackLootTable(null);
        this.vb$item = stack;
    }

    @Unique
    public ItemStack splitFirstItem(int stack) {
        this.unpackLootTable(null);
        ItemStack itemstack = this.vb$item.m_41620_(stack);
        if (this.vb$item.m_41619_()) {
            this.vb$item = ItemStack.f_41583_;
        }
        return itemstack;
    }

    @Override
    @Nullable
    public Level m_58904_() {
        return this.f_58857_;
    }

    @Override
    public BlockPos m_58899_() {
        return this.f_58858_;
    }

    @Override
    public BlockEntity getContainerBlockEntity() {
        return this;
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            DecoratedPotBlockEntityMixin.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)this.m_58900_());
        }
    }
}

