/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.armadillo;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class MobSensor<T extends LivingEntity>
extends Sensor<T> {
    private final BiPredicate<T, LivingEntity> mobTest;
    private final Predicate<T> readyTest;
    private final MemoryModuleType<Boolean> toSet;
    private final int memoryTimeToLive;

    public MobSensor(int scanRate, BiPredicate<T, LivingEntity> mobTest, Predicate<T> readyTest, MemoryModuleType<Boolean> toSet, int memoryTimeToLive) {
        super(scanRate);
        this.mobTest = mobTest;
        this.readyTest = readyTest;
        this.toSet = toSet;
        this.memoryTimeToLive = memoryTimeToLive;
    }

    protected void m_5578_(ServerLevel level, T entity) {
        if (!this.readyTest.test(entity)) {
            this.clearMemory(entity);
        } else {
            this.checkForMobsNearby(entity);
        }
    }

    public Set<MemoryModuleType<?>> m_7163_() {
        return Set.of(MemoryModuleType.f_148204_);
    }

    private void checkForMobsNearby(T entity) {
        boolean mobDetected;
        Optional entities = entity.m_6274_().m_21952_(MemoryModuleType.f_148204_);
        if (entities.isPresent() && (mobDetected = ((List)entities.get()).stream().anyMatch(mob -> this.mobTest.test((LivingEntity)entity, (LivingEntity)mob)))) {
            this.mobDetected(entity);
        }
    }

    private void mobDetected(T entity) {
        entity.m_6274_().m_21882_(this.toSet, (Object)true, (long)this.memoryTimeToLive);
    }

    private void clearMemory(T entity) {
        entity.m_6274_().m_21936_(this.toSet);
    }
}

