/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.armadillo;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.level.entities.armadillo.Armadillo;
import com.blackgear.vanillabackport.common.level.entities.armadillo.ArmadilloState;
import com.blackgear.vanillabackport.common.registries.ModEntities;
import com.blackgear.vanillabackport.common.registries.ModMemoryModules;
import com.blackgear.vanillabackport.common.registries.ModSensorTypes;
import com.blackgear.vanillabackport.core.mixin.access.AnimalMakeLoveAccessor;
import com.blackgear.vanillabackport.core.util.TimeUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.schedule.Activity;

public class ArmadilloAi {
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.m_146622_((int)5, (int)16);
    private static final ImmutableList<SensorType<? extends Sensor<? super Armadillo>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, ModSensorTypes.ARMADILLO_TEMPTATIONS.get(), (Object)SensorType.f_26822_, ModSensorTypes.ARMADILLO_SCARE_DETECTED.get());
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_217768_, (Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_148196_, (Object)MemoryModuleType.f_148197_, (Object)MemoryModuleType.f_244205_, (Object)MemoryModuleType.f_148198_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26375_, MemoryModuleType.f_26331_, ModMemoryModules.DANGER_DETECTED_RECENTLY.get()});
    private static final OneShot<Armadillo> ARMADILLO_ROLLING_OUT = BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_258080_(ModMemoryModules.DANGER_DETECTED_RECENTLY.get())).apply((Applicative)instance, accessor -> (level, armadillo, gameTime) -> {
        if (armadillo.isScared()) {
            armadillo.rollOut();
            return true;
        }
        return false;
    }));

    public static Brain.Provider<Armadillo> brainProvider() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected static Brain<?> makeBrain(Brain<Armadillo> brain) {
        ArmadilloAi.initCoreActivity(brain);
        ArmadilloAi.initIdleActivity(brain);
        ArmadilloAi.initScaredActivity(brain);
        brain.m_21930_(Set.of(Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<Armadillo> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)((Object)new ArmadilloPanic(2.0f)), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(){

            protected boolean m_6114_(ServerLevel level, Mob owner) {
                return !((Armadillo)owner).isScared() && super.m_6114_(level, owner);
            }
        }, (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_), (Object)new CountDownCooldownTicks(MemoryModuleType.f_244205_), ARMADILLO_ROLLING_OUT));
    }

    private static void initIdleActivity(Brain<Armadillo> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)((Object)new ArmadilloMakeLove(ModEntities.ARMADILLO.get(), 1.0f, 1))), (Object)Pair.of((Object)2, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(entity -> Float.valueOf(1.25f), entity -> entity.m_6162_() ? 1.0 : 2.0), (Object)1), (Object)Pair.of((Object)BabyFollowAdult.m_257685_((UniformInt)ADULT_FOLLOW_RANGE, (float)1.25f), (Object)1)))), (Object)Pair.of((Object)3, (Object)new RandomLookAround((IntProvider)UniformInt.m_146622_((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)4, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)1.0f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))));
    }

    private static void initScaredActivity(Brain<Armadillo> brain) {
        brain.m_21903_(Activity.f_37984_, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new ArmadilloBallUp()))), Set.of(Pair.of(ModMemoryModules.DANGER_DETECTED_RECENTLY.get(), (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.f_217768_, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    public static void updateActivity(Armadillo armadillo) {
        armadillo.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37984_, (Object)Activity.f_37979_));
    }

    public static class ArmadilloPanic
    extends AnimalPanic {
        public ArmadilloPanic(float speedMultiplier) {
            super(speedMultiplier, mob -> mob.m_6060_() || mob.m_203117_());
        }

        protected void m_6735_(ServerLevel level, PathfinderMob entity, long gameTime) {
            ((Armadillo)entity).rollOut();
            super.m_6735_(level, entity, gameTime);
        }
    }

    public static class ArmadilloMakeLove
    extends AnimalMakeLove {
        private final int closeEnoughDistance;

        public ArmadilloMakeLove(EntityType<? extends Armadillo> entityType, float speedModifier, int closeEnoughDistance) {
            super(entityType, speedModifier);
            this.closeEnoughDistance = closeEnoughDistance;
        }

        protected void m_6735_(ServerLevel level, Animal entity, long gameTime) {
            Animal animal = ((AnimalMakeLoveAccessor)((Object)this)).callFindValidBreedPartner(entity).get();
            entity.m_6274_().m_21879_(MemoryModuleType.f_26375_, (Object)animal);
            animal.m_6274_().m_21879_(MemoryModuleType.f_26375_, (Object)entity);
            ArmadilloMakeLove.lockGazeAndWalkToEachOther((LivingEntity)entity, (LivingEntity)animal, ((AnimalMakeLoveAccessor)((Object)this)).getSpeedModifier(), this.closeEnoughDistance);
            int i = 60 + entity.m_217043_().m_188503_(50);
            ((AnimalMakeLoveAccessor)((Object)this)).setSpawnChildAtTime(gameTime + (long)i);
        }

        public static void lockGazeAndWalkToEachOther(LivingEntity firstEntity, LivingEntity secondEntity, float speed, int distance) {
            ArmadilloMakeLove.lookAtEachOther(firstEntity, secondEntity);
            ArmadilloMakeLove.setWalkAndLookTargetMemoriesToEachOther(firstEntity, secondEntity, speed, distance);
        }

        private static void lookAtEachOther(LivingEntity firstEntity, LivingEntity secondEntity) {
            BehaviorUtils.m_22595_((LivingEntity)firstEntity, (LivingEntity)secondEntity);
            BehaviorUtils.m_22595_((LivingEntity)secondEntity, (LivingEntity)firstEntity);
        }

        private static void setWalkAndLookTargetMemoriesToEachOther(LivingEntity firstEntity, LivingEntity secondEntity, float speed, int distance) {
            BehaviorUtils.m_22590_((LivingEntity)firstEntity, (Entity)secondEntity, (float)speed, (int)distance);
            BehaviorUtils.m_22590_((LivingEntity)secondEntity, (Entity)firstEntity, (float)speed, (int)distance);
        }
    }

    public static class ArmadilloBallUp
    extends Behavior<Armadillo> {
        static final int BALL_UP_STAY_IN_STATE = 5 * TimeUtils.SECONDS_PER_MINUTE * 20;
        int nextPeekTimer = 0;
        boolean dangerWasAround;

        public ArmadilloBallUp() {
            super(Map.of(), BALL_UP_STAY_IN_STATE);
        }

        protected void tick(ServerLevel level, Armadillo armadillo, long gameTime) {
            super.m_6725_(level, (LivingEntity)armadillo, gameTime);
            if (this.nextPeekTimer > 0) {
                --this.nextPeekTimer;
            }
            if (armadillo.shouldSwitchToScaredState()) {
                armadillo.switchToState(ArmadilloState.SCARED);
                if (armadillo.m_20096_()) {
                    armadillo.m_216990_(ModSoundEvents.ARMADILLO_LAND.get());
                }
            } else {
                boolean bl;
                ArmadilloState state = armadillo.getState();
                long l = armadillo.m_6274_().m_147341_(ModMemoryModules.DANGER_DETECTED_RECENTLY.get());
                boolean bl2 = bl = l > 75L;
                if (bl != this.dangerWasAround) {
                    this.nextPeekTimer = this.pickNextPeekTimer(armadillo);
                }
                this.dangerWasAround = bl;
                if (state == ArmadilloState.SCARED) {
                    if (this.nextPeekTimer == 0 && armadillo.m_20096_() && bl) {
                        level.m_7605_((Entity)armadillo, (byte)64);
                        this.nextPeekTimer = this.pickNextPeekTimer(armadillo);
                    }
                    if (l < (long)ArmadilloState.UNROLLING.animationDuration()) {
                        armadillo.m_216990_(ModSoundEvents.ARMADILLO_UNROLL_START.get());
                        armadillo.switchToState(ArmadilloState.UNROLLING);
                    }
                } else if (state == ArmadilloState.UNROLLING && l > (long)ArmadilloState.UNROLLING.animationDuration()) {
                    armadillo.switchToState(ArmadilloState.SCARED);
                }
            }
        }

        private int pickNextPeekTimer(Armadillo armadillo) {
            return ArmadilloState.SCARED.animationDuration() + armadillo.m_217043_().m_216332_(100, 400);
        }

        protected boolean checkExtraStartConditions(ServerLevel level, Armadillo armadillo) {
            return armadillo.m_20096_();
        }

        protected boolean canStillUse(ServerLevel level, Armadillo armadillo, long gameTime) {
            return armadillo.getState().isThreatened();
        }

        protected void start(ServerLevel level, Armadillo armadillo, long gameTime) {
            armadillo.rollUp();
        }

        protected void stop(ServerLevel level, Armadillo armadillo, long gameTime) {
            if (!armadillo.canStayRolledUp()) {
                armadillo.rollOut();
            }
        }
    }
}

