/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.armadillo;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.level.entities.armadillo.ArmadilloAi;
import com.blackgear.vanillabackport.common.level.entities.armadillo.ArmadilloState;
import com.blackgear.vanillabackport.common.registries.ModBuiltInLootTables;
import com.blackgear.vanillabackport.common.registries.ModEntities;
import com.blackgear.vanillabackport.common.registries.ModEntityDataSerializers;
import com.blackgear.vanillabackport.common.registries.ModItems;
import com.blackgear.vanillabackport.common.registries.ModMemoryModules;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import com.blackgear.vanillabackport.core.data.tags.ModItemTags;
import com.blackgear.vanillabackport.core.util.AnimationUtils;
import com.blackgear.vanillabackport.core.util.MobUtils;
import com.blackgear.vanillabackport.core.util.TimeUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class Armadillo
extends Animal {
    public static final EntityDataAccessor<ArmadilloState> ARMADILLO_STATE = SynchedEntityData.m_135353_(Armadillo.class, ModEntityDataSerializers.ARMADILLO_STATE);
    public static final Ingredient IS_FOOD = Ingredient.m_204132_(ModItemTags.ARMADILLO_FOOD);
    private long inStateTicks = 0L;
    public final AnimationState rollOutAnimationState = new AnimationState();
    public final AnimationState rollUpAnimationState = new AnimationState();
    public final AnimationState peekAnimationState = new AnimationState();
    private int scuteTime;
    private boolean peekReceivedClient = false;

    public Armadillo(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.m_21573_().m_7008_(true);
        this.scuteTime = this.pickNextScuteDropTime();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)ModEntities.ARMADILLO.get().m_20615_((Level)level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.14);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ARMADILLO_STATE, (Object)ArmadilloState.IDLE);
    }

    public boolean isScared() {
        return this.getState() != ArmadilloState.IDLE;
    }

    public boolean shouldHideInShell() {
        return this.getState().shouldHideInShell(this.inStateTicks);
    }

    public boolean shouldSwitchToScaredState() {
        return this.getState() == ArmadilloState.ROLLING && this.inStateTicks > (long)ArmadilloState.ROLLING.animationDuration();
    }

    public ArmadilloState getState() {
        return (ArmadilloState)((Object)this.f_19804_.m_135370_(ARMADILLO_STATE));
    }

    public void switchToState(ArmadilloState state) {
        this.f_19804_.m_135381_(ARMADILLO_STATE, (Object)state);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (ARMADILLO_STATE.equals(key)) {
            this.inStateTicks = 0L;
        }
        super.m_7350_(key);
    }

    public Brain<Armadillo> m_6274_() {
        return super.m_6274_();
    }

    protected Brain.Provider<Armadillo> m_5490_() {
        return ArmadilloAi.brainProvider();
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return ArmadilloAi.makeBrain((Brain<Armadillo>)this.m_5490_().m_22073_(dynamic));
    }

    protected void m_8024_() {
        ServerLevel level = (ServerLevel)this.m_9236_();
        ProfilerFiller profiler = level.m_46473_();
        profiler.m_6180_("armadilloBrain");
        this.m_6274_().m_21865_(level, (LivingEntity)this);
        profiler.m_6182_("armadilloActivityUpdate");
        ArmadilloAi.updateActivity(this);
        profiler.m_7238_();
        if (this.m_6084_() && !this.m_6162_() && --this.scuteTime <= 0) {
            if (this.dropFromGiftLootTable(level, ModBuiltInLootTables.ARMADILLO_SHED, (serverLevel, stack) -> this.m_19983_((ItemStack)stack))) {
                this.m_5496_(ModSoundEvents.ARMADILLO_SCUTE_DROP.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.m_146850_(GameEvent.f_157810_);
            }
            this.scuteTime = this.pickNextScuteDropTime();
        }
        super.m_8024_();
    }

    private int pickNextScuteDropTime() {
        return this.f_19796_.m_188503_(20 * TimeUtils.SECONDS_PER_MINUTE * 5) + 20 * TimeUtils.SECONDS_PER_MINUTE * 5;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        if (this.isScared()) {
            float f = this.m_8085_();
            float g = this.m_6080_();
            float h = Mth.m_14177_((float)(this.f_20883_ - g));
            float i = Mth.m_14036_((float)Mth.m_14177_((float)(this.f_20883_ - g)), (float)(-f), (float)f);
            float j = g + h - i;
            this.m_5616_(j);
        }
        ++this.inStateTicks;
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.6f : 1.0f;
    }

    private void setupAnimationStates() {
        switch (this.getState()) {
            case IDLE: {
                this.rollOutAnimationState.m_216973_();
                this.rollUpAnimationState.m_216973_();
                this.peekAnimationState.m_216973_();
                break;
            }
            case ROLLING: {
                this.rollOutAnimationState.m_216973_();
                this.rollUpAnimationState.m_216982_(this.f_19797_);
                this.peekAnimationState.m_216973_();
                break;
            }
            case SCARED: {
                this.rollOutAnimationState.m_216973_();
                this.rollUpAnimationState.m_216973_();
                if (this.peekReceivedClient) {
                    this.peekAnimationState.m_216973_();
                    this.peekReceivedClient = false;
                }
                if (this.inStateTicks == 0L) {
                    this.peekAnimationState.m_216977_(this.f_19797_);
                    AnimationUtils.fastForward(this.peekAnimationState, ArmadilloState.SCARED.animationDuration(), 1.0f);
                    break;
                }
                this.peekAnimationState.m_216982_(this.f_19797_);
                break;
            }
            case UNROLLING: {
                this.rollOutAnimationState.m_216982_(this.f_19797_);
                this.rollUpAnimationState.m_216973_();
                this.peekAnimationState.m_216973_();
            }
        }
    }

    public void m_7822_(byte id) {
        if (id == 64 && this.m_9236_().f_46443_) {
            this.peekReceivedClient = true;
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), ModSoundEvents.ARMADILLO_PEEK.get(), this.m_5720_(), 1.0f, 1.0f, false);
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(ModItemTags.ARMADILLO_FOOD);
    }

    public static boolean checkArmadilloSpawnRules(EntityType<Armadillo> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos.m_7495_()).m_204336_(ModBlockTags.ARMADILLO_SPAWNABLE_ON) && Armadillo.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public boolean isScaredBy(LivingEntity entity) {
        if (!this.m_20191_().m_82377_(7.0, 2.0, 7.0).m_82381_(entity.m_20191_())) {
            return false;
        }
        if (entity.m_6336_() == MobType.f_21641_) {
            return true;
        }
        if (this.m_21188_() == entity) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.m_5833_() && (player.m_20142_() || player.m_20159_());
        }
        return false;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("state", this.getState().m_7912_());
        compound.m_128405_("scute_time", this.scuteTime);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.switchToState(ArmadilloState.fromName(compound.m_128461_("state")));
        if (compound.m_128441_("scute_time")) {
            this.scuteTime = compound.m_128451_("scute_time");
        }
    }

    public void rollUp() {
        if (!this.isScared()) {
            this.stopInPlace();
            this.m_27594_();
            this.m_146850_(GameEvent.f_223708_);
            this.m_216990_(ModSoundEvents.ARMADILLO_ROLL.get());
            this.switchToState(ArmadilloState.ROLLING);
        }
    }

    public void rollOut() {
        if (this.isScared()) {
            this.m_146850_(GameEvent.f_223708_);
            this.m_216990_(ModSoundEvents.ARMADILLO_UNROLL_FINISH.get());
            this.switchToState(ArmadilloState.IDLE);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isScared()) {
            amount = (amount - 1.0f) / 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_6475_(DamageSource damageSource, float damageAmount) {
        super.m_6475_(damageSource, damageAmount);
        if (!this.m_21525_() && !this.m_21224_()) {
            if (damageSource.m_7639_() instanceof LivingEntity) {
                this.m_6274_().m_21882_(ModMemoryModules.DANGER_DETECTED_RECENTLY.get(), (Object)true, 80L);
                if (this.canStayRolledUp()) {
                    this.rollUp();
                }
            } else if (this.m_203117_() || this.m_6060_()) {
                this.rollOut();
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_271356_) && this.brushOffScute()) {
            stack.m_41622_(16, (LivingEntity)player, p -> p.m_21190_(hand));
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return this.isScared() ? InteractionResult.FAIL : super.m_6071_(player, hand);
    }

    public boolean brushOffScute() {
        if (this.m_6162_()) {
            return false;
        }
        this.m_19983_(new ItemStack((ItemLike)ModItems.ARMADILLO_SCUTE.get()));
        this.m_146850_(GameEvent.f_223708_);
        this.m_216990_(ModSoundEvents.ARMADILLO_BRUSH.get());
        return true;
    }

    public boolean canStayRolledUp() {
        return !MobUtils.isPanicking((PathfinderMob)this) && !this.m_20072_() && !this.m_20077_() && !this.m_21523_() && !this.m_20159_() && !this.m_20160_();
    }

    public boolean m_5957_() {
        return super.m_5957_() && !this.isScared();
    }

    public SoundEvent m_7866_(ItemStack stack) {
        return ModSoundEvents.ARMADILLO_EAT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isScared() ? null : ModSoundEvents.ARMADILLO_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return ModSoundEvents.ARMADILLO_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return this.isScared() ? ModSoundEvents.ARMADILLO_HURT_REDUCED.get() : ModSoundEvents.ARMADILLO_HURT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(ModSoundEvents.ARMADILLO_STEP.get(), 0.15f, 1.0f);
    }

    public int m_8085_() {
        return this.isScared() ? 0 : 32;
    }

    protected BodyRotationControl m_7560_() {
        return new BodyRotationControl((Mob)this){

            public void m_8121_() {
                if (!Armadillo.this.isScared()) {
                    super.m_8121_();
                }
            }
        };
    }

    public void stopInPlace() {
        this.m_21573_().m_26573_();
        this.m_21570_(0.0f);
        this.m_21567_(0.0f);
        this.m_7910_(0.0f);
    }

    private boolean dropFromGiftLootTable(ServerLevel level, ResourceLocation key, BiConsumer<ServerLevel, ItemStack> consumer) {
        return this.dropFromLootTable(level, key, builder -> builder.m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81416_), consumer);
    }

    private boolean dropFromLootTable(ServerLevel level, ResourceLocation key, Function<LootParams.Builder, LootParams> function, BiConsumer<ServerLevel, ItemStack> consumer) {
        LootParams lootParams;
        LootTable lootTable = level.m_7654_().m_278653_().m_278676_(key);
        ObjectArrayList list = lootTable.m_287195_(lootParams = function.apply(new LootParams.Builder(level)));
        if (!list.isEmpty()) {
            list.forEach(stack -> consumer.accept(level, (ItemStack)stack));
            return true;
        }
        return false;
    }

    public float m_20236_(Pose pose) {
        return 0.26f;
    }
}

