/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.sound;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class AmbientDesertBlockSoundsPlayer {
    private static final int IDLE_SOUND_CHANCE = 2100;
    private static final int DRY_GRASS_SOUND_CHANCE = 200;
    private static final int DEAD_BUSH_SOUND_CHANCE = 130;
    private static final int DEAD_BUSH_SOUND_BADLANDS_DECREASED_CHANCE = 3;
    private static final int SURROUNDING_BLOCKS_PLAY_SOUND_THRESHOLD = 3;
    private static final int SURROUNDING_BLOCKS_DISTANCE_HORIZONTAL_CHECK = 8;
    private static final int SURROUNDING_BLOCKS_DISTANCE_VERTICAL_CHECK = 5;
    private static final int HORIZONTAL_DIRECTIONS = 4;

    public static void playAmbientSandSounds(Level level, BlockPos pos, RandomSource random) {
        if (level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50016_) && random.m_188503_(2100) == 0 && AmbientDesertBlockSoundsPlayer.shouldPlayAmbientSandSound(level, pos)) {
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ModSoundEvents.SAND_IDLE.get(), SoundSource.AMBIENT, 1.0f, 1.0f, false);
        }
    }

    public static void playAmbientDryGrassSounds(Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(200) == 0 && AmbientDesertBlockSoundsPlayer.shouldPlayDesertDryVegetationBlockSounds(level, pos.m_7495_())) {
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ModSoundEvents.DRY_GRASS.get(), SoundSource.AMBIENT, 1.0f, 1.0f, false);
        }
    }

    public static void playAmbientDeadBushSounds(Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(130) == 0) {
            BlockState state = level.m_8055_(pos.m_7495_());
            if ((state.m_60713_(Blocks.f_49993_) || state.m_204336_(BlockTags.f_198156_)) && random.m_188503_(3) != 0) {
                return;
            }
            if (AmbientDesertBlockSoundsPlayer.shouldPlayDesertDryVegetationBlockSounds(level, pos.m_7495_())) {
                level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ModSoundEvents.DEAD_BUSH_IDLE.get(), SoundSource.AMBIENT, 1.0f, 1.0f, false);
            }
        }
    }

    public static boolean shouldPlayDesertDryVegetationBlockSounds(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(ModBlockTags.TRIGGERS_AMBIENT_DESERT_DRY_VEGETATION_BLOCK_SOUNDS) && level.m_8055_(pos.m_7495_()).m_204336_(ModBlockTags.TRIGGERS_AMBIENT_DESERT_DRY_VEGETATION_BLOCK_SOUNDS);
    }

    private static boolean shouldPlayAmbientSandSound(Level level, BlockPos pos) {
        int found = 0;
        int checked = 0;
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int remaining;
            int possible;
            mutable.m_122190_((Vec3i)pos).m_122175_(direction, 8);
            if (AmbientDesertBlockSoundsPlayer.columnContainsTriggeringBlock(level, mutable) && found++ >= 3) {
                return true;
            }
            if ((possible = (remaining = 4 - ++checked) + found) >= 3) continue;
            return false;
        }
        return false;
    }

    private static boolean columnContainsTriggeringBlock(Level level, BlockPos.MutableBlockPos mutable) {
        int surfaceY = level.m_6924_(Heightmap.Types.WORLD_SURFACE, mutable.m_123341_(), mutable.m_123343_()) - 1;
        if (Math.abs(surfaceY - mutable.m_123342_()) > 5) {
            mutable.m_122175_(Direction.UP, 6);
            BlockState state = level.m_8055_((BlockPos)mutable);
            mutable.m_122173_(Direction.DOWN);
            for (int i = 0; i < 10; ++i) {
                BlockState localState = level.m_8055_((BlockPos)mutable);
                if (state.m_60795_() && AmbientDesertBlockSoundsPlayer.canTriggerAmbientDesertSandSounds(localState)) {
                    return true;
                }
                state = localState;
                mutable.m_122173_(Direction.DOWN);
            }
            return false;
        }
        boolean hasAirAbove = level.m_8055_((BlockPos)mutable.m_142448_(surfaceY + 1)).m_60795_();
        return hasAirAbove && AmbientDesertBlockSoundsPlayer.canTriggerAmbientDesertSandSounds(level.m_8055_((BlockPos)mutable.m_142448_(surfaceY)));
    }

    private static boolean canTriggerAmbientDesertSandSounds(BlockState state) {
        return state.m_204336_(ModBlockTags.TRIGGERS_AMBIENT_DESERT_SAND_BLOCK_SOUNDS);
    }
}

