/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.entities.variant;

import com.blackgear.vanillabackport.client.level.entities.model.chicken.ColdChickenModel;
import com.blackgear.vanillabackport.client.registries.ModModelLayers;
import com.blackgear.vanillabackport.common.api.variant.VariantHolder;
import com.blackgear.vanillabackport.common.level.entities.animal.ChickenVariant;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChickenVariantRenderer {
    protected final Map<ChickenVariant.ModelType, ChickenModel<Chicken>> modelByVariant;

    public ChickenVariantRenderer(EntityRendererProvider.Context context) {
        this.modelByVariant = this.bakeModels(context);
    }

    public Map<ChickenVariant.ModelType, ChickenModel<Chicken>> bakeModels(EntityRendererProvider.Context context) {
        EnumMap map = Maps.newEnumMap(ChickenVariant.ModelType.class);
        map.put(ChickenVariant.ModelType.NORMAL, null);
        map.put(ChickenVariant.ModelType.COLD, new ColdChickenModel(context.m_174023_(ModModelLayers.COLD_CHICKEN)));
        return map;
    }

    public ResourceLocation getTexture(Chicken entity) {
        ChickenVariant variant = (ChickenVariant)VariantHolder.vb$getVariantHolder((LivingEntity)entity).vb$getVariant();
        return variant != null ? variant.modelAndTexture().asset().path() : null;
    }

    public Optional<ChickenModel<Chicken>> getModel(Chicken entity) {
        ChickenVariant variant = (ChickenVariant)VariantHolder.vb$getVariantHolder((LivingEntity)entity).vb$getVariant();
        return variant != null ? Optional.ofNullable(this.modelByVariant.get((Object)variant.modelAndTexture().model())) : Optional.empty();
    }
}

