/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.entities.layer;

import com.blackgear.vanillabackport.client.registries.ModModelLayers;
import com.blackgear.vanillabackport.common.level.entities.wolf.ModCrackiness;
import com.blackgear.vanillabackport.common.level.items.WolfArmorItem;
import com.blackgear.vanillabackport.common.registries.ModItems;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WolfArmorLayer
extends RenderLayer<Wolf, WolfModel<Wolf>> {
    private final WolfModel<Wolf> model;
    private static final Map<ModCrackiness.Level, ResourceLocation> ARMOR_CRACK_LOCATIONS = Map.of(ModCrackiness.Level.LOW, VanillaBackport.vanilla("textures/entity/wolf/wolf_armor_crackiness_low.png"), ModCrackiness.Level.MEDIUM, VanillaBackport.vanilla("textures/entity/wolf/wolf_armor_crackiness_medium.png"), ModCrackiness.Level.HIGH, VanillaBackport.vanilla("textures/entity/wolf/wolf_armor_crackiness_high.png"));

    public WolfArmorLayer(RenderLayerParent<Wolf, WolfModel<Wolf>> renderer, EntityModelSet models) {
        super(renderer);
        this.model = new WolfModel(models.m_171103_(ModModelLayers.WOLF_ARMOR));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Wolf wolf, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack;
        Item item;
        if (wolf.m_6844_(EquipmentSlot.CHEST).m_150930_(ModItems.WOLF_ARMOR.get()) && (item = (stack = wolf.m_6844_(EquipmentSlot.CHEST)).m_41720_()) instanceof WolfArmorItem) {
            WolfArmorItem armor = (WolfArmorItem)item;
            ((WolfModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6839_(wolf, limbSwing, limbSwingAmount, partialTick);
            this.model.m_6973_(wolf, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer vertices = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)armor.getTexture()));
            this.model.m_7695_(poseStack, vertices, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            this.maybeRenderColoredLayer(poseStack, buffer, packedLight, stack, armor);
            this.maybeRenderCracks(poseStack, buffer, packedLight, stack);
        }
    }

    private void maybeRenderColoredLayer(PoseStack poseStack, MultiBufferSource buffer, int packedLight, ItemStack stack, WolfArmorItem armor) {
        ResourceLocation overlay = armor.getOverlayTexture();
        if (overlay == null) {
            return;
        }
        int color = WolfArmorItem.getColorOrDefault(stack, 0);
        if (color == 10511680) {
            return;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        VertexConsumer vertices = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)overlay));
        this.model.m_7695_(poseStack, vertices, packedLight, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }

    private void maybeRenderCracks(PoseStack poseStack, MultiBufferSource buffer, int packedLight, ItemStack stack) {
        ModCrackiness.Level level = ModCrackiness.WOLF_ARMOR.byDamage(stack);
        if (level != ModCrackiness.Level.NONE) {
            ResourceLocation texture = ARMOR_CRACK_LOCATIONS.get((Object)level);
            VertexConsumer vertices = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
            this.model.m_7695_(poseStack, vertices, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static MeshDefinition createMeshDefinition(CubeDeformation grow) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)13.5f, (float)-7.0f));
        head.m_171599_("real_head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, grow).m_171514_(16, 14).m_171488_(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, grow).m_171514_(16, 14).m_171488_(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, grow).m_171514_(0, 10).m_171488_(-0.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, grow), PartPose.f_171404_);
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(18, 14).m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, grow), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        root.m_171599_("upper_body", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, grow), PartPose.m_171423_((float)-1.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder legShape = CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, grow);
        root.m_171599_("right_hind_leg", legShape, PartPose.m_171419_((float)-2.5f, (float)16.0f, (float)7.0f));
        root.m_171599_("left_hind_leg", legShape, PartPose.m_171419_((float)0.5f, (float)16.0f, (float)7.0f));
        root.m_171599_("right_front_leg", legShape, PartPose.m_171419_((float)-2.5f, (float)16.0f, (float)-4.0f));
        root.m_171599_("left_front_leg", legShape, PartPose.m_171419_((float)0.5f, (float)16.0f, (float)-4.0f));
        PartDefinition tail = root.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        tail.m_171599_("real_tail", CubeListBuilder.m_171558_().m_171514_(9, 18).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, grow), PartPose.f_171404_);
        return mesh;
    }
}

