/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.entity.ai.CaniacMeleeGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.LicowitchEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.PossessedByLicowitch;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CaniacEntity
extends Monster
implements IAnimatedEntity,
PossessedByLicowitch {
    private static final EntityDataAccessor<Float> SPIN_SPEED = SynchedEntityData.m_135353_(CaniacEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> RUNNING = SynchedEntityData.m_135353_(CaniacEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> POSSESSOR_LICOWITCH_ID = SynchedEntityData.m_135353_(CaniacEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float prevLeftArmRot;
    private float leftArmRot;
    private float prevRightArmRot;
    private float rightArmRot;
    private boolean spinSecondArm = false;
    public static final Animation ANIMATION_LUNGE = Animation.create((int)35);
    private Animation currentAnimation;
    private int animationTick;
    private boolean hasRunningAttributes = false;
    private float runProgress;
    private float prevRunProgress;
    private int swingSoundTimer = 0;

    public CaniacEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPIN_SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RUNNING, (Object)false);
        this.f_19804_.m_135372_(POSSESSOR_LICOWITCH_ID, (Object)-1);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 38.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    public static boolean checkCaniacSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return CaniacEntity.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource) && randomSource.m_188503_(10) == 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 10.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(1, (Goal)new CaniacMeleeGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 45));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevLeftArmRot = this.leftArmRot;
        this.prevRightArmRot = this.rightArmRot;
        this.prevRunProgress = this.runProgress;
        float armSpinSpeed = this.getArmSpinSpeed();
        if (armSpinSpeed > 0.0f && this.m_6084_()) {
            if (this.swingSoundTimer-- < 0) {
                this.swingSoundTimer = 5 + this.m_9236_().f_46441_.m_188503_(10);
                this.m_216990_((SoundEvent)ACSoundRegistry.CANIAC_SWING.get());
            }
            if (this.m_21526_()) {
                this.leftArmRot += armSpinSpeed;
                if (this.leftArmRot % 360.0f > 180.0f) {
                    this.spinSecondArm = true;
                }
                if (this.spinSecondArm) {
                    this.rightArmRot += armSpinSpeed;
                }
            } else {
                this.rightArmRot += armSpinSpeed;
                if (this.rightArmRot % 360.0f > 180.0f) {
                    this.spinSecondArm = true;
                }
                if (this.spinSecondArm) {
                    this.leftArmRot += armSpinSpeed;
                }
            }
            if (this.m_9236_().f_46443_) {
                if (Mth.m_14177_((float)this.leftArmRot) % 180.0f > 70.0f) {
                    this.spawnArmSwingParticles(true);
                }
                if (Mth.m_14177_((float)this.rightArmRot) % 180.0f > 70.0f) {
                    this.spawnArmSwingParticles(false);
                }
            } else {
                if (Mth.m_14177_((float)this.leftArmRot) % 180.0f > 75.0f) {
                    this.hurtMobsFromArmSwing(true, (float)this.m_21051_(Attributes.f_22281_).m_22135_(), 0.1f);
                }
                if (Mth.m_14177_((float)this.rightArmRot) % 180.0f > 75.0f) {
                    this.hurtMobsFromArmSwing(false, (float)this.m_21051_(Attributes.f_22281_).m_22135_(), 0.1f);
                }
            }
        } else {
            float f;
            this.spinSecondArm = false;
            float f2 = f = this.getAnimation() == ANIMATION_LUNGE ? 40.0f : 15.0f;
            if (Mth.m_14177_((float)this.leftArmRot) != 0.0f) {
                this.leftArmRot = Mth.m_14148_((float)this.leftArmRot, (float)0.0f, (float)f);
            }
            if (Mth.m_14177_((float)this.rightArmRot) != 0.0f) {
                this.rightArmRot = Mth.m_14148_((float)this.rightArmRot, (float)0.0f, (float)f);
            }
        }
        if (this.isRunning() && !this.hasRunningAttributes) {
            this.hasRunningAttributes = true;
            this.m_21051_(Attributes.f_22279_).m_22100_(0.4);
        }
        if (!this.isRunning() && this.hasRunningAttributes) {
            this.hasRunningAttributes = false;
            this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
        }
        if (this.isRunning() && this.runProgress < 5.0f) {
            this.runProgress += 1.0f;
        }
        if (!this.isRunning() && this.runProgress > 0.0f) {
            this.runProgress -= 1.0f;
        }
        if (this.m_9236_().f_46443_) {
            this.spawnPossessedParticles(this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), this.m_9236_());
        }
        if (this.getAnimation() == ANIMATION_LUNGE && this.getAnimationTick() == 10) {
            this.m_216990_((SoundEvent)ACSoundRegistry.CANIAC_ATTACK.get());
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_LUNGE};
    }

    public float getArmSpinSpeed() {
        return ((Float)this.f_19804_.m_135370_(SPIN_SPEED)).floatValue();
    }

    public void setArmSpinSpeed(float spinSpeed) {
        this.f_19804_.m_135381_(SPIN_SPEED, (Object)Float.valueOf(spinSpeed));
    }

    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(RUNNING);
    }

    public void setRunning(boolean running) {
        this.f_19804_.m_135381_(RUNNING, (Object)running);
    }

    private void spawnArmSwingParticles(boolean left) {
        Vec3 dustMotion = new Vec3(0.0, (double)0.2f, (double)(this.f_19796_.m_188501_() * 0.5f - 0.25f)).m_82490_((double)this.m_6134_()).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        Vec3 armDustPosition = this.m_20182_().m_82549_(new Vec3(left ? 0.75 : -0.75, 1.0, (double)(this.f_19796_.m_188501_() * -0.5f + 0.5f)).m_82490_((double)this.m_6134_()).m_82524_(-this.f_20883_ * ((float)Math.PI / 180)));
        BlockPos ground = BlockPos.m_274446_((Position)ACMath.getGroundBelowPosition((BlockGetter)this.m_9236_(), armDustPosition)).m_7495_();
        BlockState state = this.m_9236_().m_8055_(ground);
        if (state.m_280296_()) {
            this.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), true, armDustPosition.f_82479_, (double)(ground.m_123342_() + 1), armDustPosition.f_82481_, dustMotion.f_82479_, dustMotion.f_82480_, dustMotion.f_82481_);
        }
    }

    private void hurtMobsFromArmSwing(boolean left, float damageAmount, float knockbackAmount) {
        boolean strong;
        boolean bl = strong = this.f_19796_.m_188501_() < 0.1f;
        if (strong) {
            damageAmount *= 1.5f;
            knockbackAmount = 1.0f;
        }
        Vec3 armHurtPosition = this.m_20182_().m_82549_(new Vec3(left ? 0.75 : -0.75, 1.0, 1.25).m_82490_((double)this.m_6134_()).m_82524_(-this.f_20883_ * ((float)Math.PI / 180)));
        AABB hurtBox = new AABB(armHurtPosition.f_82479_ - 1.0, armHurtPosition.f_82480_ - 1.0, armHurtPosition.f_82481_ - 1.0, armHurtPosition.f_82479_ + 1.0, armHurtPosition.f_82480_ + 1.0, armHurtPosition.f_82481_ + 1.0);
        DamageSource damageSource = this.m_269291_().m_269333_((LivingEntity)this);
        for (LivingEntity living : this.m_9236_().m_6443_(LivingEntity.class, hurtBox, EntitySelector.f_20406_)) {
            LicowitchEntity witch;
            if (living.m_7306_((Entity)this) || living.m_7307_((Entity)this) || living.m_6095_() == this.m_6095_()) continue;
            if (this.getPossessedByLicowitchId() != -1 && (witch = this.getPossessingLicowitch(this.m_9236_())) != null && witch.isFriendlyFire(living)) {
                return;
            }
            if (!(living.m_20270_((Entity)this) < 3.15f) || !living.m_6469_(damageSource, damageAmount)) continue;
            living.m_147240_((double)knockbackAmount, this.m_20185_() - living.m_20185_(), this.m_20189_() - living.m_20189_());
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.CANIAC_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.CANIAC_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.CANIAC_DEATH.get();
    }

    @Override
    public void setPossessedByLicowitchId(int entityId) {
        this.f_19804_.m_135381_(POSSESSOR_LICOWITCH_ID, (Object)entityId);
    }

    @Override
    public int getPossessedByLicowitchId() {
        return (Integer)this.f_19804_.m_135370_(POSSESSOR_LICOWITCH_ID);
    }

    protected boolean m_6125_() {
        return super.m_6125_() && this.getPossessedByLicowitchId() == -1;
    }

    public boolean m_6779_(LivingEntity living) {
        LicowitchEntity licowitch;
        if (this.getPossessedByLicowitchId() != -1 && (licowitch = this.getPossessingLicowitch(this.m_9236_())) != null && licowitch.isFriendlyFire(living)) {
            return false;
        }
        return super.m_6779_(living);
    }

    public float getArmAngle(boolean left, float partialTicks) {
        if (left) {
            return this.prevLeftArmRot + (this.leftArmRot - this.prevLeftArmRot) * partialTicks;
        }
        return this.prevRightArmRot + (this.rightArmRot - this.prevRightArmRot) * partialTicks;
    }

    public float getRunProgress(float partialTick) {
        return (this.prevRunProgress + (this.runProgress - this.prevRunProgress) * partialTick) * 0.2f;
    }

    public float getStepHeight() {
        return this.hasRunningAttributes ? 1.1f : 0.6f;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != MobEffects.f_19612_;
    }
}

