/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.UnderzealotEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;

public class UnderzealotMeleeGoal
extends Goal {
    private UnderzealotEntity entity;
    private boolean shouldBurrow = false;

    public UnderzealotMeleeGoal(UnderzealotEntity entity) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.entity = entity;
    }

    public boolean m_8036_() {
        return this.entity.m_5448_() != null && this.entity.m_5448_().m_6084_();
    }

    public void m_8037_() {
        LivingEntity target = this.entity.m_5448_();
        if (target != null) {
            double dist = this.entity.m_20270_((Entity)target);
            float f = this.entity.m_20205_() + target.m_20205_();
            if (this.shouldBurrow && this.entity.m_20096_()) {
                this.shouldBurrow = false;
                this.entity.setBuried(true);
                this.entity.reemergeAt(this.entity.findReemergePos(target.m_20183_(), 15), 20 + this.entity.m_217043_().m_188503_(60));
            } else if (!this.entity.isBuried()) {
                if (this.entity.isDiggingInProgress()) {
                    this.entity.m_21573_().m_26573_();
                } else {
                    this.entity.m_21573_().m_5624_((Entity)target, 1.3);
                    if (dist < (double)(f + 1.0f)) {
                        this.tryAnimation(this.entity.m_217043_().m_188499_() ? UnderzealotEntity.ANIMATION_ATTACK_0 : UnderzealotEntity.ANIMATION_ATTACK_1);
                    }
                    if ((this.entity.getAnimation() == UnderzealotEntity.ANIMATION_ATTACK_0 || this.entity.getAnimation() == UnderzealotEntity.ANIMATION_ATTACK_1) && this.entity.getAnimationTick() == 8) {
                        this.checkAndDealDamage(target, 1.0f);
                    }
                }
            }
        }
    }

    private void checkAndDealDamage(LivingEntity target, float multiplier) {
        if (this.entity.m_142582_((Entity)target) && (double)this.entity.m_20270_((Entity)target) < (double)(this.entity.m_20205_() + target.m_20205_()) + 1.0) {
            float f = (float)this.entity.m_21051_(Attributes.f_22281_).m_22135_() * multiplier;
            target.m_6469_(target.m_269291_().m_269333_((LivingEntity)this.entity), f);
            target.m_147240_(0.2 + 0.3 * (double)multiplier, this.entity.m_20185_() - target.m_20185_(), this.entity.m_20189_() - target.m_20189_());
            this.shouldBurrow = this.entity.m_9236_().f_46441_.m_188499_();
            Entity vehicle = target.m_20202_();
            if (vehicle != null) {
                vehicle.m_20256_(target.m_20184_());
                vehicle.m_6469_(target.m_269291_().m_269333_((LivingEntity)this.entity), f * 0.5f);
            }
        }
    }

    public void m_8041_() {
        this.shouldBurrow = false;
    }

    private boolean tryAnimation(Animation animation) {
        if (this.entity.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.entity.setAnimation(animation);
            this.entity.m_216990_((SoundEvent)ACSoundRegistry.UNDERZEALOT_ATTACK.get());
            return true;
        }
        return false;
    }
}

