/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.SpinningPeppermintEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.SugarStaffHexEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.LicowitchEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.PossessedByLicowitch;
import com.github.alexmodguy.alexscaves.server.message.WorldEventMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LicowitchAttackGoal
extends Goal {
    private final LicowitchEntity licowitch;
    private int peppermintCooldown = 0;
    private int hexCooldown = 0;
    private int potionCooldown = 0;
    private int enqueuedAttackType;
    private int checkReachCooldown = 0;
    private int duration = 0;

    public LicowitchAttackGoal(LicowitchEntity licowitch) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.licowitch = licowitch;
    }

    public boolean m_8036_() {
        LivingEntity target = this.licowitch.m_5448_();
        return target != null && target.m_6084_();
    }

    public void m_8041_() {
        this.licowitch.updateFoldedArms = true;
        this.licowitch.updateHeldItems = true;
        this.peppermintCooldown = 0;
        this.hexCooldown = 0;
        this.potionCooldown = 0;
        this.checkReachCooldown = 0;
        this.duration = 0;
    }

    public void m_8037_() {
        if (this.peppermintCooldown > 0) {
            --this.peppermintCooldown;
        }
        if (this.hexCooldown > 0) {
            --this.hexCooldown;
        }
        if (this.potionCooldown > 0) {
            --this.potionCooldown;
        }
        if (this.checkReachCooldown > 0) {
            --this.checkReachCooldown;
        }
        LivingEntity target = this.licowitch.m_5448_();
        if (this.duration > 200 && this.checkReachCooldown == 0 && target != null) {
            this.checkReachCooldown = 100 + this.licowitch.m_217043_().m_188503_(40);
            if (this.licowitch.canTeleport() && !this.licowitch.canReach(target.m_20183_())) {
                this.licowitch.setTeleportingToPos(Vec3.m_82539_((Vec3i)target.m_20183_()));
                return;
            }
        }
        if (target != null && target.m_6084_() && this.licowitch.getTeleportingToPos() == null) {
            double distance = this.licowitch.m_20270_((Entity)target);
            double distanceXZ = Mth.m_14116_((float)((float)this.licowitch.m_20275_(target.m_20185_(), this.licowitch.m_20186_(), target.m_20189_())));
            double attackDistance = this.licowitch.m_20205_() + target.m_20205_() + 5.0f;
            this.licowitch.m_21391_((Entity)target, 30.0f, 30.0f);
            if (this.licowitch.getAnimation() == LicowitchEntity.ANIMATION_EAT || this.enqueuedAttackType == 0 && distance < attackDistance - 1.0 || this.licowitch.getAnimation() == LicowitchEntity.ANIMATION_SPELL_1 && distanceXZ < 6.0) {
                this.licowitch.m_21566_().m_24988_(-4.0f, 0.0f);
                this.licowitch.m_21573_().m_26573_();
            } else if (distance > attackDistance || !this.licowitch.m_142582_((Entity)target)) {
                this.licowitch.m_21573_().m_5624_((Entity)target, 1.0);
            }
            if (this.licowitch.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                if (this.enqueuedAttackType == 0) {
                    if (this.licowitch.m_142582_((Entity)target)) {
                        if (this.peppermintCooldown <= 0 && this.licowitch.m_217043_().m_188499_()) {
                            this.enqueuedAttackType = 1;
                            this.peppermintCooldown = 80;
                        } else if (this.hexCooldown <= 0 && this.licowitch.m_217043_().m_188499_()) {
                            this.enqueuedAttackType = 2;
                            this.hexCooldown = 200;
                        } else if (this.potionCooldown <= 0 && distance < 10.0 && !target.m_21023_(MobEffects.f_19612_)) {
                            this.enqueuedAttackType = 3;
                            this.licowitch.updateHeldItems = false;
                            this.licowitch.m_21008_(InteractionHand.MAIN_HAND, LicowitchEntity.hungerPotion.m_41777_());
                            this.potionCooldown = 100;
                        }
                    }
                } else {
                    if (this.enqueuedAttackType == 1 && distance < 10.0) {
                        this.licowitch.setAnimation(LicowitchEntity.ANIMATION_SPELL_0);
                    }
                    if ((this.enqueuedAttackType == 2 || this.enqueuedAttackType == 4) && distance < 7.0) {
                        this.licowitch.setAnimation(LicowitchEntity.ANIMATION_SPELL_1);
                    }
                    if (this.enqueuedAttackType == 3 && distance < 10.0) {
                        this.licowitch.setAnimation(this.licowitch.m_5737_() == HumanoidArm.RIGHT ? LicowitchEntity.ANIMATION_SWING_RIGHT : LicowitchEntity.ANIMATION_SWING_LEFT);
                    }
                }
            }
            if (this.enqueuedAttackType == 1 && this.licowitch.getAnimation() == LicowitchEntity.ANIMATION_SPELL_0 && this.licowitch.getAnimationTick() == 18) {
                this.peppermintAttack(target);
                this.enqueuedAttackType = 0;
            }
            if (this.enqueuedAttackType == 2 && this.licowitch.getAnimation() == LicowitchEntity.ANIMATION_SPELL_1 && this.licowitch.getAnimationTick() == 36) {
                this.hexAttack(target);
                this.enqueuedAttackType = 0;
            }
            if (this.enqueuedAttackType == 3 && (this.licowitch.getAnimation() == LicowitchEntity.ANIMATION_SWING_RIGHT || this.licowitch.getAnimation() == LicowitchEntity.ANIMATION_SWING_LEFT) && this.licowitch.getAnimationTick() == 6) {
                this.potionAttack(target);
                this.licowitch.updateHeldItems = true;
                this.enqueuedAttackType = 0;
            }
        }
        ++this.duration;
    }

    private void potionAttack(LivingEntity target) {
        Vec3 vec3 = target.m_20184_();
        double d0 = target.m_20185_() + vec3.f_82479_ - this.licowitch.m_20185_();
        double d1 = target.m_20188_() - (double)1.1f - this.licowitch.m_20186_();
        double d2 = target.m_20189_() + vec3.f_82481_ - this.licowitch.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        ThrownPotion thrownpotion = new ThrownPotion(this.licowitch.m_9236_(), (LivingEntity)this.licowitch);
        thrownpotion.m_37446_(LicowitchEntity.hungerPotion);
        thrownpotion.m_146926_(thrownpotion.m_146909_() - -20.0f);
        thrownpotion.m_6686_(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
        if (!this.licowitch.m_20067_()) {
            this.licowitch.m_9236_().m_6263_(null, this.licowitch.m_20185_(), this.licowitch.m_20186_(), this.licowitch.m_20189_(), SoundEvents.f_12553_, this.licowitch.m_5720_(), 1.0f, 0.8f + this.licowitch.m_217043_().m_188501_() * 0.4f);
        }
        this.licowitch.m_9236_().m_7967_((Entity)thrownpotion);
    }

    private void hexAttack(LivingEntity target) {
        Vec3 summonSpot;
        this.licowitch.m_21391_((Entity)target, 180.0f, 30.0f);
        boolean summonSpace = this.licowitch.getPossessedUUIDs().size() < 3;
        boolean flag = false;
        if (summonSpace && this.licowitch.m_217043_().m_188499_() && (summonSpot = this.findSummonSpot(target, 10)) != null) {
            Mob summoned = this.licowitch.createRandomPossessedMob();
            Level level = this.licowitch.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                summoned.m_6518_((ServerLevelAccessor)serverLevel, this.licowitch.m_9236_().m_6436_(BlockPos.m_274446_((Position)summonSpot)), MobSpawnType.MOB_SUMMONED, null, null);
            }
            if (summoned instanceof PossessedByLicowitch) {
                PossessedByLicowitch possessed = (PossessedByLicowitch)summoned;
                possessed.setPossessedByLicowitch(this.licowitch);
            }
            summoned.m_146884_(summonSpot);
            this.licowitch.m_9236_().m_7967_((Entity)summoned);
            this.licowitch.addPossessedUUID(summoned.m_20148_());
            AlexsCaves.sendMSGToAll(new WorldEventMessage(7, (int)summonSpot.f_82479_, (int)summonSpot.f_82480_, (int)summonSpot.f_82481_));
            flag = true;
            this.licowitch.m_9236_().m_5594_((Player)null, this.licowitch.m_20183_(), (SoundEvent)ACSoundRegistry.LICOWITCH_CAST_SUMMON.get(), SoundSource.HOSTILE, 0.3f, 0.9f + this.licowitch.m_9236_().f_46441_.m_188501_() * 0.2f);
        }
        if (!flag) {
            Vec3 ground = ACMath.getGroundBelowPosition((BlockGetter)this.licowitch.m_9236_(), this.licowitch.m_146892_());
            Vec3 groundThere = ACMath.getGroundBelowPosition((BlockGetter)target.m_9236_(), target.m_146892_());
            SugarStaffHexEntity sugarStaffHexEntity = (SugarStaffHexEntity)((EntityType)ACEntityRegistry.SUGAR_STAFF_HEX.get()).m_20615_(this.licowitch.m_9236_());
            sugarStaffHexEntity.setOwner((LivingEntity)this.licowitch);
            sugarStaffHexEntity.m_6034_(ground.f_82479_, groundThere.f_82480_, ground.f_82481_);
            Vec3 delta = groundThere.m_82546_(ground);
            sugarStaffHexEntity.m_20256_(delta.m_82542_(0.25, 0.0, 0.25));
            this.licowitch.m_9236_().m_7967_((Entity)sugarStaffHexEntity);
            this.licowitch.m_9236_().m_5594_((Player)null, this.licowitch.m_20183_(), (SoundEvent)ACSoundRegistry.LICOWITCH_CAST_HEX.get(), SoundSource.HOSTILE, 0.3f, 0.9f + this.licowitch.m_9236_().f_46441_.m_188501_() * 0.2f);
        }
    }

    private Vec3 findSummonSpot(LivingEntity target, int range) {
        for (int i = 0; i < 15; ++i) {
            Vec3 heightAdjusted = target.m_20182_().m_82520_((double)(target.m_217043_().m_188503_(range * 2) - range), (double)(target.m_20192_() + (float)target.m_217043_().m_188503_(4)), (double)(target.m_217043_().m_188503_(range * 2) - range));
            Vec3 ground = ACMath.getGroundBelowPosition((BlockGetter)target.m_9236_(), heightAdjusted);
            BlockHitResult result = target.m_9236_().m_45547_(new ClipContext(target.m_146892_(), ground.m_82520_(0.0, 1.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)target));
            if (result.m_6662_() != HitResult.Type.MISS) continue;
            return ground;
        }
        return null;
    }

    private void peppermintAttack(LivingEntity target) {
        boolean spinning = this.licowitch.m_217043_().m_188499_();
        int spawnIn = 3;
        Vec3 subtract = target.m_20182_().m_82546_(this.licowitch.m_20182_());
        float f = -((float)Mth.m_14136_((double)subtract.f_82479_, (double)subtract.f_82481_)) * 180.0f / (float)Math.PI;
        for (int i = 0; i < spawnIn; ++i) {
            SpinningPeppermintEntity spinningPeppermintEntity = (SpinningPeppermintEntity)((EntityType)ACEntityRegistry.SPINNING_PEPPERMINT.get()).m_20615_(this.licowitch.m_9236_());
            spinningPeppermintEntity.m_146884_(this.licowitch.getStaffPosition());
            spinningPeppermintEntity.setStraight(!spinning);
            spinningPeppermintEntity.m_146922_(180.0f + f + (float)((i - 1) * 30));
            spinningPeppermintEntity.setSpinSpeed(spinning ? 12.0f : 8.0f);
            spinningPeppermintEntity.setSpinRadius(3.5f);
            spinningPeppermintEntity.setOwner((LivingEntity)this.licowitch);
            spinningPeppermintEntity.setStartAngle((float)(i * 360) / (float)spawnIn);
            this.licowitch.m_9236_().m_7967_((Entity)spinningPeppermintEntity);
        }
        this.licowitch.m_9236_().m_5594_((Player)null, this.licowitch.m_20183_(), (SoundEvent)ACSoundRegistry.LICOWITCH_CAST_PEPPERMINT.get(), SoundSource.HOSTILE, 0.3f, 0.9f + this.licowitch.m_9236_().f_46441_.m_188501_() * 0.2f);
    }
}

