/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.GeothermalVentBlockEntity;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class GeothermalVentBlock
extends BaseEntityBlock {
    public static final IntegerProperty SMOKE_TYPE = IntegerProperty.m_61631_((String)"smoke_type", (int)0, (int)3);
    public static final BooleanProperty SPAWNING_PARTICLES = BooleanProperty.m_61465_((String)"spawning_particles");

    public GeothermalVentBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60913_(2.0f, 5.0f).m_60918_(SoundType.f_154659_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SMOKE_TYPE, (Comparable)Integer.valueOf(0))).m_61124_((Property)SPAWNING_PARTICLES, (Comparable)Boolean.valueOf(true)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelaccessor = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)SMOKE_TYPE, (Comparable)Integer.valueOf(this.getSmokeType((LevelAccessor)levelaccessor, blockpos)))).m_61124_((Property)SPAWNING_PARTICLES, (Comparable)Boolean.valueOf(this.isSpawningParticles(blockpos, (LevelAccessor)levelaccessor)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        return (BlockState)((BlockState)state.m_61124_((Property)SMOKE_TYPE, (Comparable)Integer.valueOf(this.getSmokeType(levelAccessor, blockPos)))).m_61124_((Property)SPAWNING_PARTICLES, (Comparable)Boolean.valueOf(this.isSpawningParticles(blockPos, levelAccessor)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SMOKE_TYPE, SPAWNING_PARTICLES});
    }

    public int getSmokeType(LevelAccessor level, BlockPos blockpos) {
        BlockState state = level.m_8055_(blockpos.m_7495_());
        if (state.m_60734_() instanceof GeothermalVentBlock) {
            return (Integer)state.m_61143_((Property)SMOKE_TYPE);
        }
        if (state.m_60819_().getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get()) {
            return 3;
        }
        if (state.m_60819_().m_205070_(FluidTags.f_13131_)) {
            return 1;
        }
        if (state.m_60819_().m_205070_(FluidTags.f_13132_)) {
            return 2;
        }
        return 0;
    }

    public boolean isSpawningParticles(BlockPos pos, LevelAccessor level) {
        BlockState above = level.m_8055_(pos.m_7494_());
        return above.m_60795_() || !above.m_280555_();
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource randomSource) {
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_150930_(Items.f_42590_) && (Integer)blockState.m_61143_((Property)SMOKE_TYPE) == 3 && ((Boolean)blockState.m_61143_((Property)SPAWNING_PARTICLES)).booleanValue()) {
            ItemStack bottle = new ItemStack((ItemLike)ACItemRegistry.RADON_BOTTLE.get());
            if (!player.m_36356_(bottle)) {
                player.m_36176_(bottle, false);
            }
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
            }
            player.m_216990_(SoundEvents.f_11770_);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(blockState, level, blockPos, player, hand, result);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        if (level.f_46443_) {
            return (Integer)state.m_61143_((Property)SMOKE_TYPE) > 0 && (Boolean)state.m_61143_((Property)SPAWNING_PARTICLES) != false ? GeothermalVentBlock.m_152132_(entityType, (BlockEntityType)((BlockEntityType)ACBlockEntityRegistry.GEOTHERMAL_VENT.get()), GeothermalVentBlockEntity::particleTick) : null;
        }
        return null;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GeothermalVentBlockEntity(pos, state);
    }
}

