/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.DarkArrowModel;
import com.github.alexmodguy.alexscaves.server.entity.item.DarkArrowEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.ForgeRenderTypes;

public class DarkArrowRenderer
extends EntityRenderer<DarkArrowEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/dark_arrow.png");
    private static final DarkArrowModel MODEL = new DarkArrowModel();

    public DarkArrowRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(DarkArrowEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int lighting) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_())));
        poseStack.m_252781_(Axis.f_252495_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_())));
        poseStack.m_85837_(0.0, 1.5, -0.15);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        float f9 = (float)entity.f_36706_ - partialTicks;
        if (f9 > 0.0f) {
            float f10 = -Mth.m_14031_((float)(f9 * 3.0f)) * f9;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(f10));
        }
        float ageInTicks = (float)entity.f_19797_ + partialTicks;
        float invFade = 1.0f - entity.getFadeOut(ageInTicks - (float)entity.f_19797_);
        float alpha = Math.min(ageInTicks / 4.0f, 1.0f) * invFade;
        RenderType renderType = ForgeRenderTypes.getUnlitTranslucent((ResourceLocation)this.getTextureLocation(entity));
        VertexConsumer vertexconsumer = bufferSource.m_6299_(renderType);
        MODEL.setupAnim(entity, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f);
        MODEL.m_7695_(poseStack, vertexconsumer, 240, OverlayTexture.f_118083_, entity.getArrowRed(partialTicks), 0.0f, 0.0f, alpha);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferSource, lighting);
    }

    public ResourceLocation getTextureLocation(DarkArrowEntity entity) {
        return TEXTURE;
    }
}

