/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.model.CandyCaneHookModel;
import com.github.alexmodguy.alexscaves.server.entity.item.CandyCaneHookEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GumWormSegmentEntity;
import com.github.alexmodguy.alexscaves.server.item.CandyCaneHookItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class CandyCaneHookRenderer
extends EntityRenderer<CandyCaneHookEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/candy_cane_hook.png");
    private static final CandyCaneHookModel MODEL = new CandyCaneHookModel();
    private static final float LICORICE_COLOR_1_R = 0.3137255f;
    private static final float LICORICE_COLOR_1_G = 0.0f;
    private static final float LICORICE_COLOR_1_B = 0.40784314f;
    private static final float LICORICE_COLOR_2_R = 0.13333334f;
    private static final float LICORICE_COLOR_2_G = 0.0f;
    private static final float LICORICE_COLOR_2_B = 0.1764706f;

    public CandyCaneHookRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRender(CandyCaneHookEntity entity, Frustum camera, double x, double y, double z) {
        if (super.m_5523_((Entity)entity, camera, x, y, z)) {
            return true;
        }
        Entity owner = entity.m_19749_();
        if (owner != null) {
            Vec3 vec31 = entity.m_20318_(1.0f);
            Vec3 vec32 = owner.m_20318_(1.0f);
            return camera.m_113029_(new AABB(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec32.f_82479_, vec32.f_82480_, vec32.f_82481_));
        }
        return false;
    }

    public void render(CandyCaneHookEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int lighting) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_())));
        poseStack.m_252781_(Axis.f_252495_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_())));
        poseStack.m_85837_(0.0, 1.5, -0.15);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        float ageInTicks = (float)entity.f_19797_ + partialTicks;
        RenderType renderType = RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity));
        VertexConsumer vertexconsumer = bufferSource.m_6299_(renderType);
        MODEL.setupAnim(entity, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f);
        MODEL.m_7695_(poseStack, vertexconsumer, lighting, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        Player player = entity.getPlayerOwner();
        if (player != null) {
            float f3;
            double d6;
            double d5;
            double d4;
            poseStack.m_85836_();
            int i = 0;
            if (entity.getHandLaunchedFrom() == InteractionHand.MAIN_HAND) {
                i = player.m_5737_() == HumanoidArm.RIGHT ? 1 : -1;
            } else if (entity.getHandLaunchedFrom() == InteractionHand.OFF_HAND) {
                i = player.m_5737_() == HumanoidArm.LEFT ? 1 : -1;
            }
            float f = player.m_21324_(partialTicks);
            float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)f) * (float)Math.PI));
            float f2 = Mth.m_14179_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_) * ((float)Math.PI / 180);
            boolean wormRiding = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof CandyCaneHookItem && CandyCaneHookItem.isActive(player.m_21120_(InteractionHand.MAIN_HAND)) && player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof CandyCaneHookItem && CandyCaneHookItem.isActive(player.m_21120_(InteractionHand.OFF_HAND)) && player.m_20202_() instanceof GumWormSegmentEntity;
            float rightWiggle = -Math.min(player.f_20900_, 0.0f) * (float)Math.sin((float)player.f_19797_ + AlexsCaves.PROXY.getPartialTicks());
            float leftWiggle = Math.max(player.f_20900_, 0.0f) * (float)Math.sin((float)player.f_19797_ + AlexsCaves.PROXY.getPartialTicks());
            float wiggle = i == 1 ? rightWiggle : (i == -1 ? leftWiggle : 0.0f);
            double d0 = Mth.m_14031_((float)f2);
            double d1 = Mth.m_14089_((float)f2);
            double d2 = (double)i * (wormRiding ? 0.45 : 0.35);
            double d3 = 0.8;
            if ((this.f_114476_.f_114360_ == null || this.f_114476_.f_114360_.m_92176_().m_90612_()) && player == Minecraft.m_91087_().f_91074_) {
                double d7 = 960.0 / (double)((Integer)this.f_114476_.f_114360_.m_231837_().m_231551_()).intValue();
                Vec3 vec3 = this.f_114476_.f_114358_.m_167684_().m_167695_((float)i * 0.7f, -0.5f);
                vec3 = vec3.m_82490_(d7);
                vec3 = vec3.m_82524_(f1 * 0.5f);
                vec3 = vec3.m_82496_(-f1 * 0.7f);
                d4 = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) + vec3.f_82479_;
                d5 = Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_()) + vec3.f_82480_;
                d6 = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) + vec3.f_82481_;
                f3 = player.m_20192_();
            } else {
                double yDown = wormRiding ? -0.2 + 0.15 * (double)wiggle : 0.55;
                d4 = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - d1 * d2 - d0 * 0.45;
                d5 = player.f_19855_ + (double)player.m_20192_() + (player.m_20186_() - player.f_19855_) * (double)partialTicks - yDown;
                d6 = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - d0 * d2 + d1 * 0.45;
                f3 = player.m_6047_() ? -0.1875f : 0.0f;
            }
            double d9 = Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_());
            double d10 = Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_()) + 0.25;
            double d8 = Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_());
            float f4 = (float)(d4 - d9);
            float f5 = (float)(d5 - d10) + f3;
            float f6 = (float)(d6 - d8);
            Vec3 rotationalVec = new Vec3(0.0, (double)0.15f, (double)-0.45f).m_82496_((float)Math.toRadians(Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_()))).m_82524_((float)Math.toRadians(Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_())));
            this.renderLicoriceString(entity, new Vec3((double)f4, (double)f5, (double)f6), poseStack, bufferSource, rotationalVec);
            poseStack.m_85849_();
        }
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferSource, lighting);
    }

    public void renderLicoriceString(CandyCaneHookEntity from, Vec3 fromVec, PoseStack poseStack, MultiBufferSource bufferSource, Vec3 to) {
        poseStack.m_85836_();
        double d3 = fromVec.f_82479_;
        double d4 = fromVec.f_82480_;
        double d5 = fromVec.f_82481_;
        poseStack.m_85837_(d3, d4, d5);
        float f = (float)(to.f_82479_ - d3);
        float f1 = (float)(to.f_82480_ - d4);
        float f2 = (float)(to.f_82481_ - d5);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        BlockPos blockpos = BlockPos.m_274446_((Position)fromVec);
        BlockPos blockpos1 = BlockPos.m_274446_((Position)to);
        int i = from.m_9236_().m_45517_(LightLayer.BLOCK, blockpos);
        int j = from.m_9236_().m_45517_(LightLayer.BLOCK, blockpos1);
        int k = from.m_9236_().m_45517_(LightLayer.SKY, blockpos);
        int l = from.m_9236_().m_45517_(LightLayer.SKY, blockpos1);
        for (int i1 = 0; i1 <= 32; ++i1) {
            float width = 0.07f - (float)i1 / 32.0f * 0.035f;
            CandyCaneHookRenderer.addLicoriceStringVertexPair(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, 0.2f, width, width, width, i1);
        }
        poseStack.m_85849_();
    }

    private static void addLicoriceStringVertexPair(VertexConsumer vertexConsumer, Matrix4f matrix4f, float x, float y, float z, int blockLightFrom, int blockLightTo, int skyLightFrom, int skyLightTo, float height, float yWidth, float xWidth, float zWidth, int vertIndex) {
        float f = (float)vertIndex / 32.0f;
        int i = (int)Mth.m_14179_((float)f, (float)blockLightFrom, (float)blockLightTo);
        int j = (int)Mth.m_14179_((float)f, (float)skyLightFrom, (float)skyLightTo);
        int k = LightTexture.m_109885_((int)i, (int)j);
        boolean colorScheme = vertIndex % 2 == 0;
        float f2 = colorScheme ? 0.3137255f : 0.13333334f;
        float f3 = colorScheme ? 0.0f : 0.0f;
        float f4 = colorScheme ? 0.40784314f : 0.1764706f;
        float f5 = x * f;
        float f6 = y < 0.0f ? y * f * f : y - y * (1.0f - f) * (1.0f - f);
        float f7 = z * f;
        vertexConsumer.m_252986_(matrix4f, f5 - xWidth, f6 + yWidth, f7 + zWidth).m_85950_(f2, f3, f4, 1.0f).m_85969_(k).m_5752_();
        vertexConsumer.m_252986_(matrix4f, f5 + xWidth, f6 + height - yWidth, f7 - zWidth).m_85950_(f2, f3, f4, 1.0f).m_85969_(k).m_5752_();
    }

    public ResourceLocation getTextureLocation(CandyCaneHookEntity entity) {
        return TEXTURE;
    }
}

