/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.mixin;

import com.teamabnormals.environmental.core.registry.EnvironmentalBiomes;
import com.teamabnormals.environmental.core.registry.EnvironmentalNoiseParameters;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BlockColumn;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SurfaceSystem.class})
public abstract class SurfaceSystemMixin {
    private NormalNoise pineBarrensStoneNoise;
    private int[][][] pineBarrensStoneRaises;
    private boolean raisePineBarrensStone;
    @Shadow
    @Final
    private BlockState f_189904_;
    @Shadow
    @Final
    private NormalNoise f_189918_;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void SurfaceSystem(RandomState randomState, BlockState defaultBlock, int seaLevel, PositionalRandomFactory noiseRandom, CallbackInfo ci) {
        this.pineBarrensStoneNoise = randomState.m_224560_(EnvironmentalNoiseParameters.PINE_BARRENS_STONE);
        this.pineBarrensStoneRaises = new int[16][16][3];
    }

    @Inject(method={"buildSurface"}, at={@At(value="HEAD")})
    private void buildSurface(RandomState randomState, BiomeManager biomeManager, Registry<Biome> registry, boolean useLegacyRandomSource, WorldGenerationContext context, ChunkAccess chunkAccess, NoiseChunk noiseChunk, SurfaceRules.RuleSource ruleSource, CallbackInfo ci) {
        this.raisePineBarrensStone = false;
    }

    @Inject(method={"buildSurface"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/BiomeManager;getBiome(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/Holder;", shift=At.Shift.BEFORE, ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void collectRaises(RandomState randomState, BiomeManager biomeManager, Registry<Biome> registry, boolean useLegacyRandomSource, WorldGenerationContext context, ChunkAccess chunkAccess, NoiseChunk noiseChunk, SurfaceRules.RuleSource ruleSource, CallbackInfo ci, BlockPos.MutableBlockPos mutable, ChunkPos chunkPos, int i, int j, BlockColumn blockColumn, SurfaceRules.Context surfaceRulesContext, SurfaceRules.SurfaceRule surfaceRule, BlockPos.MutableBlockPos mutable1, int k, int l, int i1, int j1) {
        int y = chunkAccess.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, k, l) + 1;
        Holder biome = biomeManager.m_204214_((BlockPos)mutable1.m_122178_(i1, y - 1, j1));
        if (biome.m_203565_(EnvironmentalBiomes.PINE_BARRENS) || biome.m_203565_(EnvironmentalBiomes.SNOWY_PINE_BARRENS) || biome.m_203565_(EnvironmentalBiomes.OLD_GROWTH_PINE_BARRENS) || biome.m_203565_(EnvironmentalBiomes.SNOWY_OLD_GROWTH_PINE_BARRENS)) {
            double noise = this.getNoiseAt(i1, j1);
            boolean flag = noise > 0.0;
            this.pineBarrensStoneRaises[k][l] = new int[]{y, y + SurfaceSystemMixin.getRaise(noise), flag ? 1 : 0};
            if (flag) {
                this.raisePineBarrensStone = true;
            }
        } else {
            this.pineBarrensStoneRaises[k][l] = null;
        }
    }

    @Inject(method={"buildSurface"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void generateRaisedStone(RandomState randomState, BiomeManager biomeManager, Registry<Biome> registry, boolean useLegacyRandomSource, WorldGenerationContext context, ChunkAccess chunkAccess, NoiseChunk noiseChunk, SurfaceRules.RuleSource ruleSource, CallbackInfo ci, BlockPos.MutableBlockPos mutable, ChunkPos chunkPos, int i, int j, BlockColumn blockColumn) {
        if (this.raisePineBarrensStone) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int[] raise = this.pineBarrensStoneRaises[x][z];
                    if (raise == null || raise[2] == 0) continue;
                    int y = raise[0];
                    int y1 = raise[1];
                    int m = 0;
                    mutable.m_142451_(x + i).m_142443_(z + j);
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        int x1 = x + direction.m_122429_();
                        int z1 = z + direction.m_122431_();
                        if (x1 < 0 || x1 >= 16 || z1 < 0 || z1 >= 16) continue;
                        int[] raise1 = this.pineBarrensStoneRaises[x1][z1];
                        if (raise1 == null) {
                            m = 0;
                            --y1;
                            break;
                        }
                        if (raise1[1] > y1) {
                            ++m;
                            continue;
                        }
                        if (raise1[1] >= y1) continue;
                        --m;
                    }
                    if (m >= 3) {
                        ++y1;
                    } else if (m <= -3) {
                        --y1;
                    }
                    for (int n = y; n < y1; ++n) {
                        blockColumn.m_183639_(n, Blocks.f_50069_.m_49966_());
                    }
                }
            }
        }
    }

    private double getNoiseAt(int x, int y) {
        double d0 = this.f_189918_.m_75380_((double)x, 0.0, (double)y);
        double d1 = this.pineBarrensStoneNoise.m_75380_((double)x, 0.0, (double)y);
        double d2 = Math.max(d0 - 0.36363636363636365, 0.0);
        double d3 = d1 < 0.0 ? Math.max(-d1 - 0.15151515151515152, 0.0) : Math.max(d1 - 0.15151515151515152, 0.0);
        return Math.min(d2, d3);
    }

    private static int getRaise(double noise) {
        return noise < 0.06060606060606061 ? 0 : (noise < 0.2181818181818182 ? 1 : 2);
    }
}

