/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.mixin;

import com.teamabnormals.environmental.common.entity.animal.MuddyPig;
import com.teamabnormals.environmental.common.entity.animal.Tapir;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MudBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.class})
public class BlockBehaviourMixin {
    @Inject(method={"entityInside"}, at={@At(value="HEAD")})
    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, CallbackInfo ci) {
        BlockBehaviour block = (BlockBehaviour)this;
        if (block instanceof MudBlock && entity instanceof Pig) {
            Pig pig = (Pig)entity;
            if (MuddyPig.enabled()) {
                MuddyPig.setMuddy(pig, true);
                MuddyPig.updateDryingTime(pig, 20);
            }
        }
        if (block instanceof LeavesBlock && entity instanceof Tapir) {
            entity.m_183634_();
            Vec3 vec3 = entity.m_20184_();
            entity.m_20334_(vec3.f_82479_ * 0.8, Math.max(vec3.f_82480_, -0.08), vec3.f_82481_ * 0.8);
        }
    }

    @Inject(method={"getCollisionShape"}, at={@At(value="RETURN")}, cancellable=true)
    public void getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        EntityCollisionContext entityContext;
        BlockBehaviour block = (BlockBehaviour)this;
        if (block instanceof LeavesBlock && context instanceof EntityCollisionContext && (entityContext = (EntityCollisionContext)context).m_193113_() instanceof Tapir) {
            cir.setReturnValue((Object)Shapes.m_83040_());
        }
    }
}

