/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.zebroid;

import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidPanicGoal;
import com.teamabnormals.environmental.common.entity.animal.zebroid.AbstractUnchestedZebroid;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.UUID;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;

public class Zorse
extends AbstractUnchestedZebroid
implements VariantHolder<Variant> {
    public static final float MIN_DAMAGE = Zorse.generateAttackDamage(value -> 0);
    public static final float MAX_DAMAGE = Zorse.generateAttackDamage(value -> value - 1);
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("6CEF6F73-493A-491E-B49C-BA4B2F8ABEB6");
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Zorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STRIPE_OPACITY = SynchedEntityData.m_135353_(Zorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Zorse(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_7509_() {
        this.f_21345_.m_25352_(2, new ZebroidPanicGoal<Zorse>(this, 1.8));
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractHorse.m_30627_().m_22266_(Attributes.f_22281_).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 8.0);
    }

    protected void m_214179_(RandomSource random) {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)Zorse.m_271722_(arg_0 -> ((RandomSource)random).m_188503_(arg_0)));
        this.m_21051_(Attributes.f_22279_).m_22100_(Zorse.m_271981_(() -> ((RandomSource)random).m_188500_()));
        this.m_21051_(Attributes.f_22288_).m_22100_(Zorse.m_272017_(() -> ((RandomSource)random).m_188500_()));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)Zorse.generateAttackDamage(arg_0 -> ((RandomSource)random).m_188503_(arg_0)));
    }

    private static float generateAttackDamage(IntUnaryOperator random) {
        return 1.0f + (float)random.applyAsInt(2);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(STRIPE_OPACITY, (Object)100);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getTypeVariant());
        compound.m_128405_("StripeOpacity", this.getStripeOpacity());
        if (!this.f_30520_.m_8020_(1).m_41619_()) {
            compound.m_128365_("ArmorItem", (Tag)this.f_30520_.m_8020_(1).m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        ItemStack itemstack;
        super.m_7378_(compound);
        this.setTypeVariant(compound.m_128451_("Variant"));
        this.setStripeOpacity(compound.m_128451_("StripeOpacity"));
        if (compound.m_128425_("ArmorItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("ArmorItem"))).m_41619_() && this.m_6010_(itemstack)) {
            this.f_30520_.m_6836_(1, itemstack);
        }
        this.m_7493_();
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    private void setArmor(ItemStack stack) {
        this.m_8061_(EquipmentSlot.CHEST, stack);
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    private void setTypeVariant(int p_30737_) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)p_30737_);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void setVariantAndMarkings(Variant variant, Markings markings) {
        this.setTypeVariant(variant.m_30985_() & 0xFF | markings.m_30869_() << 8 & 0xFF00);
    }

    public Variant getVariant() {
        return Variant.m_30986_((int)(this.getTypeVariant() & 0xFF));
    }

    public void setVariant(Variant variant) {
        this.setTypeVariant(variant.m_30985_() & 0xFF | this.getTypeVariant() & 0xFFFFFF00);
    }

    public Markings getMarkings() {
        return Markings.m_30870_((int)((this.getTypeVariant() & 0xFF00) >> 8));
    }

    public int getStripeOpacity() {
        return (Integer)this.f_19804_.m_135370_(STRIPE_OPACITY);
    }

    public void setStripeOpacity(int time) {
        this.f_19804_.m_135381_(STRIPE_OPACITY, (Object)time);
    }

    public void randomizeStripeOpacity(RandomSource random) {
        this.setStripeOpacity(33 + random.m_188503_(68));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)EnvironmentalSoundEvents.ZORSE_AMBIENT.get();
    }

    protected SoundEvent m_7871_() {
        return (SoundEvent)EnvironmentalSoundEvents.ZORSE_ANGRY.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)EnvironmentalSoundEvents.ZORSE_DEATH.get();
    }

    protected SoundEvent m_7872_() {
        return (SoundEvent)EnvironmentalSoundEvents.ZORSE_EAT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        if (!this.isKicking()) {
            super.m_7975_(source);
        }
        return (SoundEvent)EnvironmentalSoundEvents.ZORSE_HURT.get();
    }

    protected void m_5877_(SoundType soundType) {
        super.m_5877_(soundType);
        ItemStack stack = this.f_30520_.m_8020_(1);
        if (this.m_6010_(stack)) {
            stack.onHorseArmorTick(this.m_9236_(), (Mob)this);
        }
    }

    protected void m_7493_() {
        if (!this.m_9236_().f_46443_) {
            super.m_7493_();
            this.setArmorEquipment(this.f_30520_.m_8020_(1));
            this.m_21409_(EquipmentSlot.CHEST, 0.0f);
        }
    }

    private void setArmorEquipment(ItemStack stack) {
        this.setArmor(stack);
        if (!this.m_9236_().f_46443_) {
            int i;
            this.m_21051_(Attributes.f_22284_).m_22120_(ARMOR_MODIFIER_UUID);
            if (this.m_6010_(stack) && (i = ((HorseArmorItem)stack.m_41720_()).m_41368_()) != 0) {
                this.m_21051_(Attributes.f_22284_).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Horse armor bonus", (double)i, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public void m_5757_(Container container) {
        ItemStack itemstack = this.getArmor();
        super.m_5757_(container);
        ItemStack itemstack1 = this.getArmor();
        if (this.f_19797_ > 20 && this.m_6010_(itemstack1) && itemstack != itemstack1) {
            this.m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
        }
    }

    public boolean m_7482_() {
        return true;
    }

    public boolean m_6010_(ItemStack stack) {
        return stack.m_150930_(Items.f_42654_);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        RandomSource random = level.m_213780_();
        this.setVariantAndMarkings((Variant)Util.m_214670_((Object[])Variant.values(), (RandomSource)random), (Markings)Util.m_214670_((Object[])Markings.values(), (RandomSource)random));
        this.randomizeStripeOpacity(level.m_213780_());
        return super.m_6518_(level, difficulty, spawnType, groupData, tag);
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        Zorse zorse = (Zorse)otherParent;
        Zorse zorse1 = (Zorse)((EntityType)EnvironmentalEntityTypes.ZORSE.get()).m_20615_((Level)level);
        if (zorse1 != null) {
            int i = this.f_19796_.m_188503_(9);
            Variant variant = i < 4 ? this.getVariant() : (i < 8 ? zorse.getVariant() : (Variant)Util.m_214670_((Object[])Variant.values(), (RandomSource)this.f_19796_));
            int j = this.f_19796_.m_188503_(5);
            Markings markings = j < 2 ? this.getMarkings() : (j < 4 ? zorse.getMarkings() : (Markings)Util.m_214670_((Object[])Markings.values(), (RandomSource)this.f_19796_));
            zorse1.randomizeStripeOpacity(level.m_213780_());
            zorse1.setVariantAndMarkings(variant, markings);
            this.m_149508_(otherParent, zorse1);
        }
        return zorse1;
    }

    public void m_149508_(AgeableMob otherParent, AbstractHorse child) {
        super.m_149508_(otherParent, child);
        this.m_272015_(otherParent, child, Attributes.f_22281_, MIN_DAMAGE, MAX_DAMAGE);
    }

    public double m_6048_() {
        return super.m_6048_() - 0.1;
    }
}

