/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.zebroid;

import com.teamabnormals.environmental.common.network.message.C2SZebraJumpMessage;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.EnvironmentalDamageTypes;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalEntityTypeTags;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public interface Zebroid {
    public static final UUID SPEED_MODIFIER_KICKING_ID = UUID.fromString("AF33F716-0F4D-43CA-9C8E-1068AE2F38E6");
    public static final AttributeModifier SPEED_MODIFIER_KICKING = new AttributeModifier(SPEED_MODIFIER_KICKING_ID, "Kicking speed reduction", -0.8, AttributeModifier.Operation.MULTIPLY_BASE);
    public static final Predicate<LivingEntity> KICKABLE_PREDICATE = living -> living.m_6084_() && !living.m_6095_().m_204039_(EnvironmentalEntityTypeTags.ZEBROIDS_DONT_KICK) && EntitySelector.f_20406_.test(living) && !living.m_20159_();

    public void setKickTime(int var1);

    public int getKickTime();

    default public boolean isKicking() {
        return this.getKickTime() > 0;
    }

    public boolean canJumpKick();

    public void setJumpStrength(float var1);

    public float getJumpStrength();

    public boolean isFleeing();

    public void playKickingSound();

    public void playAngrySound();

    public void setGallopSoundCounter(int var1);

    public int getGallopSoundCounter();

    public boolean canGallop();

    public void playZebroidGallopSound(SoundType var1);

    public void setKickCounter(int var1);

    public int getKickCounter();

    public void setBackKickAnim(float var1);

    public float getBackKickAnim();

    public void setBackKickAnimO(float var1);

    public float getBackKickAnimO();

    public void setFrontKickAnim(float var1);

    public float getFrontKickAnim();

    public void setFrontKickAnimO(float var1);

    public float getFrontKickAnimO();

    default public float getBackKickAnim(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.getBackKickAnimO(), (float)this.getBackKickAnim());
    }

    default public float getFrontKickAnim(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.getFrontKickAnimO(), (float)this.getFrontKickAnim());
    }

    default public float getBackKickBodyRot(float partialTick) {
        float anim = this.getBackKickAnim(partialTick);
        return anim < 5.0f ? Zebroid.smoothAnim(0.0f, 5.0f, anim) : (anim < 6.0f ? 1.0f : Zebroid.smoothAnim(10.0f, 6.0f, anim));
    }

    default public float getBackKickLegRot(float partialTick) {
        float anim = this.getBackKickAnim(partialTick);
        return anim < 5.0f ? Zebroid.smoothAnim(0.0f, 5.0f, anim) : (anim < 8.0f ? Zebroid.smoothAnim(8.0f, 5.0f, anim) : 0.0f);
    }

    default public float getFrontKickBodyRot(float partialTick) {
        float anim = this.getFrontKickAnim(partialTick);
        return anim < 6.0f ? Zebroid.smoothAnim(0.0f, 6.0f, anim) : (anim < 8.0f ? 1.0f : Zebroid.smoothAnim(12.0f, 8.0f, anim));
    }

    default public float getFrontKickLegRot(float partialTick) {
        float anim = this.getFrontKickAnim(partialTick);
        return anim < 6.0f ? Zebroid.smoothAnim(0.0f, 6.0f, anim) : (anim < 7.0f ? 1.0f : (anim < 10.0f ? Zebroid.smoothAnim(10.0f, 7.0f, anim) : 0.0f));
    }

    default public void playBackKickAnim() {
        this.setBackKickAnim(10.0f);
        this.setFrontKickAnim(0.0f);
        this.setBackKickAnimO(10.0f);
        this.setFrontKickAnimO(0.0f);
    }

    default public void playFrontKickAnim() {
        this.setBackKickAnim(0.0f);
        this.setFrontKickAnim(12.0f);
        this.setBackKickAnimO(0.0f);
        this.setFrontKickAnimO(12.0f);
    }

    default public void handleTick() {
        AbstractHorse horse = (AbstractHorse)this;
        if (horse.m_20096_() || horse.isInFluidType()) {
            this.setJumpStrength(-1.0f);
        }
        if (horse.m_21515_() && horse.m_6084_()) {
            boolean resetkickcounter = true;
            if (!horse.m_6162_() && !this.isKicking()) {
                boolean isfleeing;
                LivingEntity rider = horse.m_6688_();
                boolean jumpkick = this.canJumpKick();
                boolean bl = isfleeing = this.isFleeing() && !horse.m_6107_() && !horse.m_21573_().m_26571_();
                if (!horse.m_30622_() || jumpkick) {
                    List nearby = horse.m_9236_().m_6443_(LivingEntity.class, horse.m_20191_().m_82400_((double)0.9f), KICKABLE_PREDICATE);
                    boolean shouldkick = false;
                    boolean backkick = true;
                    for (LivingEntity living : nearby) {
                        Vec3 attackAngleVector = living.m_20182_().m_82546_(horse.m_20182_()).m_82541_();
                        attackAngleVector = new Vec3(attackAngleVector.f_82479_, 0.0, attackAngleVector.f_82481_);
                        double angle = attackAngleVector.m_82526_(Vec3.m_82498_((float)0.0f, (float)horse.m_213816_()).m_82541_());
                        if (angle > 0.7) {
                            if (!isfleeing && !jumpkick && (rider == null || !(rider.f_20902_ > 0.0f))) continue;
                            shouldkick = true;
                            backkick = false;
                            break;
                        }
                        if (!(angle < -0.7) || jumpkick) continue;
                        if (isfleeing) {
                            shouldkick = true;
                            continue;
                        }
                        if (rider == null) {
                            if (!living.m_20163_()) {
                                this.setKickCounter(this.getKickCounter() - 1);
                                if (this.getKickCounter() <= 0) {
                                    shouldkick = true;
                                }
                            }
                            if (shouldkick) continue;
                            resetkickcounter = false;
                            continue;
                        }
                        if (!(rider.f_20902_ <= 0.0f)) continue;
                        shouldkick = true;
                    }
                    if (shouldkick) {
                        this.kick(backkick, rider == null && !isfleeing);
                        this.playKickingSound();
                    }
                }
            } else {
                this.setKickTime(this.getKickTime() + 1);
                if (this.getKickTime() > 10) {
                    this.setKickTime(0);
                    horse.m_21051_(Attributes.f_22279_).m_22130_(SPEED_MODIFIER_KICKING);
                }
            }
            if (resetkickcounter) {
                this.setKickCounter(20);
            }
        }
        float f = this.getBackKickAnim();
        this.setBackKickAnimO(f);
        if (f > 0.0f) {
            this.setBackKickAnim(f - 1.0f);
        }
        float f1 = this.getFrontKickAnim();
        this.setFrontKickAnimO(f1);
        if (f1 > 0.0f) {
            this.setFrontKickAnim(f1 - 1.0f);
        }
    }

    default public void kick(boolean backKick) {
        this.kick(backKick, false);
    }

    default public void kick(boolean backKick, boolean softBackKick) {
        AbstractHorse horse = (AbstractHorse)this;
        this.setKickTime(1);
        horse.m_30661_(false);
        AttributeInstance attributeinstance = horse.m_21051_(Attributes.f_22279_);
        if (!attributeinstance.m_22109_(SPEED_MODIFIER_KICKING)) {
            attributeinstance.m_22118_(SPEED_MODIFIER_KICKING);
        }
        if (!backKick) {
            this.playFrontKickAnim();
            horse.m_9236_().m_7605_((Entity)horse, (byte)8);
        } else {
            this.playBackKickAnim();
            horse.m_9236_().m_7605_((Entity)horse, (byte)9);
        }
        List nearby = horse.m_9236_().m_6443_(LivingEntity.class, horse.m_20191_().m_82400_(1.0), KICKABLE_PREDICATE);
        for (LivingEntity living : nearby) {
            boolean flag;
            Vec3 attackAngleVector = living.m_20182_().m_82546_(horse.m_20182_()).m_82541_();
            attackAngleVector = new Vec3(attackAngleVector.f_82479_, 0.0, attackAngleVector.f_82481_);
            float rot = horse.m_213816_();
            float x = Mth.m_14031_((float)(rot * ((float)Math.PI / 180)));
            float z = -Mth.m_14089_((float)(rot * ((float)Math.PI / 180)));
            double angle = attackAngleVector.m_82526_(Vec3.m_82498_((float)0.0f, (float)rot).m_82541_());
            boolean jumpkick = this.canJumpKick();
            if (!(!backKick && angle > 0.7) && (!backKick || !(angle < -0.7))) continue;
            LivingEntity rider = horse.m_6688_();
            DamageSource source = rider != null ? EnvironmentalDamageTypes.ridingZebra(horse.m_9236_(), (Entity)horse, (Entity)rider) : horse.m_269291_().m_269333_((LivingEntity)horse);
            float damage = (float)horse.m_21133_(Attributes.f_22281_);
            float knockback = (float)horse.m_21133_(Attributes.f_22282_);
            if (jumpkick) {
                float f = this.getJumpStrength();
                if (rider != null && rider.f_20902_ <= 0.0f) {
                    f *= 0.5f;
                }
                damage += f * 6.0f;
                knockback = knockback * 0.8f + f * 1.1f;
            } else if (backKick) {
                if (!softBackKick) {
                    damage += 2.0f;
                } else if (damage > 1.0f) {
                    damage = 1.0f;
                }
                knockback *= 1.2f;
            } else {
                knockback *= 0.8f;
            }
            if (!(flag = living.m_6469_(source, (float)((int)damage)))) continue;
            horse.m_19970_((LivingEntity)horse, (Entity)living);
            if (!backKick) {
                living.m_147240_((double)knockback, (double)x, (double)z);
                continue;
            }
            living.m_147240_((double)knockback, (double)(-x), (double)(-z));
        }
    }

    default public void flingPassengers(boolean backFling) {
        AbstractHorse horse = (AbstractHorse)this;
        float rot = horse.m_213816_();
        float x = Mth.m_14031_((float)(rot * ((float)Math.PI / 180)));
        float z = -Mth.m_14089_((float)(rot * ((float)Math.PI / 180)));
        for (int i = horse.m_20197_().size() - 1; i >= 0; --i) {
            Entity passenger = (Entity)horse.m_20197_().get(i);
            passenger.m_8127_();
            Vec3 vec3 = new Vec3((double)x, 0.0, (double)z).m_82490_((double)0.8f);
            if (backFling) {
                vec3 = vec3.m_82490_(-1.0);
            }
            passenger.m_5997_(vec3.f_82479_, 0.8, vec3.f_82481_);
            passenger.f_19864_ = true;
        }
    }

    default public void handleTravel(boolean wasJumping) {
        AbstractHorse horse = (AbstractHorse)this;
        if (!wasJumping && horse.m_30616_() && horse.m_6688_() instanceof Player) {
            Environmental.CHANNEL.sendToServer((Object)new C2SZebraJumpMessage((float)horse.m_20184_().f_82480_));
        }
    }

    default public void handleLeashed(Entity entity) {
        AbstractHorse horse = (AbstractHorse)this;
        if (!horse.m_30614_() && entity instanceof LivingEntity) {
            horse.m_6710_((LivingEntity)entity);
        }
    }

    default public boolean canDoIdleAnimation() {
        AbstractHorse horse = (AbstractHorse)this;
        return !this.isKicking() && horse.m_21566_().m_24999_() <= 1.0;
    }

    default public void handleStepSound(BlockPos pos, BlockState state) {
        AbstractHorse horse = (AbstractHorse)this;
        if (!state.m_278721_()) {
            BlockState blockstate = horse.m_9236_().m_8055_(pos.m_7494_());
            SoundType soundtype = state.getSoundType((LevelReader)horse.m_9236_(), pos, (Entity)horse);
            if (blockstate.m_60713_(Blocks.f_50125_)) {
                soundtype = blockstate.getSoundType((LevelReader)horse.m_9236_(), pos, (Entity)horse);
            }
            if ((horse.m_20160_() || horse.m_21566_().m_24999_() > 1.6) && this.canGallop()) {
                this.setGallopSoundCounter(this.getGallopSoundCounter() + 1);
                if (this.getGallopSoundCounter() > 5 && this.getGallopSoundCounter() % 3 == 0) {
                    this.playZebroidGallopSound(soundtype);
                } else if (this.getGallopSoundCounter() <= 5) {
                    horse.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
                }
            } else if (soundtype == SoundType.f_56736_) {
                horse.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            } else {
                horse.m_5496_(SoundEvents.f_12035_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        }
    }

    default public void handlePositionRider(Entity rider, Entity.MoveFunction function) {
        AbstractHorse horse = (AbstractHorse)this;
        float f = Mth.m_14031_((float)(horse.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14089_((float)(horse.f_20883_ * ((float)Math.PI / 180)));
        float f2 = 0.0f;
        float f3 = 0.0f;
        float nostandanim = 1.0f - horse.f_30514_;
        if (horse.f_30514_ > 0.0f) {
            f2 += 0.7f * horse.f_30514_;
            f3 += 0.15f * horse.f_30514_;
            if (rider instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)rider;
                living.f_20883_ = horse.f_20883_;
            }
        }
        if (this.getBackKickAnimO() > 0.0f) {
            float rot = this.getBackKickBodyRot(0.0f);
            f2 += -0.2f * rot * nostandanim;
            f3 += 0.15f * rot * nostandanim;
        } else if (this.getFrontKickAnimO() > 0.0f) {
            float rot = this.getFrontKickBodyRot(0.0f);
            f2 += 0.2f * rot * nostandanim;
            f3 += 0.15f * rot * nostandanim;
        }
        function.m_20372_(rider, horse.m_20185_() + (double)(f2 * f), horse.m_20186_() + horse.m_6048_() + rider.m_6049_() + (double)f3, horse.m_20189_() - (double)(f2 * f1));
    }

    public static float smoothAnim(float min, float max, float progress) {
        return 1.0f - Mth.m_14207_((float)((progress - max) / (max - min)));
    }
}

