/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.yak;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.environmental.common.entity.ai.brain.yak.YakGrazeBehavior;
import com.teamabnormals.environmental.common.entity.ai.brain.yak.YakHerdingBehavior;
import com.teamabnormals.environmental.common.entity.ai.brain.yak.YakMoveToRestrictionBehavior;
import com.teamabnormals.environmental.common.entity.ai.brain.yak.YakPrepareRamBehavior;
import com.teamabnormals.environmental.common.entity.ai.brain.yak.YakRamBehavior;
import com.teamabnormals.environmental.common.entity.animal.yak.Yak;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalMemoryModuleTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSensorTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.GameRules;

public class Yaktelligence {
    public static final int RAM_PREPARE_TIME = 10;
    public static final float RAM_KNOCKBACK_FORCE = 2.5f;
    private static final UniformInt TIME_BETWEEN_RAMS = UniformInt.m_146622_((int)20, (int)200);
    private static final int MELEE_ATTACK_COOLDOWN = 20;
    public static final int HERD_RADIUS = 10;
    public static final int HERD_SEARCH_RADIUS = 12;
    public static final int HERD_CHECK_GUARANTEE = 400;
    public static final int HERD_MEMORY_EXPIRATION = 1200;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_HERDING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 1.1f;
    private static final float SPEED_MULTIPLIER_WHEN_AVOIDING = 1.1f;
    private static final float SPEED_MULTIPLIER_WHEN_TEMPTED = 1.1f;
    private static final float SPEED_MULTIPLIER_WHEN_RAMMING = 2.0f;
    private static final float SPEED_MULTIPLIER_WHEN_FIGHTING = 1.1f;
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.m_146622_((int)5, (int)16);
    private static final ImmutableList<SensorType<? extends Sensor<? super Yak>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26822_, (Object)SensorType.f_26814_, (Object)((SensorType)EnvironmentalSensorTypes.YAK_TEMPTATIONS.get()), (Object)((SensorType)EnvironmentalSensorTypes.NEAREST_VISIBLE_YAKS.get()));
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26331_, (Object)((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_YAKS.get()), (Object)((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_BABY_YAKS.get()), (Object)((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_ADULT_YAKS.get()), (Object)MemoryModuleType.f_148196_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_148197_, MemoryModuleType.f_148198_, MemoryModuleType.f_217768_, MemoryModuleType.f_26355_, MemoryModuleType.f_26375_, MemoryModuleType.f_148202_, MemoryModuleType.f_148203_, MemoryModuleType.f_26383_, MemoryModuleType.f_26334_, MemoryModuleType.f_26335_, MemoryModuleType.f_26381_, MemoryModuleType.f_26382_, MemoryModuleType.f_26372_, MemoryModuleType.f_26373_, (MemoryModuleType)EnvironmentalMemoryModuleTypes.GRAZING_TICKS.get(), (MemoryModuleType)EnvironmentalMemoryModuleTypes.SINCE_LAST_HERD.get(), (MemoryModuleType)EnvironmentalMemoryModuleTypes.HERDING_POSITION.get()});

    static Brain.Provider<Yak> createProvider() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    static Brain<?> createBrain(Yak yak, Brain<Yak> brain) {
        Yaktelligence.learnCoreActivities(brain);
        Yaktelligence.learnIdleActivities(brain);
        Yaktelligence.learnAvoidActivities(brain);
        Yaktelligence.learnFightActivities(yak, brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    static void createMemories(Yak yak, RandomSource random) {
        yak.m_6274_().m_21879_(MemoryModuleType.f_148202_, (Object)TIME_BETWEEN_RAMS.m_214085_(random));
    }

    private static BehaviorControl<Yak> createIdleMoveBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static BehaviorControl<Yak> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static void learnCoreActivities(Brain<Yak> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), YakHerdingBehavior.createHerdingController(), YakGrazeBehavior.createGrazeController(), (Object)StopBeingAngryIfTargetDead.m_257993_(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148202_)));
    }

    private static void learnIdleActivities(Brain<Yak> brain) {
        brain.m_21903_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)StartAttacking.m_257741_(yak -> !yak.m_6162_(), Yaktelligence::findNearestValidAttackTarget)), (Object)Pair.of((Object)1, (Object)new AnimalMakeLove((EntityType)EnvironmentalEntityTypes.YAK.get(), 1.0f)), (Object)Pair.of((Object)2, (Object)new FollowTemptation(yak -> Float.valueOf(1.1f))), (Object)Pair.of((Object)3, (Object)BabyFollowAdult.m_257685_((UniformInt)ADULT_FOLLOW_RANGE, (float)1.1f)), (Object)Pair.of((Object)4, Yaktelligence.createIdleMoveBehaviors()), (Object)Pair.of((Object)4, Yaktelligence.createIdleLookBehaviors()), (Object)Pair.of((Object)5, (Object)((Object)new YakGrazeBehavior())), (Object)Pair.of((Object)6, (Object)((Object)new YakHerdingBehavior())), (Object)Pair.of((Object)7, (Object)((Object)new YakMoveToRestrictionBehavior(1.0f)))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148203_, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void learnAvoidActivities(Brain<Yak> yak) {
        yak.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.m_257370_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.1f, (int)12, (boolean)true), Yaktelligence.createIdleLookBehaviors(), Yaktelligence.createIdleMoveBehaviors()), MemoryModuleType.f_26383_);
    }

    private static void learnFightActivities(Yak yak, Brain<Yak> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)StopAttackingIfTargetInvalid.m_257990_(target -> !Yaktelligence.isNearestValidAttackTarget(yak, target)), (Object)((Object)new YakRamBehavior(y -> TIME_BETWEEN_RAMS, 2.0f, y -> 2.5, y -> (SoundEvent)EnvironmentalSoundEvents.YAK_RAM.get())), (Object)((Object)new YakPrepareRamBehavior(y -> TIME_BETWEEN_RAMS.m_142739_(), 10, y -> (SoundEvent)EnvironmentalSoundEvents.YAK_CHARGE.get())), (Object)BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_257492_(MemoryModuleType.f_26370_), (App)instance.m_257492_(MemoryModuleType.f_26371_), (App)instance.m_257495_(MemoryModuleType.f_26372_), (App)instance.m_257492_(MemoryModuleType.f_148205_), (App)instance.m_258080_(MemoryModuleType.f_148203_)).apply((Applicative)instance, (walkTarget, lookTarget, attackTarget, nearestVisibleLivingEntities, ramTarget) -> (level, y, gameTime) -> {
            LivingEntity entity = (LivingEntity)instance.m_258051_(attackTarget);
            Optional visibleEntities = instance.m_257828_(nearestVisibleLivingEntities);
            if (visibleEntities.isPresent() && ((NearestVisibleLivingEntities)visibleEntities.get()).m_186107_(entity) && BehaviorUtils.m_22632_((Mob)yak, (LivingEntity)entity, (int)1)) {
                walkTarget.m_257971_();
            } else {
                lookTarget.m_257512_((Object)new EntityTracker((Entity)entity, true));
                walkTarget.m_257512_((Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)entity, false), 1.1f, 0));
            }
            return true;
        })), (Object)MeleeAttack.m_257733_((int)20)), MemoryModuleType.f_26372_);
    }

    public static boolean isFighting(Brain<Yak> brain) {
        return brain.m_21954_(Activity.f_37988_);
    }

    public static List<Yak> getNearestVisibleYaks(Yak yak) {
        return yak.m_6274_().m_21952_((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_YAKS.get()).orElse(Collections.emptyList());
    }

    public static List<Yak> getNearestVisibleAdultYaks(Yak yak) {
        return yak.m_6274_().m_21952_((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_ADULT_YAKS.get()).orElse(Collections.emptyList());
    }

    public static List<Yak> getNearestVisibleBabyYaks(Yak yak) {
        return yak.m_6274_().m_21952_((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_BABY_YAKS.get()).orElse(Collections.emptyList());
    }

    protected static void wasHurtBy(Yak yak, LivingEntity target) {
        if (target instanceof Yak) {
            return;
        }
        if (yak.m_6162_()) {
            Yaktelligence.retreatAndAlert(yak, target);
            Yaktelligence.broadcastRetreat(yak, target);
        } else {
            Yaktelligence.retaliate(yak, target);
            Yaktelligence.broadcastRetreat(yak, target);
        }
    }

    protected static void retaliate(Yak yak, LivingEntity target) {
        if (yak.m_6274_().m_21954_(Activity.f_37991_)) {
            return;
        }
        Brain<Yak> brain = yak.m_6274_();
        brain.m_21936_((MemoryModuleType)EnvironmentalMemoryModuleTypes.HERDING_POSITION.get());
        if (Sensor.m_182377_((LivingEntity)yak, (LivingEntity)target) && !BehaviorUtils.m_22598_((LivingEntity)yak, (LivingEntity)target, (double)4.0)) {
            if (target.m_6095_() == EntityType.f_20532_ && yak.m_9236_().m_46469_().m_46207_(GameRules.f_46127_)) {
                Yaktelligence.setAngerTargetToNearestTargetablePlayerIfFound(yak, target);
                Yaktelligence.broadcastUniversalAnger(yak);
            } else {
                Yaktelligence.setAngerTarget(yak, target);
                Yaktelligence.broadcastAngerTarget(yak, target);
            }
        }
    }

    protected static void retreatAndAlert(Yak yak, LivingEntity target) {
        yak.m_6274_().m_21882_(MemoryModuleType.f_26383_, (Object)target, 100L);
        if (Sensor.m_182377_((LivingEntity)yak, (LivingEntity)target)) {
            Yaktelligence.broadcastAngerTarget(yak, target);
        }
    }

    protected static void broadcastAngerTarget(Yak yak, LivingEntity target) {
        Yaktelligence.getNearestVisibleAdultYaks(yak).forEach(y -> Yaktelligence.setAngerTargetIfCloserThanCurrent(y, target));
    }

    private static void broadcastRetreat(Yak yak, LivingEntity target) {
        Yaktelligence.getNearestVisibleBabyYaks(yak).forEach(y -> Yaktelligence.retreatAndAlert(y, target));
    }

    private static void broadcastUniversalAnger(Yak yak) {
        Yaktelligence.getNearestVisibleAdultYaks(yak).forEach(y -> Yaktelligence.getNearestVisibleTargetablePlayer(y).ifPresent(target -> Yaktelligence.setAngerTarget(y, (LivingEntity)target)));
    }

    protected static void setAngerTarget(Yak yak, LivingEntity target) {
        if (Sensor.m_182377_((LivingEntity)yak, (LivingEntity)target)) {
            yak.m_6274_().m_21936_(MemoryModuleType.f_26326_);
            yak.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)target.m_20148_(), 600L);
            if (target.m_6095_() == EntityType.f_20532_ && yak.m_9236_().m_46469_().m_46207_(GameRules.f_46127_)) {
                yak.m_6274_().m_21882_(MemoryModuleType.f_26335_, (Object)true, 600L);
            }
        }
    }

    private static void setAngerTargetToNearestTargetablePlayerIfFound(Yak yak, LivingEntity target) {
        Optional<Player> optional = Yaktelligence.getNearestVisibleTargetablePlayer(yak);
        if (optional.isPresent()) {
            Yaktelligence.setAngerTarget(yak, (LivingEntity)optional.get());
        } else {
            Yaktelligence.setAngerTarget(yak, target);
        }
    }

    private static void setAngerTargetIfCloserThanCurrent(Yak yak, LivingEntity target) {
        Optional<LivingEntity> angerTarget = Yaktelligence.getAngerTarget(yak);
        LivingEntity livingentity = BehaviorUtils.m_22625_((LivingEntity)yak, angerTarget, (LivingEntity)target);
        if (angerTarget.isEmpty() || angerTarget.get() != livingentity) {
            Yaktelligence.setAngerTarget(yak, livingentity);
        }
    }

    private static Optional<LivingEntity> getAngerTarget(Yak yak) {
        return BehaviorUtils.m_22610_((LivingEntity)yak, (MemoryModuleType)MemoryModuleType.f_26334_);
    }

    private static boolean isNearestValidAttackTarget(Yak yak, LivingEntity target) {
        return Yaktelligence.findNearestValidAttackTarget(yak).filter(entity -> entity == target).isPresent();
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Yak yak) {
        Optional player;
        Brain<Yak> brain = yak.m_6274_();
        Optional target = BehaviorUtils.m_22610_((LivingEntity)yak, (MemoryModuleType)MemoryModuleType.f_26334_);
        if (target.isPresent() && Sensor.m_182377_((LivingEntity)yak, (LivingEntity)((LivingEntity)target.get()))) {
            return target;
        }
        if (brain.m_21874_(MemoryModuleType.f_26335_) && (player = brain.m_21952_(MemoryModuleType.f_148206_)).isPresent()) {
            return player;
        }
        return Optional.empty();
    }

    public static Optional<Player> getNearestVisibleTargetablePlayer(Yak yak) {
        return yak.m_6274_().m_21874_(MemoryModuleType.f_148206_) ? yak.m_6274_().m_21952_(MemoryModuleType.f_148206_) : Optional.empty();
    }

    static void tick(Yak yak) {
        Brain<Yak> brain = yak.m_6274_();
        brain.m_21865_((ServerLevel)yak.m_9236_(), (LivingEntity)yak);
        brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37988_, (Object)Activity.f_37991_, (Object)Activity.f_37979_));
        yak.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_));
    }
}

