/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.deer;

import com.teamabnormals.environmental.common.entity.ai.goal.deer.DeerAvoidEntityGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.deer.DeerFollowParentGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.deer.DeerFrolicGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.deer.DeerGrazeGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.deer.DeerRunFromAttackerGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.deer.DeerTemptGoal;
import com.teamabnormals.environmental.core.EnvironmentalConfig;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalEntityTypeTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractDeer
extends Animal {
    private static final EntityDimensions GRAZING_DIMENSIONS = EntityDimensions.m_20395_((float)0.8f, (float)1.2f);
    private static final Predicate<LivingEntity> AVOID_ENTITY_PREDICATE = entity -> entity.m_6095_().m_204039_(EnvironmentalEntityTypeTags.SCARES_DEER) && !entity.m_20163_() && EntitySelector.f_20406_.test(entity);
    private static final Predicate<LivingEntity> TRUSTING_AVOID_ENTITY_PREDICATE = entity -> {
        TamableAnimal tamableAnimal;
        if (!entity.m_6095_().m_204039_(EnvironmentalEntityTypeTags.SCARES_TRUSTING_DEER) || entity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity).m_21824_()) {
            return false;
        }
        return !entity.m_20163_() && EntitySelector.f_20406_.test(entity);
    };
    private static final TargetingConditions AVOID_ENTITY_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_26888_(AVOID_ENTITY_PREDICATE);
    private static final TargetingConditions TRUSTING_AVOID_ENTITY_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_26888_(TRUSTING_AVOID_ENTITY_PREDICATE);
    private static final EntityDataAccessor<Integer> TARGET_NECK_ANGLE = SynchedEntityData.m_135353_(AbstractDeer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FLOWER_AMOUNT = SynchedEntityData.m_135353_(AbstractDeer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_ANTLERS = SynchedEntityData.m_135353_(AbstractDeer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TRUSTING = SynchedEntityData.m_135353_(AbstractDeer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float neckAngle;
    private float neckAngleO;
    private float sprintAmount;
    private float sprintAmountO;
    private int hopProgress;
    private float hopAmount;
    private float hopAmountO;
    private float hopAngle;
    private float hopAngleO;
    private int floweringTime;
    private final List<BlockState> flowers = new ArrayList<BlockState>();
    @Nullable
    private TemptGoal temptGoal;

    public AbstractDeer(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        this.neckAngle = 15.0f;
        this.neckAngleO = 15.0f;
        this.floweringTime = 0;
    }

    protected void m_8099_() {
        this.temptGoal = new DeerTemptGoal(this, 0.6, 1.1, this.getTemptItems());
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new DeerFollowParentGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new DeerRunFromAttackerGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new DeerAvoidEntityGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new DeerFrolicGoal(this));
        this.f_21345_.m_25352_(6, (Goal)this.temptGoal);
        this.f_21345_.m_25352_(7, (Goal)new DeerGrazeGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_NECK_ANGLE, (Object)15);
        this.f_19804_.m_135372_(FLOWER_AMOUNT, (Object)0);
        this.f_19804_.m_135372_(HAS_ANTLERS, (Object)true);
        this.f_19804_.m_135372_(TRUSTING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Antlers", this.hasAntlers());
        compound.m_128379_("Trusting", this.isTrusting());
        compound.m_128405_("FloweringTime", this.floweringTime);
        compound.m_128405_("FlowerAmount", this.getFlowerAmount());
        ListTag listtag = new ListTag();
        for (BlockState blockstate : this.flowers) {
            if (blockstate == null) continue;
            listtag.add((Object)NbtUtils.m_129202_((BlockState)blockstate));
        }
        compound.m_128365_("Flowers", (Tag)listtag);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHasAntlers(compound.m_128471_("Antlers"));
        this.setTrusting(compound.m_128471_("Trusting"));
        this.floweringTime = compound.m_128451_("FloweringTime");
        this.setFlowerAmount(compound.m_128451_("FlowerAmount"));
        ListTag listtag = compound.m_128437_("Flowers", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            BlockState blockstate = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)listtag.m_128728_(i));
            if (blockstate == null || blockstate.m_60795_()) continue;
            this.flowers.add(blockstate);
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    public void m_8024_() {
        this.m_6858_(!this.m_20069_() && this.m_21566_().m_24995_() && this.m_21566_().m_24999_() >= 1.75);
        super.m_8024_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            if (this.getFlowerAmount() > 0 && this.f_19797_ % 16 == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        } else {
            if (this.floweringTime > 0) {
                --this.floweringTime;
            }
            if (this.floweringTime <= 0 && this.getFlowerAmount() > 0 || this.getFlowerAmount() <= 0 && !this.flowers.isEmpty()) {
                this.setFlowerAmount(0);
                this.flowers.clear();
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateNeckAngle();
        this.updateSprintAnimation();
        this.updateHopAnimation();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (this.isTrusting()) {
            if (!this.m_6162_() && ((Boolean)EnvironmentalConfig.COMMON.deerFlowerReproducing.get()).booleanValue()) {
                if (stack.m_204117_(EnvironmentalItemTags.DEER_FLOWER_ITEMS)) {
                    this.setFlowerAmount(this.getFlowerAmount() + (stack.m_204117_(EnvironmentalItemTags.DEER_SUPER_FLOWER_ITEMS) ? 64 : (stack.m_204117_(EnvironmentalItemTags.DEER_STRONG_FLOWER_ITEMS) ? 16 : 4)));
                    this.floweringTime += 2400;
                    this.particleCloud((ParticleOptions)ParticleTypes.f_123748_);
                    this.m_142075_(player, hand, stack);
                    return InteractionResult.SUCCESS;
                }
                if (this.getFlowerAmount() > 0 && stack.m_204117_(EnvironmentalItemTags.DEER_PLANTABLES) && !stack.m_204117_(EnvironmentalItemTags.DEER_CANNOT_PLANT) && item instanceof BlockItem) {
                    BlockItem block = (BlockItem)item;
                    if (!this.flowers.contains(block.m_40614_().m_49966_())) {
                        this.flowers.add(block.m_40614_().m_49966_());
                        this.floweringTime = Math.max(600, this.floweringTime);
                        this.particleCloud((ParticleOptions)ParticleTypes.f_123748_);
                        this.m_142075_(player, hand, stack);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
            }
            return super.m_6071_(player, hand);
        }
        if ((player.m_7500_() || this.temptGoal == null || this.temptGoal.m_25955_()) && (this.m_6898_(stack) || stack.m_204117_(EnvironmentalItemTags.DEER_FLOWER_ITEMS))) {
            if (!this.m_9236_().f_46443_) {
                this.m_142075_(player, hand, stack);
                if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                    this.setTrusting(true);
                    this.spawnTrustingParticles(true);
                    this.m_9236_().m_7605_((Entity)this, (byte)5);
                } else {
                    this.spawnTrustingParticles(false);
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public Ingredient getTemptItems() {
        return Ingredient.m_204132_(EnvironmentalItemTags.DEER_TEMPT_ITEMS);
    }

    public void spawnFlower() {
        if (this.isSpreadingFlowers()) {
            BlockPos pos = this.m_20183_();
            BlockState state = this.flowers.get(this.f_19796_.m_188503_(this.flowers.size()));
            boolean tall = state.m_60734_() instanceof DoublePlantBlock;
            if (state.m_60710_((LevelReader)this.m_9236_(), pos) && this.m_9236_().m_46859_(pos) && (!tall || this.m_9236_().m_46859_(pos.m_7494_()))) {
                if (!tall) {
                    this.m_9236_().m_7731_(pos, state, 3);
                } else {
                    DoublePlantBlock.m_153173_((LevelAccessor)this.m_9236_(), (BlockState)state, (BlockPos)pos, (int)2);
                }
                SoundType sound = state.m_60827_();
                this.m_5496_(sound.m_56777_(), (sound.m_56773_() + 1.0f) / 4.0f, sound.m_56774_() * 0.8f);
                this.setFlowerAmount(this.getFlowerAmount() - 1);
                this.spawnBoneMealParticles(state, pos);
            }
        }
    }

    private void particleCloud(ParticleOptions particle) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(particle, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    private void spawnTrustingParticles(boolean trusts) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!trusts) {
            particleoptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    private void spawnBoneMealParticles(BlockState blockstate, BlockPos blockpos) {
        double d1;
        int amount = 15;
        double d0 = 0.5;
        if (blockstate.m_60804_((BlockGetter)this.m_9236_(), blockpos)) {
            blockpos = blockpos.m_7494_();
            amount *= 3;
            d0 = 3.0;
            d1 = 1.0;
        } else {
            d1 = blockstate.m_60808_((BlockGetter)this.m_9236_(), blockpos).m_83297_(Direction.Axis.Y);
        }
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
        RandomSource random = this.m_9236_().m_213780_();
        for (int i = 0; i < amount; ++i) {
            double d2 = random.m_188583_() * 0.02;
            double d3 = random.m_188583_() * 0.02;
            double d4 = random.m_188583_() * 0.02;
            double d5 = 0.5 - d0;
            double d6 = (double)blockpos.m_123341_() + d5 + random.m_188500_() * d0 * 2.0;
            double d7 = (double)blockpos.m_123342_() + random.m_188500_() * d1;
            double d8 = (double)blockpos.m_123343_() + d5 + random.m_188500_() * d0 * 2.0;
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, d6, d7, d8, 0, d2, d3, d4, 0.0);
        }
    }

    private void updateNeckAngle() {
        this.neckAngleO = this.neckAngle;
        int i = this.getTargetNeckAngle();
        float f = this.neckAngle + ((float)i - this.neckAngle) * 0.3f;
        this.neckAngle = this.neckAngle < (float)i == f > (float)i ? (float)i : f;
    }

    private void updateSprintAnimation() {
        this.sprintAmountO = this.sprintAmount;
        this.sprintAmount = this.m_20142_() ? Math.min(1.0f, this.sprintAmount + 0.1f) : Math.max(0.0f, this.sprintAmount - 0.1f);
    }

    private void updateHopAnimation() {
        this.hopAmountO = this.hopAmount;
        this.hopAngleO = this.hopAngle;
        if (this.hopProgress != 3) {
            --this.hopProgress;
        } else if (this.m_20096_() || this.m_20072_()) {
            this.hopProgress = 2;
        }
        if (this.hopProgress >= 3) {
            this.hopAngle = this.hopProgress > 3 ? Math.max(-0.2f, this.hopAngle - 0.18f) : Math.min(0.2f, this.hopAngle + 0.08f);
            this.hopAmount = Math.min(1.0f, this.hopAmount + 0.25f);
        } else if (this.hopAngle > 0.0f) {
            this.hopAngle = Math.max(0.0f, this.hopAngle - 0.05f);
        } else if (this.hopAngle < 0.0f) {
            this.hopAngle = Math.min(0.0f, this.hopAngle + 0.05f);
        }
        this.hopAmount = this.hopProgress > 0 ? Math.min(1.0f, this.hopAmount + 0.25f) : Math.max(0.0f, this.hopAmount - 0.25f);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return this.isGrazing() ? dimensions.f_20378_ * 0.3f : dimensions.f_20378_ * 0.95f;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.isGrazing()) {
            return GRAZING_DIMENSIONS.m_20388_(this.m_6134_());
        }
        return super.m_6972_(pose);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)EnvironmentalSoundEvents.DEER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)EnvironmentalSoundEvents.DEER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)EnvironmentalSoundEvents.DEER_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)EnvironmentalSoundEvents.DEER_STEP.get(), 0.15f, 1.0f);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (TARGET_NECK_ANGLE.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.hopProgress = 10;
        } else if (id == 5) {
            this.spawnTrustingParticles(true);
        } else if (id == 6) {
            this.spawnTrustingParticles(false);
        } else {
            super.m_7822_(id);
        }
    }

    private int getTargetNeckAngle() {
        return (Integer)this.f_19804_.m_135370_(TARGET_NECK_ANGLE);
    }

    public void setTargetNeckAngle(int angle) {
        this.f_19804_.m_135381_(TARGET_NECK_ANGLE, (Object)angle);
    }

    public void resetTargetNeckAngle() {
        this.setTargetNeckAngle(15);
    }

    public float getNeckAngle(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.neckAngleO, (float)this.neckAngle);
    }

    private boolean isGrazing() {
        return this.getTargetNeckAngle() >= 90;
    }

    public float getSprintAmount(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.sprintAmountO, (float)this.sprintAmount);
    }

    public float getHopAmount(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.hopAmountO, (float)this.hopAmount);
    }

    public float getHopAngle(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.hopAngleO, (float)this.hopAngle);
    }

    public boolean isSpreadingFlowers() {
        return this.getFlowerAmount() > 0 && !this.flowers.isEmpty();
    }

    private int getFlowerAmount() {
        return (Integer)this.f_19804_.m_135370_(FLOWER_AMOUNT);
    }

    private void setFlowerAmount(int amount) {
        this.f_19804_.m_135381_(FLOWER_AMOUNT, (Object)amount);
    }

    public void setHasAntlers(boolean antlers) {
        this.f_19804_.m_135381_(HAS_ANTLERS, (Object)antlers);
    }

    public boolean hasAntlers() {
        return (Boolean)this.f_19804_.m_135370_(HAS_ANTLERS);
    }

    public void setTrusting(boolean trusting) {
        this.f_19804_.m_135381_(TRUSTING, (Object)trusting);
    }

    public boolean isTrusting() {
        return (Boolean)this.f_19804_.m_135370_(TRUSTING);
    }

    public LivingEntity getNearestScaryEntity() {
        return this.m_9236_().m_45982_(this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82377_(10.0, 4.0, 10.0), p_148124_ -> true), this.isTrusting() ? TRUSTING_AVOID_ENTITY_TARGETING : AVOID_ENTITY_TARGETING, (LivingEntity)this, this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public static boolean checkDeerSpawnRules(EntityType<? extends AbstractDeer> deer, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource p_218296_) {
        return level.m_8055_(pos.m_7495_()).m_204336_(EnvironmentalBlockTags.DEER_SPAWNABLE_ON) && AbstractDeer.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }
}

