/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.brain.yak;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.teamabnormals.environmental.common.entity.animal.yak.Yak;
import com.teamabnormals.environmental.core.registry.EnvironmentalMemoryModuleTypes;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.joml.Vector4d;

public class YakHerdingBehavior
extends Behavior<Yak> {
    public YakHerdingBehavior() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)EnvironmentalMemoryModuleTypes.HERDING_POSITION.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    public static BehaviorControl<Yak> createHerdingController() {
        return BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_257495_((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_ADULT_YAKS.get()), (App)instance.m_257492_((MemoryModuleType)EnvironmentalMemoryModuleTypes.SINCE_LAST_HERD.get()), (App)instance.m_257492_((MemoryModuleType)EnvironmentalMemoryModuleTypes.HERDING_POSITION.get())).apply((Applicative)instance, (nearest, herdTicks, herdPos) -> (level, yak, gameTime) -> {
            int ticksSinceLastHerd = instance.m_257828_(herdTicks).orElse(0);
            if (yak.m_217043_().m_188503_(400) < ticksSinceLastHerd++) {
                ticksSinceLastHerd = 0;
                List herd = (List)instance.m_258051_(nearest);
                if (herd.isEmpty()) {
                    if (instance.m_257828_(herdPos).isEmpty() || yak.m_21523_()) {
                        yak.m_6274_().m_21962_();
                        yak.m_147271_();
                    }
                } else if (!yak.m_21533_() || instance.m_257828_(herdPos).isEmpty()) {
                    Vector4d herdVec = herd.stream().map(Entity::m_20182_).reduce(new Vector4d(0.0, 0.0, 0.0, 0.0), (a, b) -> a.add(b.f_82479_, b.f_82480_, b.f_82481_, 1.0), Vector4d::add);
                    herdVec = herdVec.div(herdVec.w);
                    herdPos.m_257465_((Object)BlockPos.m_274561_((double)herdVec.x, (double)herdVec.y, (double)herdVec.z), 1200L);
                }
            }
            herdTicks.m_257512_((Object)ticksSinceLastHerd);
            return true;
        }));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Yak yak) {
        return !yak.m_21523_() && !yak.m_6162_() && yak.m_6274_().m_21874_((MemoryModuleType)EnvironmentalMemoryModuleTypes.HERDING_POSITION.get());
    }

    protected void start(ServerLevel level, Yak yak, long gameTime) {
        yak.m_6274_().m_21952_((MemoryModuleType)EnvironmentalMemoryModuleTypes.HERDING_POSITION.get()).ifPresent(pos -> yak.m_21446_((BlockPos)pos, 10));
    }
}

