/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.teamabnormals.environmental.common.block.AbstractHibiscusBlock;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallHibiscusBlock
extends AbstractHibiscusBlock {
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)3.0, (double)3.0, (double)15.0, (double)13.0, (double)13.0, (double)16.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)13.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)15.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), (Object)Direction.UP, (Object)Block.m_49796_((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (Object)Direction.DOWN, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));

    public WallHibiscusBlock(Supplier<MobEffect> stewEffect, int stewEffectDuration, BlockBehaviour.Properties properties) {
        super(stewEffect, stewEffectDuration, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(FACE, (Comparable)AttachFace.WALL));
    }

    public String m_7705_() {
        return this.m_5456_().m_5524_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.m_60824_(level, pos);
        return AABBS.get(WallHibiscusBlock.getConnectedDirection(state).m_122424_()).m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    @Override
    protected Block getWallHibiscus() {
        return this;
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_204336_(BlockTags.f_13035_);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return this.canAttach(level, pos, WallHibiscusBlock.getConnectedDirection(state).m_122424_());
    }

    public boolean canAttach(LevelReader level, BlockPos pos, Direction direction) {
        BlockPos offsetPos = pos.m_121945_(direction);
        BlockState offsetState = level.m_8055_(offsetPos);
        return offsetState.m_60783_((BlockGetter)level, offsetPos, direction.m_122424_()) || this.m_6266_(offsetState, (BlockGetter)level, offsetPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction direction : context.m_6232_()) {
            BlockState state = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_()) : (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return state;
        }
        return null;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public float m_142740_() {
        return 0.15f;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FACE});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState otherState, LevelAccessor level, BlockPos pos, BlockPos otherPos) {
        return WallHibiscusBlock.getConnectedDirection(state).m_122424_() == direction && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, otherState, level, pos, otherPos);
    }

    public static BlockState setPropertiesForDirection(BlockState state, Direction direction, RandomSource random) {
        return (BlockState)((BlockState)state.m_61124_(FACE, (Comparable)(direction == Direction.UP ? AttachFace.FLOOR : (direction == Direction.DOWN ? AttachFace.CEILING : AttachFace.WALL)))).m_61124_((Property)FACING, (Comparable)(direction.m_122434_() == Direction.Axis.Y ? Direction.Plane.HORIZONTAL.m_235690_(random) : direction));
    }

    protected static Direction getConnectedDirection(BlockState state) {
        return switch ((AttachFace)state.m_61143_(FACE)) {
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.FLOOR -> Direction.UP;
            default -> (Direction)state.m_61143_((Property)FACING);
        };
    }
}

