/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.mimic.model;

import artifacts.Artifacts;
import artifacts.entity.MimicEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;

public class MimicModel
extends EntityModel<MimicEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Artifacts.id("mimic"), "mimic");
    protected final ModelPart bottom;
    protected final ModelPart lid;

    public MimicModel(ModelPart part) {
        this.bottom = part.m_171324_("bottom");
        this.lid = part.m_171324_("lid");
    }

    public void setupAnim(MimicEntity mimic, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void prepareMobModel(MimicEntity mimic, float limbSwing, float limbSwingAmount, float partialTicks) {
        MimicModel.setChestRotations(mimic, partialTicks, this.lid, this.bottom);
    }

    protected static void setChestRotations(MimicEntity mimic, float partialTicks, ModelPart lid, ModelPart bottom) {
        if (mimic.ticksInAir > 0) {
            lid.f_104203_ = Math.max(-60.0f, ((float)(mimic.ticksInAir - 1) + partialTicks) * -6.0f) * 0.0174533f;
            bottom.f_104203_ = Math.min(30.0f, ((float)(mimic.ticksInAir - 1) + partialTicks) * 3.0f) * 0.0174533f;
        } else {
            lid.f_104203_ = 0.0f;
            bottom.f_104203_ = 0.0f;
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.lid.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.bottom.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        mesh.m_171576_().m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171481_(-6.0f, -4.0f, -13.0f, 12.0f, 3.0f, 12.0f).m_171514_(36, 15).m_171488_(-6.0f, -1.0f, -13.0f, 12.0f, 0.0f, 12.0f, new CubeDeformation(0.02f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)7.0f));
        mesh.m_171576_().m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-6.0f, 0.0f, -13.0f, 12.0f, 3.0f, 12.0f).m_171514_(24, 0).m_171488_(-6.0f, 0.0f, -13.0f, 12.0f, 0.0f, 12.0f, new CubeDeformation(0.02f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)7.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }
}

