/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.necklace;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ShockPendantItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"passive").maxLevel(0).build()).ability(AbilityData.builder((String)"lightning").stat(StatData.builder((String)"damage").initialValue(1.0, 3.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)"chance").initialValue(0.1, 0.2).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-16740147).borderBottom(-15846034).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.COLD).build()).build();
    }

    @Mod.EventBusSubscriber
    public static class ShockPendantEvent {
        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            ShockPendantItem relic;
            Player player;
            block5: {
                block4: {
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player)) break block4;
                    player = (Player)livingEntity;
                    if (event.getSource().m_269533_(DamageTypeTags.f_268725_)) break block5;
                }
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.SHOCK_PENDANT.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof ShockPendantItem) || !(relic = (ShockPendantItem)item).canPlayerUseActiveAbility(player, stack, "passive")) {
                return;
            }
            event.setCanceled(true);
        }

        @SubscribeEvent
        public static void onReceivingDamage(LivingDamageEvent event) {
            ShockPendantItem relic;
            Item item;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.SHOCK_PENDANT.get()));
            Level level = player.m_20193_();
            if (level.m_5776_() || !((item = stack.m_41720_()) instanceof ShockPendantItem) || !(relic = (ShockPendantItem)item).canPlayerUseActiveAbility(player, stack, "lightning")) {
                return;
            }
            RandomSource random = level.m_213780_();
            Entity attacker = event.getSource().m_7639_();
            if (attacker == null || random.m_188500_() > relic.getAbilityValue(stack, "lightning", "chance")) {
                return;
            }
            relic.spreadExperience((LivingEntity)player, stack, 1);
            LightningBolt bolt = new LightningBolt(EntityType.f_20465_, level);
            bolt.m_20879_((ServerPlayer)player);
            bolt.m_146884_(attacker.m_20182_());
            bolt.m_20874_(true);
            level.m_7967_((Entity)bolt);
            attacker.f_19802_ = 0;
            attacker.m_6469_(bolt.m_269291_().m_269548_(), (float)relic.getAbilityValue(stack, "lightning", "damage"));
            ((ServerLevel)level).m_8767_(ParticleUtils.constructSimpleSpark((Color)new Color(random.m_188503_(50), random.m_188503_(50), 50 + random.m_188503_(55)), (float)0.4f, (int)30, (float)0.95f), attacker.m_20185_(), attacker.m_20186_() + (double)(attacker.m_20206_() / 2.0f), attacker.m_20189_(), 10, (double)(attacker.m_20205_() / 2.0f), (double)(attacker.m_20206_() / 2.0f), (double)(attacker.m_20205_() / 2.0f), (double)0.025f);
        }
    }
}

