/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hat;

import artifacts.registry.ModItems;
import artifacts.registry.ModSoundEvents;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketPlayerMotion;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class WhoopeeCushionItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"push").stat(StatData.builder((String)"chance").initialValue(0.2, 0.4).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.075).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).stat(StatData.builder((String)"radius").initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.05).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-2270887).borderBottom(-8639958).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.VILLAGE).entry(LootCollections.ANTHROPOGENIC).entry(LootCollections.SCULK).entry(LootCollections.JUNGLE).entry(LootCollections.DESERT).entry(LootCollections.AQUATIC).entry(LootCollections.COLD).build()).build();
    }

    public void wornTick(LivingEntity entity, ItemStack stack) {
        Player player;
        if (!(entity instanceof Player) || (player = (Player)entity).m_20193_().m_5776_() || !this.canUseAbility(stack, "push") || !player.m_20096_()) {
            return;
        }
        boolean isSneaking = player.m_6144_();
        RandomSource random = player.m_217043_();
        if (isSneaking && !this.getToggled(stack) && random.m_188500_() < this.getAbilityValue(stack, "push", "chance")) {
            this.createWhoopee((ServerLevel)player.m_9236_(), player, stack, random);
        }
        this.setToggled(stack, isSneaking);
    }

    public void setToggled(ItemStack stack, boolean val) {
        NBTUtils.setBoolean((ItemStack)stack, (String)"toggled", (boolean)val);
    }

    public boolean getToggled(ItemStack stack) {
        return NBTUtils.getBoolean((ItemStack)stack, (String)"toggled", (boolean)false);
    }

    public void createWhoopee(ServerLevel level, Player player, ItemStack stack, RandomSource random) {
        level.m_5594_(null, player.m_20183_(), (SoundEvent)ModSoundEvents.FART.get(), player.m_5720_(), 1.0f, 0.75f + player.m_217043_().m_188501_());
        this.spreadExperience((LivingEntity)player, stack, 1);
        for (LivingEntity livingEntity2 : level.m_45976_(LivingEntity.class, player.m_20191_().m_82400_(this.getAbilityValue(stack, "push", "radius"))).stream().filter(livingEntity -> !livingEntity.m_20148_().equals(player.m_20148_())).toList()) {
            Vec3 vec3 = livingEntity2.m_20182_().m_82546_(player.m_20182_()).m_82541_();
            if (livingEntity2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity2;
                NetworkHandler.sendToClient((Object)new PacketPlayerMotion(vec3.f_82479_, 0.2, vec3.f_82481_), (ServerPlayer)serverPlayer);
            } else {
                livingEntity2.m_20334_(vec3.f_82479_, 0.2, vec3.f_82481_);
            }
            livingEntity2.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 1));
        }
        level.m_8767_(ParticleUtils.constructSimpleSpark((Color)new Color(0, 100 + random.m_188503_(50), 0), (float)0.5f, (int)50, (float)0.9f), player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), 30, 0.25, 0.3, 0.25, 0.1);
    }

    @Mod.EventBusSubscriber
    public static class WhoopeeCushionEvent {
        @SubscribeEvent
        public static void onAttackPlayer(LivingHurtEvent event) {
            WhoopeeCushionItem relic;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_20193_().m_5776_() || event.getSource().m_7639_() == player) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.WHOOPEE_CUSHION.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof WhoopeeCushionItem) || !(relic = (WhoopeeCushionItem)item).canUseAbility(stack, "push") || player.m_217043_().m_188500_() > relic.getAbilityValue(stack, "push", "chance")) {
                return;
            }
            relic.createWhoopee((ServerLevel)player.m_20193_(), player, stack, player.m_217043_());
        }
    }
}

