/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.feet;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.WorldUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class SnowshoesItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"passive").maxLevel(0).build()).ability(AbilityData.builder((String)"speed").stat(StatData.builder((String)"amount").initialValue(0.2, 0.4).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-5338802).borderBottom(-10403546).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.COLD).build()).build();
    }

    public static void addSpeed(ItemStack stack, double val) {
        if (SnowshoesItem.getSpeed(stack) <= ((SnowshoesItem)stack.m_41720_()).getAbilityValue(stack, "speed", "amount") || val < 0.0) {
            SnowshoesItem.setSpeed(stack, SnowshoesItem.getSpeed(stack) + val);
        }
    }

    public static double getSpeed(ItemStack stack) {
        return NBTUtils.getDouble((ItemStack)stack, (String)"speed", (double)0.0);
    }

    public static void setSpeed(ItemStack stack, double val) {
        NBTUtils.setDouble((ItemStack)stack, (String)"speed", (double)Math.max(val, 0.0));
    }

    private static boolean isStandingOnSnow(Player player) {
        for (int i = 0; i < 8; ++i) {
            if (!player.m_20193_().m_8055_(player.m_20183_().m_175288_((int)Math.floor(WorldUtils.getGroundHeight((Entity)player, (Vec3)player.m_20182_().m_82520_(0.0, 0.1, 0.0), (int)8))).m_6625_(i)).m_204336_(BlockTags.f_144279_)) continue;
            return true;
        }
        return false;
    }

    public boolean canWalkOnPowderedSnow() {
        return true;
    }

    public void onUnequip(LivingEntity entity, ItemStack stack) {
        EntityUtils.removeAttribute((LivingEntity)entity, (ItemStack)stack, (Attribute)Attributes.f_22279_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
    }

    @Mod.EventBusSubscriber
    public static class SnowshoesEvent {
        private static final Map<Player, Vec3> lastPos = new HashMap<Player, Vec3>();

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            double modifier;
            SnowshoesItem relic;
            Player player = event.player;
            if (event.phase != TickEvent.Phase.END || player.m_20193_().m_5776_()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.SNOWSHOES.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof SnowshoesItem) || !(relic = (SnowshoesItem)item).canPlayerUseActiveAbility(player, stack, "speed")) {
                return;
            }
            Vec3 prev = lastPos.getOrDefault(player, player.m_20182_());
            Vec3 pPos = player.m_20182_();
            boolean moved = pPos.m_82557_(prev) > 1.0E-4;
            double step = 0.01;
            double d = modifier = SnowshoesItem.isStandingOnSnow(player) ? step : -step;
            if (modifier != 0.0) {
                SnowshoesItem.addSpeed(stack, modifier);
            }
            EntityUtils.resetAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)Attributes.f_22279_, (float)((float)SnowshoesItem.getSpeed(stack)), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
            if (SnowshoesItem.isStandingOnSnow(player) && player.f_19797_ % 60 == 0 && moved) {
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
            lastPos.put(player, pPos);
        }
    }
}

