/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.charm;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketItemActivation;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ChorusTotemItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"past").stat(StatData.builder((String)"chance").initialValue(0.02, 0.035).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)0)).build()).stat(StatData.builder((String)"radius").initialValue(5.0, 7.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)value, (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-7322202).borderBottom(-14318989).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.END).build()).build();
    }

    @Mod.EventBusSubscriber
    public static class ChorusTotemEvent {
        @SubscribeEvent
        public static void onDimensionChange(LivingDamageEvent event) {
            ChorusTotemItem relic;
            LivingEntity attacker;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_20193_().m_5776_() || !((livingEntity = event.getSource().m_7639_()) instanceof LivingEntity) || (attacker = livingEntity).m_20149_().equals(player.m_20149_())) {
                return;
            }
            Level level = player.m_20193_();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.CHORUS_TOTEM.get()));
            RandomSource random = level.m_213780_();
            Item item = stack.m_41720_();
            if (!(item instanceof ChorusTotemItem) || !(relic = (ChorusTotemItem)item).canPlayerUseActiveAbility(player, stack, "past") || player.m_21223_() - event.getAmount() < 1.0f || (double)(player.m_21233_() - player.m_21223_()) * relic.getAbilityValue(stack, "past", "chance") < (double)random.m_188501_()) {
                return;
            }
            attacker.m_20984_(attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), false);
            attacker.m_20334_(0.0, 0.0, 0.0);
            ChorusTotemEvent.teleportPlayerToSafeSpot(attacker, level, (int)relic.getAbilityValue(stack, "past", "radius"));
            if (attacker instanceof ServerPlayer) {
                ServerPlayer attackerPLayer = (ServerPlayer)attacker;
                NetworkHandler.sendToClient((Object)new PacketItemActivation(stack), (ServerPlayer)attackerPLayer);
                level.m_6269_(null, (Entity)player, SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 0.9f + random.m_188501_() * 0.2f);
            }
            relic.spreadExperience((LivingEntity)player, stack, 1);
        }

        public static void teleportPlayerToSafeSpot(LivingEntity attacker, Level level, int maxRadius) {
            RandomSource random = attacker.m_217043_();
            Vec3 oldPos = attacker.m_20182_();
            for (int radius = maxRadius; radius > 0; --radius) {
                double x = attacker.m_20185_() + (double)(random.m_188503_(radius * 2 + 1) - radius);
                double y = attacker.m_20186_() + ((double)random.m_188503_(radius * 2 + 1) - (double)radius / 2.0);
                double z = attacker.m_20189_() + (double)(random.m_188503_(radius * 2 + 1) - radius);
                BlockPos targetPos = new BlockPos((int)x, (int)y, (int)z);
                while (targetPos.m_123342_() > level.m_141937_() && !level.m_8055_(targetPos.m_7495_()).m_280555_()) {
                    targetPos = targetPos.m_7495_();
                }
                if (!level.m_46859_(targetPos.m_7494_())) continue;
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123760_, oldPos.f_82479_, oldPos.f_82480_ + 1.0, oldPos.f_82481_, 40, (double)-0.1f, 0.0, 0.0, 0.1);
                attacker.m_6021_((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_(), (double)targetPos.m_123343_() + 0.5);
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)targetPos.m_123341_() + 0.5, (double)(targetPos.m_123342_() + 1), (double)targetPos.m_123343_() + 0.5, 40, 0.5, 0.5, 0.5, 0.1);
                ChorusTotemEvent.createLine(level, Vec3.m_82528_((Vec3i)targetPos), oldPos);
                break;
            }
        }

        public static void createLine(Level level, Vec3 start, Vec3 end) {
            Vec3 delta = end.m_82546_(start);
            Vec3 dir = delta.m_82541_();
            double amount = delta.m_82553_() * 5.0;
            for (double i = 0.0; i < amount; i += 1.0) {
                double progress = i * delta.m_82553_() / amount;
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123760_, start.f_82479_ + dir.f_82479_ * progress, start.f_82480_ + dir.f_82480_ * progress + 1.0, start.f_82481_ + dir.f_82481_ * progress, 5, 0.1, -0.01, 0.1, 0.1);
            }
        }
    }
}

