/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.charm;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class AntidoteVesselItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"antidote").stat(StatData.builder((String)"amount").initialValue(0.2, 0.4).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).ability(AbilityData.builder((String)"devourer").requiredLevel(5).stat(StatData.builder((String)"duration").initialValue(1.0, 1.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.4).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-1991387).borderBottom(-8634333).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(15).step(100).build()).loot(LootData.builder().entry(LootCollections.JUNGLE).build()).build();
    }

    @Mod.EventBusSubscriber
    public static class AntidoteVeselEvents {
        @SubscribeEvent
        public static void onIncomingDamage(AttackEntityEvent event) {
            AntidoteVesselItem relic;
            LivingEntity target;
            Entity entity = event.getTarget();
            if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity).m_20193_().m_5776_() || target.m_21220_().isEmpty()) {
                return;
            }
            Player player = event.getEntity();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.ANTIDOTE_VESSEL.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof AntidoteVesselItem) || !(relic = (AntidoteVesselItem)item).canPlayerUseActiveAbility(player, stack, "devourer") || player.m_36403_(0.0f) <= 0.9f) {
                return;
            }
            for (MobEffectInstance activeEffect : target.m_21220_().stream().filter(effect -> effect.m_19544_().m_19486_()).toList()) {
                int transferDuration = (int)((double)activeEffect.m_19557_() - relic.getAbilityValue(stack, "devourer", "duration") * 20.0);
                target.m_21195_(activeEffect.m_19544_());
                target.m_7292_(new MobEffectInstance(activeEffect.m_19544_(), transferDuration, activeEffect.m_19564_()));
                MobEffectInstance existingEffect = player.m_21124_(activeEffect.m_19544_());
                int amplifier = existingEffect == null ? 1 : activeEffect.m_19564_();
                int transferDuration1 = (int)relic.getAbilityValue(stack, "devourer", "duration") * 20;
                if (existingEffect != null) {
                    transferDuration1 += existingEffect.m_19557_();
                    player.m_21195_(activeEffect.m_19544_());
                }
                player.m_7292_(new MobEffectInstance(activeEffect.m_19544_(), transferDuration1, amplifier));
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
        }

        @SubscribeEvent
        public static void onAddedEffect(MobEffectEvent.Added event) {
            AntidoteVesselItem relic;
            Player player;
            MobEffectInstance effectDuration = event.getEffectInstance();
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_20193_().m_5776_() || effectDuration.m_19544_().m_19486_()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.ANTIDOTE_VESSEL.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof AntidoteVesselItem) || !(relic = (AntidoteVesselItem)item).canPlayerUseActiveAbility(player, stack, "antidote")) {
                return;
            }
            if (effectDuration.m_19544_() == MobEffects.f_19594_) {
                return;
            }
            effectDuration.f_19503_ = (int)((double)effectDuration.m_19557_() * (1.0 - relic.getAbilityValue(stack, "antidote", "amount")));
            relic.spreadExperience((LivingEntity)player, stack, 1);
        }
    }
}

