/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Calendar;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11C;
import org.vivecraft.Xevents;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.gui.VivecraftClickEvent;
import org.vivecraft.client.gui.settings.GuiOtherHUDSettings;
import org.vivecraft.client.gui.settings.GuiRenderOpticsSettings;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.StencilHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MethodHolder;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.extensions.LevelRendererExtension;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.helpers.VRArmHelper;
import org.vivecraft.client_vr.render.helpers.VRWidgetHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.immersiveportals.ImmersivePortalsHelper;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class VREffectsHelper {
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final ResourceLocation SCOPE_TEXTURE = new ResourceLocation("textures/misc/spyglass_scope.png");
    private static boolean WAS_STENCIL_ON;
    private static final ResourceLocation CUBE_FRONT;
    private static final ResourceLocation CUBE_RIGHT;
    private static final ResourceLocation CUBE_BACK;
    private static final ResourceLocation CUBE_LEFT;
    private static final ResourceLocation CUBE_UP;
    private static final ResourceLocation CUBE_DOWN;
    private static final ResourceLocation DIRT;
    private static final ResourceLocation GRASS;

    public static boolean isInsideOpaqueBlock(Vec3 pos) {
        if (VREffectsHelper.MC.f_91073_ == null) {
            return false;
        }
        BlockPos blockpos = BlockPos.m_274446_((Position)pos);
        return VREffectsHelper.MC.f_91073_.m_8055_(blockpos).m_60804_((BlockGetter)VREffectsHelper.MC.f_91073_, blockpos);
    }

    public static Triple<Float, BlockState, BlockPos> getNearOpaqueBlock(Vec3 pos, double dist) {
        if (VREffectsHelper.MC.f_91073_ == null) {
            return null;
        }
        AABB aabb = new AABB(pos.m_82492_(dist, dist, dist), pos.m_82520_(dist, dist, dist));
        Stream<BlockPos> stream = BlockPos.m_121921_((AABB)aabb).filter(bp -> VREffectsHelper.MC.f_91073_.m_8055_(bp).m_60804_((BlockGetter)VREffectsHelper.MC.f_91073_, bp));
        Optional<BlockPos> optional = stream.findFirst();
        return optional.map(blockPos -> Triple.of((Object)Float.valueOf(1.0f), (Object)VREffectsHelper.MC.f_91073_.m_8055_(blockPos), (Object)blockPos)).orElse(null);
    }

    public static boolean isFirstPersonPlayer(Entity entity) {
        return VRState.VR_RUNNING && entity == VREffectsHelper.MC.f_91074_ && entity == MC.m_91288_();
    }

    public static boolean isRenderingFirstPersonPlayer(Entity entity) {
        return VREffectsHelper.isFirstPersonPlayer(entity) && VREffectsHelper.isFirstPersonEntityPass();
    }

    public static boolean isFirstPersonEntityPass() {
        return VREffectsHelper.DATA_HOLDER.vrSettings.shouldRenderSelf && RenderPass.isFirstPerson(VREffectsHelper.DATA_HOLDER.currentPass) && !ShadersHelper.isRenderingShadows() && (!ImmersivePortalsHelper.isLoaded() || !ImmersivePortalsHelper.isRenderingPortal());
    }

    public static void drawScopeFB(PoseStack poseStack, int c) {
        poseStack.m_85836_();
        RenderSystem.enableDepthTest();
        if (c == 0) {
            VREffectsHelper.DATA_HOLDER.vrRenderer.telescopeFramebufferR.m_83956_();
            RenderSystem.setShaderTexture((int)0, (int)VREffectsHelper.DATA_HOLDER.vrRenderer.telescopeFramebufferR.m_83975_());
        } else {
            VREffectsHelper.DATA_HOLDER.vrRenderer.telescopeFramebufferL.m_83956_();
            RenderSystem.setShaderTexture((int)0, (int)VREffectsHelper.DATA_HOLDER.vrRenderer.telescopeFramebufferL.m_83975_());
        }
        float scale = 0.125f;
        float alpha = TelescopeTracker.viewPercent(c);
        RenderSystem.disableBlend();
        RenderHelper.drawSizedQuadFullbright(720.0f, 720.0f, scale, new float[]{alpha, alpha, alpha, 1.0f}, poseStack.m_85850_().m_252922_(), GameRenderer::m_172661_);
        ShadersHelper.bindTexture(SCOPE_TEXTURE);
        RenderSystem.enableBlend();
        poseStack.m_252880_(0.0f, 0.0f, 1.0E-5f);
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)VREffectsHelper.MC.f_91073_, (BlockPos)BlockPos.m_274446_((Position)VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getController(c).getPosition()));
        RenderHelper.drawSizedQuadWithLightmap(720.0f, 720.0f, scale, light, poseStack.m_85850_().m_252922_(), GameRenderer::m_172679_, true);
        poseStack.m_85849_();
    }

    public static void drawEyeStencil() {
        if (VREffectsHelper.DATA_HOLDER.vrSettings.vrUseStencil) {
            if (StencilHelper.stencilBufferSupported() && (WAS_STENCIL_ON = GL11C.glIsEnabled((int)2960)) && !VREffectsHelper.DATA_HOLDER.showedStencilMessage && VREffectsHelper.DATA_HOLDER.vrSettings.showChatMessageStencil) {
                VREffectsHelper.DATA_HOLDER.showedStencilMessage = true;
                ClientUtils.addChatMessage((Component)Component.m_237110_((String)"vivecraft.messages.stencil", (Object[])new Object[]{Component.m_237110_((String)"vivecraft.messages.3options", (Object[])new Object[]{Component.m_237115_((String)"options.title"), Component.m_237115_((String)"vivecraft.options.screen.main"), Component.m_237115_((String)"vivecraft.options.screen.stereorendering")}).m_130938_(style -> style.m_131142_((ClickEvent)new VivecraftClickEvent(VivecraftClickEvent.VivecraftAction.OPEN_SCREEN, (Object)new GuiRenderOpticsSettings(null))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"vivecraft.messages.openSettings"))).m_131140_(ChatFormatting.GREEN).m_131155_(Boolean.valueOf(true))), Component.m_237110_((String)"vivecraft.messages.3options", (Object[])new Object[]{Component.m_237115_((String)"options.title"), Component.m_237115_((String)"vivecraft.options.screen.main"), Component.m_237115_((String)"vivecraft.options.screen.guiother")}).m_130938_(style -> style.m_131142_((ClickEvent)new VivecraftClickEvent(VivecraftClickEvent.VivecraftAction.OPEN_SCREEN, (Object)new GuiOtherHUDSettings(null))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"vivecraft.messages.openSettings"))).m_131140_(ChatFormatting.GREEN).m_131155_(Boolean.valueOf(true)))}));
            }
            if (!(VREffectsHelper.DATA_HOLDER.currentPass != RenderPass.LEFT && VREffectsHelper.DATA_HOLDER.currentPass != RenderPass.RIGHT || ImmersivePortalsHelper.isLoaded() && ImmersivePortalsHelper.isRenderingPortal())) {
                VREffectsHelper.DATA_HOLDER.vrRenderer.doStencil(false);
            }
        }
    }

    public static void disableStencilTest() {
        if (StencilHelper.stencilBufferSupported() && !WAS_STENCIL_ON) {
            GL11C.glDisable((int)2960);
        }
    }

    public static void renderMenuPanorama(PoseStack poseStack) {
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_252880_(-50.0f, -50.0f, -50.0f);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CUBE_DOWN);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, 100.0f).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 100.0f, 0.0f, 100.0f).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 100.0f, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CUBE_UP);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_252986_(matrix, 0.0f, 100.0f, 100.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, 100.0f, 0.0f).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 100.0f, 100.0f, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 100.0f, 100.0f, 100.0f).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CUBE_LEFT);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, 100.0f, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, 100.0f, 100.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, 100.0f).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CUBE_RIGHT);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_252986_(matrix, 100.0f, 0.0f, 0.0f).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 100.0f, 0.0f, 100.0f).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 100.0f, 100.0f, 100.0f).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 100.0f, 100.0f, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CUBE_FRONT);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 100.0f, 0.0f, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 100.0f, 100.0f, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, 100.0f, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CUBE_BACK);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, 100.0f).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, 100.0f, 100.0f).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 100.0f, 100.0f, 100.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(matrix, 100.0f, 0.0f, 100.0f).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        poseStack.m_85849_();
        Vector2fc area = VREffectsHelper.DATA_HOLDER.vr.getPlayAreaSize();
        if (area == null) {
            area = new Vector2f(2.0f, 2.0f);
        }
        for (int i = 0; i < 2; ++i) {
            int b;
            int g;
            int r;
            float width = area.x() + (float)(i * 2);
            float length = area.y() + (float)(i * 2);
            poseStack.m_85836_();
            RenderSystem.setShader(GameRenderer::m_172820_);
            if (i == 0) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)GRASS);
                r = 114;
                g = 148;
                b = 70;
            } else {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)DIRT);
                b = 128;
                g = 128;
                r = 128;
            }
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            poseStack.m_252880_(-width * 0.5f, 0.0f, -length * 0.5f);
            matrix = poseStack.m_85850_().m_252922_();
            int repeat = 4;
            bufferBuilder.m_252986_(matrix, 0.0f, 0.005f * (float)(-i), 0.0f).m_7421_(0.0f, 0.0f).m_6122_(r, g, b, 255).m_5752_();
            bufferBuilder.m_252986_(matrix, 0.0f, 0.005f * (float)(-i), length).m_7421_(0.0f, 4.0f * length).m_6122_(r, g, b, 255).m_5752_();
            bufferBuilder.m_252986_(matrix, width, 0.005f * (float)(-i), length).m_7421_(4.0f * width, 4.0f * length).m_6122_(r, g, b, 255).m_5752_();
            bufferBuilder.m_252986_(matrix, width, 0.005f * (float)(-i), 0.0f).m_7421_(4.0f * width, 0.0f).m_6122_(r, g, b, 255).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            poseStack.m_85849_();
        }
    }

    public static void renderJrbuddasAwesomeMainMenuRoomNew(PoseStack poseStack) {
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DIRT);
        int repeat = 4;
        float height = 2.5f;
        float oversize = 1.3f;
        Vector2fc area = VREffectsHelper.DATA_HOLDER.vr.getPlayAreaSize();
        if (area == null) {
            area = new Vector2f(2.0f, 2.0f);
        }
        float width = area.x() + oversize;
        float length = area.y() + oversize;
        float b = 0.8f;
        float g = 0.8f;
        float r = 0.8f;
        float a = 1.0f;
        poseStack.m_85836_();
        poseStack.m_252880_(-width * 0.5f, 0.0f, -length * 0.5f);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, length).m_7421_(0.0f, (float)repeat * length).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, width, 0.0f, length).m_7421_((float)repeat * width, (float)repeat * length).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, width, 0.0f, 0.0f).m_7421_((float)repeat * width, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, height, length).m_7421_(0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, height, 0.0f).m_7421_(0.0f, (float)repeat * length).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, width, height, 0.0f).m_7421_((float)repeat * width, (float)repeat * length).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, width, height, length).m_7421_((float)repeat * width, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, height, 0.0f).m_7421_(0.0f, (float)repeat * height).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, height, length).m_7421_((float)repeat * length, (float)repeat * height).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, length).m_7421_((float)repeat * length, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, width, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, width, 0.0f, length).m_7421_((float)repeat * length, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, width, height, length).m_7421_((float)repeat * length, (float)repeat * height).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, width, height, 0.0f).m_7421_(0.0f, (float)repeat * height).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, width, 0.0f, 0.0f).m_7421_((float)repeat * width, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, width, height, 0.0f).m_7421_((float)repeat * width, (float)repeat * height).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, height, 0.0f).m_7421_(0.0f, (float)repeat * height).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, length).m_7421_(0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, height, length).m_7421_(0.0f, (float)repeat * height).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, width, height, length).m_7421_((float)repeat * width, (float)repeat * height).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, width, 0.0f, length).m_7421_((float)repeat * width, 0.0f).m_85950_(r, g, b, a).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        poseStack.m_85849_();
    }

    public static void renderTechjarsAwesomeMainMenuRoom(PoseStack poseStack) {
        RenderSystem.enableBlend();
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int tzOffset = Calendar.getInstance().get(15);
        VREffectsHelper.DATA_HOLDER.menuWorldRenderer.time = VREffectsHelper.DATA_HOLDER.menuWorldRenderer.fastTime ? (long)((float)((long)VREffectsHelper.DATA_HOLDER.menuWorldRenderer.ticks * 10L) + 10.0f * ClientUtils.getCurrentPartialTick()) : (long)((double)(System.currentTimeMillis() + (long)tzOffset - 21600000L) / 8.64E7 * 24000.0);
        VREffectsHelper.DATA_HOLDER.menuWorldRenderer.fogRenderer.setupFogColor();
        RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
        VREffectsHelper.DATA_HOLDER.menuWorldRenderer.updateLightmap();
        VREffectsHelper.DATA_HOLDER.menuWorldRenderer.render(poseStack);
        Vector2fc area = VREffectsHelper.DATA_HOLDER.vr.getPlayAreaSize();
        if (area == null) {
            area = new Vector2f(2.0f, 2.0f);
        }
        float width = area.x();
        float length = area.y();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DIRT);
        float sun = VREffectsHelper.DATA_HOLDER.menuWorldRenderer.getSkyDarken();
        RenderSystem.setShaderColor((float)sun, (float)sun, (float)sun, (float)0.3f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        poseStack.m_85836_();
        poseStack.m_252880_(-width / 2.0f, 0.0f, -length / 2.0f);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        bufferBuilder.m_252986_(matrix, 0.0f, 0.005f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, 0.0f, 0.005f, length).m_7421_(0.0f, 4.0f * length).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, width, 0.005f, length).m_7421_(4.0f * width, 4.0f * length).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, width, 0.005f, 0.0f).m_7421_(4.0f * width, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    public static void renderVRFabulous(float partialTick, LevelRenderer levelRenderer, PoseStack poseStack) {
        if (VREffectsHelper.DATA_HOLDER.currentPass == RenderPass.SCOPEL || VREffectsHelper.DATA_HOLDER.currentPass == RenderPass.SCOPER) {
            return;
        }
        MC.m_91269_().m_110104_().m_109911_();
        MC.m_91307_().m_6182_("VR");
        VREffectsHelper.renderCrosshairAtDepth(!VREffectsHelper.DATA_HOLDER.vrSettings.useCrosshairOcclusion, poseStack);
        DebugRenderHelper.renderDebug(poseStack, partialTick);
        MC.m_91385_().m_83970_();
        RenderTarget occluded = ((LevelRendererExtension)levelRenderer).vivecraft$getAlphaSortVROccludedFramebuffer();
        occluded.m_83954_(Minecraft.f_91002_);
        occluded.m_83945_(MC.m_91385_());
        occluded.m_83947_(true);
        boolean renderHands = VRArmHelper.shouldRenderHands();
        if (VREffectsHelper.shouldOccludeGui()) {
            VREffectsHelper.renderGuiAndShadow(poseStack, partialTick, false, false);
            VRArmHelper.renderVRHands(partialTick, renderHands && VREffectsHelper.DATA_HOLDER.menuHandMain, renderHands && VREffectsHelper.DATA_HOLDER.menuHandOff, true, true, poseStack);
        }
        RenderTarget unOccluded = ((LevelRendererExtension)levelRenderer).vivecraft$getAlphaSortVRUnoccludedFramebuffer();
        unOccluded.m_83954_(Minecraft.f_91002_);
        unOccluded.m_83947_(true);
        if (!VREffectsHelper.shouldOccludeGui()) {
            VREffectsHelper.renderGuiAndShadow(poseStack, partialTick, false, false);
        }
        VREffectsHelper.renderVRSelfEffects(partialTick, true);
        VRWidgetHelper.renderVRThirdPersonCamWidget(poseStack);
        VRWidgetHelper.renderVRHandheldCameraWidget(poseStack);
        if (!VREffectsHelper.shouldOccludeGui()) {
            VRArmHelper.renderVRHands(partialTick, renderHands && VREffectsHelper.DATA_HOLDER.menuHandMain, renderHands && VREffectsHelper.DATA_HOLDER.menuHandOff, true, true, poseStack);
        }
        RenderTarget hands = ((LevelRendererExtension)levelRenderer).vivecraft$getAlphaSortVRHandsFramebuffer();
        hands.m_83954_(Minecraft.f_91002_);
        hands.m_83945_(MC.m_91385_());
        hands.m_83947_(true);
        VRArmHelper.renderVRHands(partialTick, renderHands && !VREffectsHelper.DATA_HOLDER.menuHandMain, renderHands && !VREffectsHelper.DATA_HOLDER.menuHandOff, false, false, poseStack);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MC.m_91385_().m_83947_(true);
    }

    public static void renderVrFast(float partialTick, boolean secondPass, PoseStack poseStack) {
        boolean renderHandsSecond;
        if (VREffectsHelper.DATA_HOLDER.currentPass == RenderPass.SCOPEL || VREffectsHelper.DATA_HOLDER.currentPass == RenderPass.SCOPER) {
            return;
        }
        MC.m_91269_().m_110104_().m_109911_();
        MC.m_91307_().m_6182_("VR");
        VREffectsHelper.MC.f_91063_.m_109154_().m_109891_();
        if (!secondPass) {
            VREffectsHelper.renderCrosshairAtDepth(!VREffectsHelper.DATA_HOLDER.vrSettings.useCrosshairOcclusion, poseStack);
            VRWidgetHelper.renderVRThirdPersonCamWidget(poseStack);
            VRWidgetHelper.renderVRHandheldCameraWidget(poseStack);
            DebugRenderHelper.renderDebug(poseStack, partialTick);
        } else {
            VREffectsHelper.renderGuiAndShadow(poseStack, partialTick, !VREffectsHelper.shouldOccludeGui(), true);
        }
        boolean bl = renderHandsSecond = RadialHandler.isShowing() || KeyboardHandler.SHOWING || Minecraft.m_91087_().f_91080_ != null;
        if (secondPass == renderHandsSecond) {
            VRArmHelper.renderVRHands(partialTick, VRArmHelper.shouldRenderHands(), VRArmHelper.shouldRenderHands(), VREffectsHelper.DATA_HOLDER.menuHandMain, VREffectsHelper.DATA_HOLDER.menuHandOff, poseStack);
        }
        VREffectsHelper.renderVRSelfEffects(partialTick, !secondPass);
    }

    private static boolean shouldOccludeGui() {
        if (RenderPass.isThirdPerson(VREffectsHelper.DATA_HOLDER.currentPass)) {
            return true;
        }
        return VREffectsHelper.DATA_HOLDER.vrSettings.hudOcclusion && !MethodHolder.isInMenuRoom() && VREffectsHelper.MC.f_91080_ == null && !KeyboardHandler.SHOWING && !RadialHandler.isShowing() && !VREffectsHelper.isInsideOpaqueBlock(VREffectsHelper.MC.f_91063_.m_109153_().m_90583_());
    }

    private static void renderGuiAndShadow(PoseStack poseStack, float partialTick, boolean depthAlways, boolean shadowFirst) {
        if (shadowFirst) {
            VREffectsHelper.renderVrShadow(partialTick, depthAlways, poseStack);
        }
        if (Minecraft.m_91087_().f_91080_ != null || !KeyboardHandler.SHOWING) {
            VREffectsHelper.renderGuiLayer(partialTick, depthAlways, poseStack);
        }
        if (!shadowFirst) {
            VREffectsHelper.renderVrShadow(partialTick, depthAlways, poseStack);
        }
        if (KeyboardHandler.SHOWING) {
            if (VREffectsHelper.DATA_HOLDER.vrSettings.physicalKeyboard) {
                VREffectsHelper.renderPhysicalKeyboard(partialTick, poseStack);
            } else {
                VREffectsHelper.render2D(partialTick, KeyboardHandler.FRAMEBUFFER, (Vector3fc)KeyboardHandler.POS_ROOM, KeyboardHandler.ROTATION_ROOM, depthAlways, poseStack);
            }
        }
        if (RadialHandler.isShowing()) {
            VREffectsHelper.render2D(partialTick, RadialHandler.FRAMEBUFFER, (Vector3fc)RadialHandler.POS_ROOM, RadialHandler.ROTATION_ROOM, depthAlways, poseStack);
        }
    }

    public static void renderVrShadow(float partialTick, boolean depthAlways, PoseStack poseStack) {
        if (RenderPass.isThirdPerson(VREffectsHelper.DATA_HOLDER.currentPass)) {
            return;
        }
        if (!VREffectsHelper.MC.f_91074_.m_6084_()) {
            return;
        }
        if (VREffectsHelper.MC.f_91074_.m_20159_() || VREffectsHelper.MC.f_91074_ != MC.m_91288_()) {
            return;
        }
        if (((PlayerExtension)VREffectsHelper.MC.f_91074_).vivecraft$getRoomYOffsetFromPose() < 0.0) {
            return;
        }
        MC.m_91307_().m_6180_("vr shadow");
        AABB aabb = VREffectsHelper.MC.f_91074_.m_20191_();
        if (VREffectsHelper.DATA_HOLDER.vrSettings.vrShowBlueCircleBuddy && aabb != null) {
            Vec3 cameraPos = VREffectsHelper.MC.f_91063_.m_109153_().m_90583_();
            Vec3 interpolatedPlayerPos = ((GameRendererExtension)VREffectsHelper.MC.f_91063_).vivecraft$getRvePos(partialTick);
            Vec3 pos = interpolatedPlayerPos.m_82546_(cameraPos).m_82520_(0.0, 0.005, 0.0);
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            if (depthAlways) {
                RenderSystem.depthFunc((int)519);
            } else {
                RenderSystem.depthFunc((int)515);
            }
            RenderSystem.setShader(GameRenderer::m_172811_);
            ShadersHelper.bindTexture(RenderHelper.WHITE_TEXTURE);
            RenderHelper.renderFlatQuad(pos, (float)(aabb.f_82291_ - aabb.f_82288_), (float)(aabb.f_82293_ - aabb.f_82290_), 0.0f, 0, 0, 0, 64, poseStack);
            RenderSystem.depthFunc((int)515);
            RenderSystem.enableCull();
        }
        MC.m_91307_().m_7238_();
    }

    private static void renderVRSelfEffects(float partialTick, boolean firstPass) {
        if (VREffectsHelper.DATA_HOLDER.currentPass != RenderPass.THIRD && VREffectsHelper.DATA_HOLDER.currentPass != RenderPass.CAMERA && !VREffectsHelper.MC.f_91074_.m_5833_() && VREffectsHelper.MC.f_91074_.m_6060_() && !Xevents.renderFireOverlay((Player)VREffectsHelper.MC.f_91074_, new PoseStack())) {
            VREffectsHelper.renderFireInFirstPerson();
        }
        if (firstPass) {
            VREffectsHelper.MC.f_91063_.m_109100_(0, 0, partialTick);
        }
    }

    public static void renderFireInFirstPerson() {
        PoseStack posestack = new PoseStack();
        RenderHelper.applyVRModelView(VREffectsHelper.DATA_HOLDER.currentPass, posestack);
        RenderHelper.applyStereo(VREffectsHelper.DATA_HOLDER.currentPass, posestack);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        if (RenderPass.isThirdPerson(VREffectsHelper.DATA_HOLDER.currentPass)) {
            RenderSystem.depthFunc((int)515);
        } else {
            RenderSystem.depthFunc((int)519);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        TextureAtlasSprite fireSprite = ModelBakery.f_119220_.m_119204_();
        if (OptifineHelper.isOptifineLoaded()) {
            OptifineHelper.markTextureAsActive(fireSprite);
        }
        RenderSystem.setShader(GameRenderer::m_172814_);
        ShadersHelper.bindTexture(fireSprite.m_247685_());
        float uMin = fireSprite.m_118409_();
        float uMax = fireSprite.m_118410_();
        float uMid = (uMin + uMax) / 2.0f;
        float vMin = fireSprite.m_118411_();
        float vMax = fireSprite.m_118412_();
        float vMid = (vMin + vMax) / 2.0f;
        float ShrinkRatio = fireSprite.m_118417_();
        float u0 = Mth.m_14179_((float)ShrinkRatio, (float)uMin, (float)uMid);
        float u1 = Mth.m_14179_((float)ShrinkRatio, (float)uMax, (float)uMid);
        float v0 = Mth.m_14179_((float)ShrinkRatio, (float)vMin, (float)vMid);
        float v1 = Mth.m_14179_((float)ShrinkRatio, (float)vMax, (float)vMid);
        float width = 0.3f;
        float headHeight = (float)(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getHeadPivot().f_82480_ - ((GameRendererExtension)VREffectsHelper.MC.f_91063_).vivecraft$getRveY());
        for (int i = 0; i < 4; ++i) {
            posestack.m_85836_();
            posestack.m_252781_(Axis.f_252436_.m_252977_((float)i * 90.0f - VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getBodyYaw()));
            posestack.m_85837_(0.0, (double)(-headHeight), 0.0);
            Matrix4f matrix = posestack.m_85850_().m_252922_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            bufferBuilder.m_252986_(matrix, -width, 0.0f, -width).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_7421_(u1, v1).m_5752_();
            bufferBuilder.m_252986_(matrix, width, 0.0f, -width).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_7421_(u0, v1).m_5752_();
            bufferBuilder.m_252986_(matrix, width, headHeight, -width).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_7421_(u0, v0).m_5752_();
            bufferBuilder.m_252986_(matrix, -width, headHeight, -width).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_7421_(u1, v0).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            posestack.m_85849_();
        }
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableBlend();
    }

    public static void renderPhysicalKeyboard(float partialTick, PoseStack poseStack) {
        if (VREffectsHelper.DATA_HOLDER.bowTracker.isDrawing()) {
            return;
        }
        MC.m_91307_().m_6180_("renderPhysicalKeyboard");
        VREffectsHelper.removeNausea(partialTick, poseStack);
        poseStack.m_85836_();
        MC.m_91307_().m_6180_("applyPhysicalKeyboardModelView");
        Vec3 eye = VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(VREffectsHelper.DATA_HOLDER.currentPass).getPosition();
        Vec3 keyboardPos = VRPlayer.roomToWorldPos((Vector3fc)KeyboardHandler.POS_ROOM, VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render);
        Matrix4f keyboardRot = new Matrix4f().rotationY(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.rotation_radians).mul((Matrix4fc)KeyboardHandler.ROTATION_ROOM);
        poseStack.m_252880_((float)(keyboardPos.f_82479_ - eye.f_82479_), (float)(keyboardPos.f_82480_ - eye.f_82480_), (float)(keyboardPos.f_82481_ - eye.f_82481_));
        poseStack.m_252931_(keyboardRot);
        float scale = VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale;
        poseStack.m_85841_(scale, scale, scale);
        MC.m_91307_().m_7238_();
        KeyboardHandler.PHYSICAL_KEYBOARD.render(poseStack);
        poseStack.m_85849_();
        VREffectsHelper.reAddNausea(poseStack);
        MC.m_91307_().m_7238_();
    }

    public static void removeNausea(float partialTick, PoseStack poseStack) {
        RenderSystem.backupProjectionMatrix();
        ((GameRendererExtension)VREffectsHelper.MC.f_91063_).vivecraft$resetProjectionMatrix(partialTick);
        if (ShadersHelper.isShaderActive()) {
            poseStack.m_85836_();
            poseStack.m_166856_();
            RenderHelper.applyVRModelView(VREffectsHelper.DATA_HOLDER.currentPass, poseStack);
        }
        PoseStack modelView = RenderSystem.getModelViewStack();
        modelView.m_85836_();
        modelView.m_166856_();
        RenderSystem.applyModelViewMatrix();
    }

    public static void reAddNausea(PoseStack poseStack) {
        RenderSystem.restoreProjectionMatrix();
        if (ShadersHelper.isShaderActive()) {
            poseStack.m_85849_();
        }
        RenderSystem.getModelViewStack().m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    private static void renderScreen(RenderTarget framebuffer, boolean depthAlways, boolean noFog, Vec3 pos, PoseStack poseStack) {
        framebuffer.m_83956_();
        RenderSystem.disableCull();
        RenderSystem.setShaderTexture((int)0, (int)framebuffer.m_83975_());
        float fogStart = RenderSystem.getShaderFogStart();
        float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        if (!MethodHolder.isInMenuRoom()) {
            if (VREffectsHelper.MC.f_91080_ == null) {
                color[3] = VREffectsHelper.DATA_HOLDER.vrSettings.hudOpacity;
            }
            if (noFog || VREffectsHelper.MC.f_91080_ != null) {
                RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
            }
            if (VREffectsHelper.MC.f_91074_ != null && VREffectsHelper.MC.f_91074_.m_6144_()) {
                color[3] = color[3] * 0.75f;
            }
            if (!ShadersHelper.isShaderActive() || VREffectsHelper.DATA_HOLDER.vrSettings.shaderGUIRender != VRSettings.ShaderGUIRender.BEFORE_TRANSLUCENT_SOLID) {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            }
        } else {
            RenderSystem.enableBlend();
        }
        if (depthAlways) {
            RenderSystem.depthFunc((int)519);
        } else {
            RenderSystem.depthFunc((int)515);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        if (VREffectsHelper.MC.f_91073_ != null) {
            if (VREffectsHelper.isInsideOpaqueBlock(pos) || ((GameRendererExtension)VREffectsHelper.MC.f_91063_).vivecraft$isInBlock() > 0.0f) {
                pos = VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getPosition();
            }
            int minLight = ShadersHelper.ShaderLight();
            int light = ClientUtils.getCombinedLightWithMin((BlockAndTintGetter)VREffectsHelper.MC.f_91073_, BlockPos.m_274446_((Position)pos), minLight);
            if (!ShadersHelper.isShaderActive() || VREffectsHelper.DATA_HOLDER.vrSettings.shaderGUIRender != VRSettings.ShaderGUIRender.BEFORE_TRANSLUCENT_SOLID) {
                RenderHelper.drawSizedQuadWithLightmap(MC.m_91268_().m_85445_(), MC.m_91268_().m_85446_(), 1.5f, light, color, poseStack.m_85850_().m_252922_(), GameRenderer::m_172679_, false);
            } else {
                RenderHelper.drawSizedQuadWithLightmap(MC.m_91268_().m_85445_(), MC.m_91268_().m_85446_(), 1.5f, light, color, poseStack.m_85850_().m_252922_(), GameRenderer::m_172667_, false);
            }
        } else {
            RenderHelper.drawSizedQuad(MC.m_91268_().m_85445_(), MC.m_91268_().m_85446_(), 1.5f, color, poseStack.m_85850_().m_252922_());
        }
        RenderSystem.setShaderFogStart((float)fogStart);
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
    }

    public static void renderGuiLayer(float partialTick, boolean depthAlways, PoseStack poseStack) {
        if (VREffectsHelper.DATA_HOLDER.bowTracker.isDrawing()) {
            return;
        }
        if (VREffectsHelper.MC.f_91080_ == null && VREffectsHelper.MC.f_91066_.f_92062_) {
            return;
        }
        if (RadialHandler.isShowing()) {
            return;
        }
        MC.m_91307_().m_6180_("GuiLayer");
        poseStack.m_85836_();
        VREffectsHelper.removeNausea(partialTick, poseStack);
        if (MethodHolder.isInMenuRoom()) {
            depthAlways = true;
            poseStack.m_85836_();
            Vec3 eye = VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(VREffectsHelper.DATA_HOLDER.currentPass).getPosition();
            poseStack.m_252880_((float)(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.origin.f_82479_ - eye.f_82479_), (float)(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.origin.f_82480_ - eye.f_82480_), (float)(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.origin.f_82481_ - eye.f_82481_));
            poseStack.m_252781_(Axis.f_252392_.m_252961_(-VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.rotation_radians));
            if (VREffectsHelper.DATA_HOLDER.menuWorldRenderer.isReady()) {
                try {
                    VREffectsHelper.renderTechjarsAwesomeMainMenuRoom(poseStack);
                }
                catch (Exception e) {
                    VRSettings.LOGGER.error("Vivecraft: Error rendering main menu world, unloading to prevent more errors: ", (Throwable)e);
                    VREffectsHelper.DATA_HOLDER.menuWorldRenderer.destroy();
                }
            } else if (VREffectsHelper.DATA_HOLDER.vrSettings.menuWorldFallbackPanorama) {
                VREffectsHelper.renderMenuPanorama(poseStack);
            } else {
                VREffectsHelper.renderJrbuddasAwesomeMainMenuRoomNew(poseStack);
            }
            poseStack.m_85849_();
        }
        Vec3 guiPos = GuiHandler.applyGUIModelView(VREffectsHelper.DATA_HOLDER.currentPass, poseStack);
        VREffectsHelper.renderScreen(GuiHandler.GUI_FRAMEBUFFER, depthAlways, false, guiPos, poseStack);
        VREffectsHelper.reAddNausea(poseStack);
        poseStack.m_85849_();
        MC.m_91307_().m_7238_();
    }

    public static void render2D(float partialTick, RenderTarget framebuffer, Vector3fc pos, Matrix4f rot, boolean depthAlways, PoseStack poseStack) {
        if (VREffectsHelper.DATA_HOLDER.bowTracker.isDrawing()) {
            return;
        }
        MC.m_91307_().m_6180_("render2D");
        poseStack.m_85836_();
        VREffectsHelper.removeNausea(partialTick, poseStack);
        MC.m_91307_().m_6180_("apply2DModelView");
        Vec3 eye = VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(VREffectsHelper.DATA_HOLDER.currentPass).getPosition();
        Vec3 worldPos = VRPlayer.roomToWorldPos(pos, VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render);
        Matrix4f worldRotation = new Matrix4f().rotationY(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.rotation_radians).mul((Matrix4fc)rot);
        poseStack.m_85837_(worldPos.f_82479_ - eye.f_82479_, worldPos.f_82480_ - eye.f_82480_, worldPos.f_82481_ - eye.f_82481_);
        poseStack.m_252931_(worldRotation);
        float scale = GuiHandler.GUI_SCALE * VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale;
        poseStack.m_85841_(scale, scale, scale);
        MC.m_91307_().m_7238_();
        VREffectsHelper.renderScreen(framebuffer, depthAlways, true, worldPos, poseStack);
        VREffectsHelper.reAddNausea(poseStack);
        poseStack.m_85849_();
        MC.m_91307_().m_7238_();
    }

    public static void renderFaceOverlay(float partialTick, PoseStack poseStack) {
        if (((GameRendererExtension)VREffectsHelper.MC.f_91063_).vivecraft$isInBlock() > 0.0f) {
            VREffectsHelper.renderFaceInBlock();
            VREffectsHelper.renderGuiAndShadow(poseStack, partialTick, true, true);
            VRArmHelper.renderVRHands(partialTick, true, true, true, true, poseStack);
        }
    }

    public static void renderFaceInBlock() {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.depthFunc((int)519);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferBuilder.m_5483_(-100.0, -100.0, -2.0).m_5752_();
        bufferBuilder.m_5483_(100.0, -100.0, -2.0).m_5752_();
        bufferBuilder.m_5483_(100.0, 100.0, -2.0).m_5752_();
        bufferBuilder.m_5483_(-100.0, 100.0, -2.0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.depthFunc((int)515);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static boolean shouldRenderCrosshair() {
        if (VREffectsHelper.DATA_HOLDER.viewOnly) {
            return false;
        }
        if (VREffectsHelper.MC.f_91073_ == null) {
            return false;
        }
        if (VREffectsHelper.MC.f_91080_ != null) {
            return false;
        }
        if (VREffectsHelper.DATA_HOLDER.vrSettings.renderInGameCrosshairMode == VRSettings.RenderPointerElement.NEVER || VREffectsHelper.DATA_HOLDER.vrSettings.renderInGameCrosshairMode == VRSettings.RenderPointerElement.WITH_HUD && VREffectsHelper.MC.f_91066_.f_92062_) {
            return false;
        }
        if (!RenderPass.isFirstPerson(VREffectsHelper.DATA_HOLDER.currentPass)) {
            return false;
        }
        if (KeyboardHandler.SHOWING) {
            return false;
        }
        if (RadialHandler.isUsingController(ControllerType.RIGHT)) {
            return false;
        }
        if (GuiHandler.GUI_POS_ROOM != null) {
            return false;
        }
        if (VREffectsHelper.DATA_HOLDER.bowTracker.isNotched()) {
            return false;
        }
        if (VREffectsHelper.DATA_HOLDER.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).isEnabledRaw(ControllerType.RIGHT) || VivecraftVRMod.INSTANCE.keyVRInteract.isDown(ControllerType.RIGHT)) {
            return false;
        }
        if (VREffectsHelper.DATA_HOLDER.vr.getInputAction(VivecraftVRMod.INSTANCE.keyClimbeyGrab).isEnabledRaw(ControllerType.RIGHT) || VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.RIGHT)) {
            return false;
        }
        if (VREffectsHelper.DATA_HOLDER.teleportTracker.isAiming()) {
            return false;
        }
        if (VREffectsHelper.DATA_HOLDER.climbTracker.isGrabbingLadder(0)) {
            return false;
        }
        return !(VREffectsHelper.DATA_HOLDER.vrPlayer.worldScale > 15.0f);
    }

    public static void renderCrosshairAtDepth(boolean depthAlways, PoseStack poseStack) {
        if (!VREffectsHelper.shouldRenderCrosshair()) {
            return;
        }
        MC.m_91307_().m_6180_("crosshair");
        Vec3 crosshairRenderPos = ((GameRendererExtension)VREffectsHelper.MC.f_91063_).vivecraft$getCrossVec();
        Vec3 crossDistance = crosshairRenderPos.m_82546_(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getAim().getPosition());
        crosshairRenderPos = crosshairRenderPos.m_82549_(crossDistance.m_82541_().m_82490_(-0.01));
        poseStack.m_85836_();
        Vector3f translate = MathUtils.subtractToVector3f(crosshairRenderPos, VREffectsHelper.MC.f_91063_.m_109153_().m_90583_());
        poseStack.m_252880_(translate.x, translate.y, translate.z);
        if (VREffectsHelper.MC.f_91077_ != null && VREffectsHelper.MC.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)VREffectsHelper.MC.f_91077_;
            switch (blockhitresult.m_82434_()) {
                case DOWN: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(-VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getAim().getYaw()));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    break;
                }
                case UP: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(-VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getAim().getYaw()));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    break;
                }
                case WEST: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    break;
                }
                case EAST: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                    break;
                }
                case SOUTH: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                }
            }
        } else {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getAim().getYaw()));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getAim().getPitch()));
        }
        float scale = (float)((double)(0.125f * VREffectsHelper.DATA_HOLDER.vrSettings.crosshairScale) * Math.sqrt(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale));
        if (VREffectsHelper.DATA_HOLDER.vrSettings.crosshairScalesWithDistance) {
            float depthScale = 0.3f + 0.2f * (float)crossDistance.m_82553_();
            scale *= depthScale;
        }
        poseStack.m_85841_(scale, scale, scale);
        VREffectsHelper.MC.f_91063_.m_109154_().m_109896_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        if (depthAlways) {
            RenderSystem.depthFunc((int)519);
        } else {
            RenderSystem.depthFunc((int)515);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)VREffectsHelper.MC.f_91073_, (BlockPos)BlockPos.m_274446_((Position)crosshairRenderPos));
        float brightness = 1.0f;
        if (VREffectsHelper.MC.f_91077_ == null || VREffectsHelper.MC.f_91077_.m_6662_() == HitResult.Type.MISS) {
            brightness = 0.5f;
        }
        ShadersHelper.bindTexture(Gui.f_279580_);
        float uMax = 0.05859375f;
        float vMax = 0.05859375f;
        RenderSystem.setShader(GameRenderer::m_172667_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), -1.0f, 1.0f, 0.0f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(uMax, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), 1.0f, 1.0f, 0.0f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), 1.0f, -1.0f, 0.0f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(0.0f, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), -1.0f, -1.0f, 0.0f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthFunc((int)515);
        poseStack.m_85849_();
        MC.m_91307_().m_7238_();
    }

    static {
        CUBE_FRONT = new ResourceLocation("textures/gui/title/background/panorama_0.png");
        CUBE_RIGHT = new ResourceLocation("textures/gui/title/background/panorama_1.png");
        CUBE_BACK = new ResourceLocation("textures/gui/title/background/panorama_2.png");
        CUBE_LEFT = new ResourceLocation("textures/gui/title/background/panorama_3.png");
        CUBE_UP = new ResourceLocation("textures/gui/title/background/panorama_4.png");
        CUBE_DOWN = new ResourceLocation("textures/gui/title/background/panorama_5.png");
        DIRT = new ResourceLocation("minecraft:textures/block/dirt.png");
        GRASS = new ResourceLocation("minecraft:textures/block/grass_block_top.png");
    }
}

