/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.provider.openvr_lwjgl.control;

import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.openvr_lwjgl.MCOpenVR;
import org.vivecraft.client_vr.provider.openvr_lwjgl.VRInputAction;

public class TrackpadSwipeSampler {
    private static final int UP = 0;
    private static final int RIGHT = 1;
    private static final int DOWN = 2;
    private static final int LEFT = 3;
    private static final float THRESHOLD = 0.5f;
    private final Vector2f[] buffer = new Vector2f[5];
    private int index;
    private long count;
    private final Vector2f accumulator = new Vector2f();
    private final int[] swiped = new int[4];

    public TrackpadSwipeSampler() {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = new Vector2f();
        }
    }

    public void update(ControllerType hand, Vector2fc position) {
        VRInputAction trackpad = MCOpenVR.get().getInputAction(VivecraftVRMod.INSTANCE.keyTrackpadTouch);
        trackpad.setCurrentHand(hand);
        if (trackpad.isButtonPressed()) {
            this.buffer[this.index].set(position.x(), position.y());
            if (++this.index >= this.buffer.length) {
                this.index = 0;
            }
            ++this.count;
        } else {
            for (Vector2f vec : this.buffer) {
                vec.set(0.0f, 0.0f);
            }
            this.count = 0L;
        }
        if (this.count >= (long)this.buffer.length) {
            int nextIndex = (this.index + 1) % this.buffer.length;
            this.accumulator.x += this.buffer[nextIndex].x - this.buffer[this.index].x;
            this.accumulator.y += this.buffer[nextIndex].y - this.buffer[this.index].y;
            if (this.accumulator.x >= 0.5f) {
                this.accumulator.x -= 0.5f;
                this.swiped[1] = this.swiped[1] + 1;
            }
            if (this.accumulator.x <= -0.5f) {
                this.accumulator.x += 0.5f;
                this.swiped[3] = this.swiped[3] + 1;
            }
            if (this.accumulator.y >= 0.5f) {
                this.accumulator.y -= 0.5f;
                this.swiped[0] = this.swiped[0] + 1;
            }
            if (this.accumulator.y <= -0.5f) {
                this.accumulator.y += 0.5f;
                this.swiped[2] = this.swiped[2] + 1;
            }
        } else {
            this.accumulator.set(0.0f, 0.0f);
        }
    }

    public boolean isSwipedLeft() {
        return this.isSwiped(3);
    }

    public boolean isSwipedRight() {
        return this.isSwiped(1);
    }

    public boolean isSwipedUp() {
        return this.isSwiped(0);
    }

    public boolean isSwipedDown() {
        return this.isSwiped(2);
    }

    private boolean isSwiped(int direction) {
        if (this.swiped[direction] > 0) {
            int n = direction;
            this.swiped[n] = this.swiped[n] - 1;
            return true;
        }
        return false;
    }
}

