/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.widgets;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class TextScrollWidget
extends AbstractWidget {
    private int maxLines = 0;
    private int currentLine = 0;
    private int scrollBarSize = 0;
    private int scrollBarOffset = 0;
    private int scrollSteps = 0;
    private boolean scrollDragActive;
    private final int scrollBarWidth = 5;
    private final int padding = 5;
    private final List<FormattedCharSequence> formattedChars;

    public TextScrollWidget(int x, int y, int width, int height, String text) {
        super(x, y, width, height, (Component)Component.m_237113_((String)""));
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent mutableComponent = Component.m_237113_((String)text);
        Objects.requireNonNull(this);
        this.formattedChars = font.m_92923_((FormattedText)mutableComponent, width - 5 * 2);
        this.initScroll();
    }

    public TextScrollWidget(int x, int y, int width, int height, Component text) {
        super(x, y, width, height, (Component)Component.m_237113_((String)""));
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(this);
        this.formattedChars = font.m_92923_((FormattedText)text, width - 5 * 2);
        this.initScroll();
    }

    private void initScroll() {
        Objects.requireNonNull(this);
        this.maxLines = (this.f_93619_ - 2 - 5 + 3) / 12;
        this.currentLine = 0;
        this.scrollSteps = this.formattedChars.size() - this.maxLines;
        this.scrollSteps = Math.max(this.scrollSteps, 0);
        this.scrollBarSize = this.scrollSteps == 0 ? this.f_93619_ - 2 : (int)((float)Math.max(this.formattedChars.size(), this.maxLines) / (float)this.scrollSteps * 12.0f);
        this.scrollBarOffset = this.f_93619_ - this.scrollBarSize - 2;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float scrollbarStart;
        guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -6250336);
        guiGraphics.m_280509_(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.f_93618_ - 1, this.m_252907_() + this.f_93619_ - 1, -16777216);
        for (int line = 0; line + this.currentLine < this.formattedChars.size() && line < this.maxLines; ++line) {
            Font font = Minecraft.m_91087_().f_91062_;
            int n = this.m_252754_();
            Objects.requireNonNull(this);
            int n2 = n + 5;
            int n3 = this.m_252907_();
            Objects.requireNonNull(this);
            guiGraphics.m_280648_(font, this.formattedChars.get(line + this.currentLine), n2, n3 + 5 + line * 12, -1);
        }
        float f = scrollbarStart = this.scrollSteps == 0 ? 0.0f : (float)this.currentLine / (float)this.scrollSteps * (float)this.scrollBarOffset;
        if (this.m_93696_() || this.f_93622_) {
            int n = this.m_252754_() + this.f_93618_;
            Objects.requireNonNull(this);
            guiGraphics.m_280509_(n - 5 - 2, (int)((float)(this.m_252907_() + 1) + scrollbarStart), this.m_252754_() + this.f_93618_ - 1, (int)((float)(this.m_252907_() + 1) + scrollbarStart + (float)this.scrollBarSize), -1);
        }
        int n = this.m_252754_() + this.f_93618_;
        Objects.requireNonNull(this);
        guiGraphics.m_280509_(n - 5 - (this.m_93696_() || this.f_93622_ ? 1 : 2), (int)((float)(this.m_252907_() + (this.m_93696_() || this.f_93622_ ? 2 : 1)) + scrollbarStart), this.m_252754_() + this.f_93618_ - (this.m_93696_() || this.f_93622_ ? 2 : 1), (int)((float)(this.m_252907_() + (this.m_93696_() || this.f_93622_ ? 0 : 1)) + scrollbarStart + (float)this.scrollBarSize), -6250336);
        this.renderMouseover(guiGraphics, mouseX, mouseY);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    public void m_5716_(double mouseX, double mouseY) {
        Style style;
        int n = this.m_252754_() + this.f_93618_;
        Objects.requireNonNull(this);
        if (mouseX >= (double)(n - 5) && mouseX <= (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY <= (double)(this.m_252907_() + this.f_93619_)) {
            this.scrollDragActive = true;
            if (this.maxLines < this.formattedChars.size()) {
                this.setCurrentLineFromYPos(mouseY);
            }
        } else if (this.m_93680_(mouseX, mouseY) && (style = this.getMouseoverStyle(mouseX, mouseY)) != null && style.m_131182_() != null) {
            Minecraft.m_91087_().f_91080_.m_5561_(style);
        }
    }

    public void m_7691_(double mouseX, double mouseY) {
        this.scrollDragActive = false;
        super.m_7691_(mouseX, mouseY);
    }

    public void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.f_93624_ && this.f_93623_ && this.scrollDragActive) {
            this.setCurrentLineFromYPos(mouseY);
        }
    }

    private void setCurrentLineFromYPos(double mouseY) {
        this.currentLine = mouseY < (double)this.m_252907_() + (double)this.scrollBarSize * 0.5 ? 0 : (mouseY > (double)(this.m_252907_() + this.f_93619_) - (double)this.scrollBarSize * 0.5 ? this.scrollSteps : (int)((mouseY - (double)this.m_252907_() - (double)this.scrollBarSize * 0.5) / (double)(this.f_93619_ - this.scrollBarSize) * (double)this.scrollSteps));
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (scrollY < 0.0 && this.currentLine < this.scrollSteps) {
            ++this.currentLine;
        } else if (scrollY > 0.0 && this.currentLine > 0) {
            --this.currentLine;
        } else {
            return false;
        }
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 265 || keyCode == 264) && this.m_6050_(0.0, 0.0, keyCode == 265 ? 1.0 : -1.0)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public Style getMouseoverStyle(double mouseX, double mouseY) {
        int lineIndex = this.getLineIndex(mouseX, mouseY);
        if (lineIndex >= 0 && lineIndex < this.formattedChars.size()) {
            FormattedCharSequence line = this.formattedChars.get(lineIndex);
            return Minecraft.m_91087_().f_91062_.m_92865_().m_92338_(line, Mth.m_14107_((double)(mouseX - (double)this.m_252754_())));
        }
        return null;
    }

    private int getLineIndex(double mouseX, double mouseY) {
        if (!this.m_93680_(mouseX, mouseY)) {
            return -1;
        }
        double d = mouseY - (double)this.m_252907_();
        Objects.requireNonNull(this);
        return (int)((d - 5.0 * 0.5) / 12.0);
    }

    public void renderMouseover(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Style style = this.getMouseoverStyle(mouseX, mouseY);
        if (style != null && style.m_131186_() != null) {
            guiGraphics.m_280304_(Minecraft.m_91087_().f_91062_, style, mouseX, mouseY);
        }
    }
}

