/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureOps;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.BlackboardManager;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.renderers.SlimedRenderTypes;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ClientDynamicResourcesGenerator
extends DynClientResourcesGenerator {
    public static final ClientDynamicResourcesGenerator INSTANCE = new ClientDynamicResourcesGenerator();

    public ClientDynamicResourcesGenerator() {
        super(new DynamicTexturePack(Supplementaries.res("generated_pack")));
        ((DynamicTexturePack)this.dynamicPack).addNamespaces(new String[]{"minecraft"});
        ((DynamicTexturePack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || CommonConfigs.General.DEBUG_RESOURCES.get() != false);
    }

    public Logger getLogger() {
        return Supplementaries.LOGGER;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        SlimedRenderTypes.clear();
        BlackboardManager.closeAll();
        executor.accept((manager, sink) -> {
            GlobeManager.refreshColorsAndTextures(manager);
            ColorHelper.refreshBubbleColors(manager);
            this.addEndermanHead(manager, sink);
            this.addRopeArrowModel(manager, sink);
            this.addTatteredBook(manager, sink);
            this.addSignPostAssets(manager, sink);
        });
    }

    private void addSignPostAssets(ResourceManager manager, ResourceSink sink) {
        Respriter respriter;
        TextureImage template;
        StaticResource spItemModel = StaticResource.getOrThrow((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Supplementaries.res("sign_post_oak")));
        StaticResource spBlockModel = StaticResource.getOrThrow((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Supplementaries.res("sign_posts/sign_post_oak")));
        ModRegistry.SIGN_POST_ITEMS.forEach((wood, sign) -> {
            String id = Utils.getID((Item)sign).m_135815_();
            sink.addSimilarJsonResource(manager, spItemModel, "sign_post_oak", id);
            sink.addSimilarJsonResource(manager, spBlockModel, "sign_post_oak", id);
        });
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("item/sign_posts/template"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.SIGN_POST_ITEMS.forEach((wood, sign) -> {
                    ResourceLocation textureRes = Supplementaries.res("item/sign_posts/" + Utils.getID((Item)sign).m_135815_());
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    Item signItem = wood.getItemOfThis("sign");
                    if (signItem != null) {
                        try (TextureImage vanillaSign = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)manager, (Item)signItem));
                             TextureImage signMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("item/sign_posts/sign_board_mask"));){
                            List targetPalette = Palette.fromAnimatedImage((TextureImage)vanillaSign, (TextureImage)signMask);
                            try (TextureImage newImage = respriter.recolor(targetPalette);){
                                try (TextureImage scribbles = ClientDynamicResourcesGenerator.recolorFromVanilla(manager, vanillaSign, Supplementaries.res("item/sign_posts/sign_scribbles_mask"), Supplementaries.res("item/sign_posts/scribbles_template"));){
                                    TextureOps.applyOverlay((TextureImage)newImage, (TextureImage[])new TextureImage[]{scribbles});
                                }
                                catch (Exception ex) {
                                    this.getLogger().error("Could not properly color Sign Post item texture for {} : {}", (Object)sign, (Object)ex);
                                }
                                sink.addTexture(textureRes, newImage);
                            }
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Could not find sign texture for wood explosionType {}. Using plank texture : {}", wood, (Object)ex);
                        }
                    } else {
                        try (TextureImage plankPalette = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                            Palette targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                            try (TextureImage newImage = respriter.recolor(targetPalette);){
                                sink.addTexture(textureRes, newImage);
                            }
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Failed to generate Sign Post item texture for for {} : {}", (Object)sign, (Object)ex);
                        }
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post item texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("block/sign_posts/sign_post_oak"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.SIGN_POST_ITEMS.forEach((wood, sign) -> {
                    ResourceLocation textureRes = Supplementaries.res("block/sign_posts/" + Utils.getID((Item)sign).m_135815_());
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                        Palette palette = Palette.fromImage((TextureImage)plankTexture);
                        try (TextureImage newImage = respriter.recolor(palette);){
                            sink.addTexture(textureRes, newImage);
                        }
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to generate Sign Post block texture for for {} : {}", (Object)sign, (Object)ex);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post block texture : ", (Throwable)ex);
        }
    }

    private void addTatteredBook(ResourceManager manager, ResourceSink sink) {
        if (CommonConfigs.Tools.ANTIQUE_INK_ENABLED.get().booleanValue()) {
            sink.appendModelOverride(manager, new ResourceLocation("written_book"), e -> e.add(new ItemOverride(new ResourceLocation("item/written_book_tattered"), List.of(new ItemOverride.Predicate(Supplementaries.res("antique_ink"), 1.0f)))));
            sink.appendModelOverride(manager, new ResourceLocation("filled_map"), e -> e.add(new ItemOverride(new ResourceLocation("item/antique_map"), List.of(new ItemOverride.Predicate(Supplementaries.res("antique_ink"), 1.0f)))));
        }
    }

    private void addRopeArrowModel(ResourceManager manager, ResourceSink sink) {
        if (CommonConfigs.Tools.ROPE_ARROW_ENABLED.get().booleanValue()) {
            sink.appendModelOverride(manager, new ResourceLocation("crossbow"), e -> e.add(new ItemOverride(new ResourceLocation("item/crossbow_rope_arrow"), List.of(new ItemOverride.Predicate(new ResourceLocation("charged"), 1.0f), new ItemOverride.Predicate(Supplementaries.res("rope_arrow"), 1.0f)))));
        }
    }

    private void addEndermanHead(ResourceManager manager, ResourceSink sink) {
        if (CommonConfigs.Redstone.ENDERMAN_HEAD_ENABLED.get().booleanValue() && ClientConfigs.Tweaks.ENDERMAN_HEAD_VANILLA.get().booleanValue()) {
            try (TextureImage text = TextureImage.open((ResourceManager)manager, (ResourceLocation)new ResourceLocation("entity/enderman/enderman"));
                 TextureImage eyeText = TextureImage.open((ResourceManager)manager, (ResourceLocation)new ResourceLocation("entity/enderman/enderman_eyes"));){
                sink.addTexture(Supplementaries.res("entity/enderman_head"), text, false);
                sink.addTexture(Supplementaries.res("entity/enderman_head_eyes"), eyeText, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static TextureImage recolorFromVanilla(ResourceManager manager, TextureImage vanillaTexture, ResourceLocation vanillaMask, ResourceLocation templateTexture) {
        try (TextureImage scribbleMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)vanillaMask);){
            TextureImage textureImage;
            block14: {
                TextureImage template = TextureImage.open((ResourceManager)manager, (ResourceLocation)templateTexture);
                try {
                    Respriter respriter = Respriter.of((TextureImage)template);
                    Palette palette = Palette.fromImage((TextureImage)vanillaTexture, (TextureImage)scribbleMask);
                    textureImage = respriter.recolor(palette);
                    if (template == null) break block14;
                }
                catch (Throwable throwable) {
                    if (template != null) {
                        try {
                            template.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                template.close();
            }
            return textureImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        String bambooSpikes;
        ModRegistry.SIGN_POST_ITEMS.forEach((type, item) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.supplementaries.sign_post", (BlockType)type, (Item)item));
        if (MiscUtils.FESTIVITY.isAprilsFool()) {
            lang.addEntry("block.suppsquared.metal_frame", "Galvanized Square Steel Frame");
            lang.addEntry("block.suppsquared.metal_brace", "Galvanized Square Steel Brace");
            lang.addEntry("block.suppsquared.metal_cross_brace", "Galvanized Square Steel Cross Brace");
        }
        if ((bambooSpikes = lang.getEntry("item.supplementaries.bamboo_spikes_tipped.effect")) == null) {
            return;
        }
        for (Potion p : BuiltInRegistries.f_256980_) {
            String key = p.m_43492_("item.supplementaries.bamboo_spikes_tipped.effect.");
            String arrowName = lang.getEntry(p.m_43492_("item.minecraft.tipped_arrow.effect."));
            if (arrowName == null) {
                lang.addEntry(key, String.format(bambooSpikes, LangBuilder.getReadableName((String)Utils.getID((Potion)p).m_135815_())));
                continue;
            }
            lang.addEntry(key, String.format(bambooSpikes, LangBuilder.getReadableName((String)arrowName.toLowerCase(Locale.ROOT).replace("arrow of ", ""))));
        }
    }
}

